/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.preflight.AppCheckResult;
import com.atlassian.jira.migration.preflight.AppVendorCheckService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.SerializableCsvFileContent;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bJ\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/preflight/AppVendorCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "appVendorCheckService", "Lcom/atlassian/jira/migration/preflight/AppVendorCheckService;", "(Lcom/atlassian/jira/migration/preflight/AppVendorCheckService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "appCheckResult", "Lcom/atlassian/jira/migration/preflight/AppCheckResult;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "appKey", "checkId", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppVendorCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppVendorCheck.kt\ncom/atlassian/jira/migration/preflight/AppVendorCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,128:1\n1855#2,2:129\n125#3:131\n152#3,3:132\n*S KotlinDebug\n*F\n+ 1 AppVendorCheck.kt\ncom/atlassian/jira/migration/preflight/AppVendorCheck\n*L\n56#1:129,2\n77#1:131\n77#1:132,3\n*E\n"})
public final class AppVendorCheck
extends NotBlockingCheck {
    @NotNull
    private final AppVendorCheckService appVendorCheckService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public AppVendorCheck(@NotNull AppVendorCheckService appVendorCheckService) {
        Intrinsics.checkNotNullParameter((Object)appVendorCheckService, (String)"appVendorCheckService");
        super("App vendor checks could not be completed", "Checking that app vendor checks are complete", "App vendor checks are complete", "App vendor checks");
        this.appVendorCheckService = appVendorCheckService;
        this.checkType = CheckType.AppVendorCheck;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"planId", (Object)ctx.getPlanId()), TuplesKt.to((Object)"planName", (Object)ctx.getPlanName()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"appKeys", ctx.getAppKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"singlePathMode", (Object)((Object)ctx.getSinglePathMode()))};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public final Map<String, Object> buildCSVMap(@NotNull AppCheckResult appCheckResult) {
        Intrinsics.checkNotNullParameter((Object)appCheckResult, (String)"appCheckResult");
        Map csvMap = new LinkedHashMap();
        Object object = appCheckResult.getCsvContent();
        boolean bl = object != null && (object = ((SerializableCsvFileContent)object).getColumnHeaders()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            csvMap.put("headers", appCheckResult.getCsvContent().getColumnHeaders());
        }
        List beans = new ArrayList();
        Object object2 = appCheckResult.getCsvContent();
        if (object2 != null && (object2 = ((SerializableCsvFileContent)object2).getRows()) != null) {
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl2 = false;
                beans.add(it);
            }
        }
        if (!((Collection)beans).isEmpty()) {
            csvMap.put("beans", beans);
        }
        return csvMap;
    }

    @NotNull
    public final String getCSVFileName(@NotNull String executionId, @NotNull String appKey, @NotNull String checkId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Intrinsics.checkNotNullParameter((Object)checkId, (String)"checkId");
        return executionId + "-AppVendorCheck-" + appKey + '-' + checkId + ".csv";
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.appVendorCheckService.performCheck(checkRequest);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        void $this$inject_u24lambda_u242;
        CheckResultDto checkResultDto;
        Object object;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        super.inject(dto, checkResult);
        if (checkResult != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map = checkResult.details;
            Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, com.atlassian.jira.migration.preflight.AppCheckResult>>");
            object = this.appVendorCheckService.retrieveFailedVendorOwnedAppPreflightChecks(map);
            checkResultDto = dto;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Collection)it.getValue()).size());
            }
            checkResultDto.setNumberOfOccurrences(Integer.valueOf(CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv))));
        }
        CheckDetailsDto $i$f$map = object = new CheckDetailsDto();
        checkResultDto = dto;
        boolean bl = false;
        CheckResult checkResult2 = checkResult;
        $this$inject_u24lambda_u242.setInfo(checkResult2 != null ? checkResult2.details : null);
        $this$inject_u24lambda_u242.setLongDescription("App vendors have run checks on the apps you've marked as 'Needed in cloud' while assessing apps. We recommend that you select View all app vendor checks and resolve any warnings before continuing with the migration.");
        checkResultDto.setDetails(object);
    }
}

