/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.mapper.ExecutionErrorCodes;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.events.AppVendorCheckEvent;
import com.atlassian.jira.migration.events.AppVendorCheckEventExecutionError;
import com.atlassian.jira.migration.events.AppVendorCheckIndividualEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.preflight.AppCheckResult;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.SerializableCsvFileContent;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.migration.app.AppPreflightExecutorImpl;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.check.Container;
import com.atlassian.migration.app.check.MigrationPlanContext;
import com.atlassian.migration.app.dto.check.AppPreflightCheckResponse;
import com.atlassian.migration.app.dto.check.CheckStatus;
import com.atlassian.migration.app.dto.check.ParentAppPreflightChecksResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J.\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001e0\u00152\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u0015JB\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/preflight/AppVendorCheckService;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "appPreflightExecutorImpl", "Lcom/atlassian/migration/app/AppPreflightExecutorImpl;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/migration/app/AppPreflightExecutorImpl;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createMigrationPlanContext", "Lcom/atlassian/migration/app/check/MigrationPlanContext;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "getAppVendorCheckResult", "", "", "Lcom/atlassian/jira/migration/preflight/AppCheckResult;", "parentAppVendorCheckResponse", "", "Lcom/atlassian/migration/app/dto/check/ParentAppPreflightChecksResponse;", "isAppVendorCheckSpecsEmpty", "", "checkRequests", "", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "retrieveFailedVendorOwnedAppPreflightChecks", "appVendorCheckResult", "sendIndividualAppVendorCheckEvents", "", "preflightCheckExecutionId", "timeToComplete", "", "appVendorCheckResponse", "singlePathMode", "Lcom/atlassian/jira/migration/plan/SinglePathMode;", "migrationTag", "Lcom/atlassian/jira/migration/plan/MigrationTag;", "planId", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppVendorCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppVendorCheckService.kt\ncom/atlassian/jira/migration/preflight/AppVendorCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,214:1\n1726#2,2:215\n1726#2,3:217\n1728#2:220\n766#2:225\n857#2,2:226\n1360#2:229\n1446#2,5:230\n1549#2:235\n1620#2,3:236\n1549#2:239\n1620#2,2:240\n1549#2:242\n1620#2,3:243\n1622#2:246\n1855#2:247\n1855#2,2:248\n1856#2:250\n1#3:221\n125#4:222\n152#4,2:223\n154#4:228\n*S KotlinDebug\n*F\n+ 1 AppVendorCheckService.kt\ncom/atlassian/jira/migration/preflight/AppVendorCheckService\n*L\n64#1:215,2\n66#1:217,3\n64#1:220\n121#1:225\n121#1:226,2\n129#1:229\n129#1:230,5\n141#1:235\n141#1:236,3\n160#1:239\n160#1:240,2\n161#1:242\n161#1:243,3\n160#1:246\n193#1:247\n194#1:248,2\n193#1:250\n120#1:222\n120#1:223,2\n120#1:228\n*E\n"})
public final class AppVendorCheckService {
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final AppPreflightExecutorImpl appPreflightExecutorImpl;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final PlanRepository planRepository;
    private final Logger log;

    @Inject
    public AppVendorCheckService(@NotNull MigrationEventBus migrationEventBus, @NotNull AppPreflightExecutorImpl appPreflightExecutorImpl, @NotNull MigrationFeatures migrationFeatures, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull PlanRepository planRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)appPreflightExecutorImpl, (String)"appPreflightExecutorImpl");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        this.migrationEventBus = migrationEventBus;
        this.appPreflightExecutorImpl = appPreflightExecutorImpl;
        this.migrationFeatures = migrationFeatures;
        this.cloudSiteRepository = cloudSiteRepository;
        this.planRepository = planRepository;
        this.log = LoggerFactory.getLogger(AppVendorCheckService.class);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
                if (!this.migrationFeatures.getDisableAppVendorCheck()) break block13;
                this.log.info("Returning empty result as App vendor check is disabled.");
                v0 = new NotBlockingCheckResult(true, MapsKt.emptyMap());
                break block14;
            }
            this.log.debug("Performing check " + checkRequest.checkType);
            startTime = System.currentTimeMillis();
            v1 = checkRequest.parameters;
            v2 /* !! */  = v1 != null ? v1.get("appKeys") : null;
            Intrinsics.checkNotNull(v2 /* !! */ );
            appKeysToInclude = (Set)v2 /* !! */ ;
            v3 = checkRequest.parameters;
            planId = (String)(v3 != null ? v3.get("planId") : null);
            try {
                block15: {
                    block12: {
                        parentAppVendorCheckResponse = this.appPreflightExecutorImpl.executePreflightChecks(this.createMigrationPlanContext(checkRequest), appKeysToInclude);
                        if (parentAppVendorCheckResponse.isEmpty()) break block15;
                        $this$all$iv = parentAppVendorCheckResponse;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v4 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                block11: {
                                    allAppPreflightCheckResult = (ParentAppPreflightChecksResponse)element$iv;
                                    $i$a$-all-AppVendorCheckService$performCheck$overallParentAppVendorCheckResponseStatus$1 = false;
                                    $this$all$iv = allAppPreflightCheckResult.getAppPreflightCheckResponse();
                                    $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        v5 = true;
                                    } else {
                                        var16_18 = $this$all$iv.iterator();
                                        while (var16_18.hasNext()) {
                                            element$iv = var16_18.next();
                                            it = (AppPreflightCheckResponse)element$iv;
                                            $i$a$-all-AppVendorCheckService$performCheck$overallParentAppVendorCheckResponseStatus$1$1 = false;
                                            if (it.getStatus() == CheckStatus.SUCCESS) continue;
                                            v5 = false;
                                            break block11;
                                        }
                                        v5 = true;
                                    }
                                }
                                if (v5) continue;
                                v4 = false;
                                break block12;
                            }
                            v4 = true;
                        }
                    }
                    overallParentAppVendorCheckResponseStatus = v4;
                    appVendorCheckResult = this.getAppVendorCheckResult(parentAppVendorCheckResponse);
                    checkResult = new NotBlockingCheckResult(overallParentAppVendorCheckResponseStatus, appVendorCheckResult);
                    timeToComplete = System.currentTimeMillis() - startTime;
                    v6 = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
                    v7 = PreflightCheckKt.getUniqueId(checkRequest);
                    if (v7 == null) {
                        v7 = "";
                    }
                    this.migrationEventBus.post(new AppVendorCheckEvent("appVendorCheck", v6, v7, timeToComplete, checkResult.getHasWarnings() == false, parentAppVendorCheckResponse));
                    v8 = this;
                    v9 = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
                    v10 = timeToComplete;
                    v11 = parentAppVendorCheckResponse;
                    v12 = PreflightCheckKt.getSinglePathMode(checkRequest);
                    v13 = planId;
                    if (v13 == null) ** GOTO lbl-1000
                    $this$all$iv = v13;
                    var25_24 = v12;
                    var24_25 = v11;
                    var22_26 = v10;
                    var21_27 = v9;
                    var20_28 = v8;
                    $i$a$-let-AppVendorCheckService$performCheck$1 = false;
                    var26_29 = this.planRepository.get((String)it);
                    v8 = var20_28;
                    v9 = var21_27;
                    v10 = var22_26;
                    v11 = var24_25;
                    v12 = var25_24;
                    v14 = var26_29;
                    v13 = v14;
                    if (v14 != null) {
                        v15 = v13.getMigrationTag();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v15 = null;
                    }
                    v8.sendIndividualAppVendorCheckEvents(v9, v10, v11, v12, v15, planId);
                    return checkResult;
                }
                var6_5 = new NotBlockingCheckResult(true, MapsKt.emptyMap());
            }
            catch (Exception e) {
                this.log.error("Failed to run App Vendor Checks", (Throwable)e);
                timeToComplete = System.currentTimeMillis() - startTime;
                this.migrationEventBus.post(new AppVendorCheckEventExecutionError("appVendorCheck", PreflightCheckKt.getPreflightCheckExecutionId(checkRequest), timeToComplete));
                errorCode = ExecutionErrorCodes.GENERIC.getErrorCode();
                v16 = Collections.singletonMap("executionErrorDetails", errorCode);
                Intrinsics.checkNotNullExpressionValue(v16, (String)"singletonMap(...)");
                var6_5 = new NotBlockingCheckResult(false, v16);
            }
            v0 = var6_5;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<AppCheckResult>> retrieveFailedVendorOwnedAppPreflightChecks(@NotNull Map<String, ? extends Map<String, AppCheckResult>> appVendorCheckResult) {
        Map map;
        Intrinsics.checkNotNullParameter(appVendorCheckResult, (String)"appVendorCheckResult");
        if (!Intrinsics.areEqual(appVendorCheckResult, Collections.singletonMap("executionErrorDetails", ExecutionErrorCodes.GENERIC.getErrorCode()))) {
            void $this$mapTo$iv$iv;
            Map<String, ? extends Map<String, AppCheckResult>> $this$map$iv = appVendorCheckResult;
            boolean $i$f$map = false;
            Map<String, ? extends Map<String, AppCheckResult>> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String appKey = (String)entry.getKey();
                Map checkResults = (Map)entry.getValue();
                Iterable iterable = checkResults.values();
                String string = appKey;
                boolean $i$f$filter = false;
                void var16_16 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    AppCheckResult it = (AppCheckResult)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getStatus() != CheckStatus.SUCCESS)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                collection.add(TuplesKt.to((Object)string, (Object)((List)destination$iv$iv2)));
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAppVendorCheckSpecsEmpty(@NotNull List<? extends CheckRequest> checkRequests) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(checkRequests, (String)"checkRequests");
        Iterable $this$flatMap$iv = checkRequests;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CheckRequest checkRequest = (CheckRequest)element$iv$iv;
            boolean bl = false;
            Map map = checkRequest.parameters;
            Object object = map != null ? map.get("appKeys") : null;
            Intrinsics.checkNotNull(object);
            Iterable list$iv$iv = (Set)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List appKeysToInclude = (List)destination$iv$iv;
        return this.appPreflightExecutorImpl.isPreflightSpecsEmpty(CollectionsKt.toSet((Iterable)appKeysToInclude));
    }

    /*
     * WARNING - void declaration
     */
    private final MigrationPlanContext createMigrationPlanContext(CheckRequest checkRequest) {
        Object object;
        String string;
        Set containers;
        block7: {
            block6: {
                void it;
                String planId;
                Set set;
                Object destination$iv$iv;
                Map map = checkRequest.parameters;
                Object object2 = map != null ? map.get("projectKeys") : null;
                Intrinsics.checkNotNull(object2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                List projectKeys = (List)object2;
                if (!((Collection)projectKeys).isEmpty()) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = PreflightCheckKt.getProjectKeys(checkRequest);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string2 = (String)item$iv$iv;
                        Object object3 = destination$iv$iv;
                        boolean bl = false;
                        object3.add(new Container((String)it2, ContainerType.JiraProject.toString()));
                    }
                    set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                } else {
                    set = SetsKt.emptySet();
                }
                containers = set;
                Map map2 = checkRequest.parameters;
                string = planId = (String)(map2 != null ? map2.get("planId") : null);
                object = planId;
                if (object == null) break block6;
                destination$iv$iv = object;
                String string3 = string;
                boolean bl = false;
                Plan plan2 = this.planRepository.get((String)it);
                string = string3;
                object = plan2;
                if (plan2 != null && (object = ((Plan)object).getPlanName()) != null) break block7;
            }
            Map map = checkRequest.parameters;
            object = (String)(map != null ? map.get("planName") : null);
        }
        Map map = checkRequest.parameters;
        Object object4 = map != null ? map.get("cloudId") : null;
        Intrinsics.checkNotNull(object4, (String)"null cannot be cast to non-null type kotlin.String");
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite((String)object4);
        Intrinsics.checkNotNull((Object)cloudSite2);
        Set set = containers;
        URL uRL = cloudSite2.getCloudUrl().toURL();
        Object object5 = object;
        String string4 = string;
        return new MigrationPlanContext(string4, (String)object5, uRL, set);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, AppCheckResult>> getAppVendorCheckResult(Set<ParentAppPreflightChecksResponse> parentAppVendorCheckResponse) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = parentAppVendorCheckResponse;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void eachAppResult;
            ParentAppPreflightChecksResponse parentAppPreflightChecksResponse = (ParentAppPreflightChecksResponse)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = eachAppResult.getAppPreflightCheckResponse();
            String string = eachAppResult.getServerAppKey();
            boolean $i$f$map2 = false;
            void var14_14 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                SerializableCsvFileContent serializableCsvFileContent;
                void eachAppPreflightCheckResponse;
                AppPreflightCheckResponse appPreflightCheckResponse = (AppPreflightCheckResponse)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String checkStepsToResolve = eachAppPreflightCheckResponse.getStepsToResolve();
                String string2 = eachAppPreflightCheckResponse.getCheckId();
                String string3 = eachAppPreflightCheckResponse.getTitle();
                String string4 = checkStepsToResolve;
                if (string4 == null) {
                    string4 = "";
                }
                CheckStatus checkStatus = eachAppPreflightCheckResponse.getStatus();
                boolean bl3 = eachAppPreflightCheckResponse.getCsvFileContent() != null;
                String string5 = eachAppPreflightCheckResponse.getCheckId();
                if (eachAppPreflightCheckResponse.getCsvFileContent() != null) {
                    void it;
                    String string6 = string5;
                    boolean bl4 = bl3;
                    CheckStatus checkStatus2 = checkStatus;
                    String string7 = string4;
                    String string8 = string3;
                    String string9 = string2;
                    boolean bl5 = false;
                    SerializableCsvFileContent serializableCsvFileContent2 = new SerializableCsvFileContent(it.getColumnHeaders(), it.getRows());
                    string2 = string9;
                    string3 = string8;
                    string4 = string7;
                    checkStatus = checkStatus2;
                    bl3 = bl4;
                    string5 = string6;
                    serializableCsvFileContent = serializableCsvFileContent2;
                } else {
                    serializableCsvFileContent = null;
                }
                Set set = eachAppPreflightCheckResponse.getCheckDetails();
                SerializableCsvFileContent serializableCsvFileContent3 = serializableCsvFileContent;
                String string10 = string5;
                boolean bl6 = bl3;
                CheckStatus checkStatus3 = checkStatus;
                String string11 = string4;
                String string12 = string3;
                collection2.add(TuplesKt.to((Object)string2, (Object)new AppCheckResult(string12, string11, checkStatus3, bl6, string10, serializableCsvFileContent3, set)));
            }
            collection.add(TuplesKt.to((Object)string, (Object)MapsKt.toMap((Iterable)((List)destination$iv$iv2))));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void sendIndividualAppVendorCheckEvents(String preflightCheckExecutionId, long timeToComplete, Set<ParentAppPreflightChecksResponse> appVendorCheckResponse, SinglePathMode singlePathMode, MigrationTag migrationTag, String planId) {
        boolean devModeFFEnabled = this.migrationFeatures.getEnableAppMigrationsDevMode();
        Iterable $this$forEach$iv = appVendorCheckResponse;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParentAppPreflightChecksResponse parentResponse = (ParentAppPreflightChecksResponse)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = parentResponse.getAppPreflightCheckResponse();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AppPreflightCheckResponse appCheckResponse = (AppPreflightCheckResponse)element$iv2;
                boolean bl2 = false;
                String string = parentResponse.getServerAppKey();
                this.migrationEventBus.post(new AppVendorCheckIndividualEvent("appVendorCheckIndividual", preflightCheckExecutionId, string, timeToComplete, devModeFFEnabled, appCheckResponse, singlePathMode, planId, migrationTag));
            }
        }
    }
}

