/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.AppLicenseCheck;
import com.atlassian.jira.migration.preflight.AppWebhookEndpointCheckService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001eH\u0002J \u0010!\u001a\u00020\"2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001eH\u0002J \u0010#\u001a\u00020\u001f2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "appWebhookEndpointCheckService", "Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "retrieveAppKeyMissingWebhooks", "", "Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService$AppWebhookEndpointCheckResultDto;", "checkResultDetails", "", "", "", "retrieveExecutionError", "", "retrieveStepsToResolve", "jira-migration-plugin"})
public final class AppWebhookEndpointCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final AppWebhookEndpointCheckService appWebhookEndpointCheckService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CheckType checkType;
    private final Logger log;

    @Inject
    public AppWebhookEndpointCheck(@NotNull AppWebhookEndpointCheckService appWebhookEndpointCheckService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)appWebhookEndpointCheckService, (String)"appWebhookEndpointCheckService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.appWebhookEndpointCheckService = appWebhookEndpointCheckService;
        this.migrationFeatures = migrationFeatures;
        this.checkType = CheckType.AppWebhookEndpointCheck;
        this.log = LoggerFactory.getLogger(AppLicenseCheck.class);
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"appKeys", ctx.getAppKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block9: {
            String string;
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    string = "Checking apps registration for migration notifications";
                    break;
                }
                case 2: {
                    string = "We couldn't check if apps are registered for migration notifications";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (checkResult instanceof NotBlockingCheckResult && ((NotBlockingCheckResult)checkResult).getHasWarnings()) {
                        dto.setStatus(Status.WARNING);
                        string = "Some apps are not registered to receive migration notifications";
                        break;
                    }
                    CheckResult checkResult2 = checkResult;
                    boolean bl = checkResult2 != null ? !checkResult2.success : false;
                    if (bl) {
                        dto.setStatus(Status.ERROR);
                        string = "Some apps are not registered to receive migration notifications";
                        break;
                    }
                    dto.setStatus(Status.SUCCESS);
                    string = "All apps are registered to receive migration notifications";
                    break;
                }
                default: {
                    string = "Unknown status " + dto.getStatus();
                }
            }
            dto.setDescription(string);
            dto.setDetails(new CheckDetailsDto());
            CheckResult checkResult3 = checkResult;
            if (checkResult3 == null) break block9;
            CheckResult it = checkResult3;
            boolean bl = false;
            CheckDetailsDto details2 = new CheckDetailsDto();
            details2.setListOfOccurrences(CollectionsKt.emptyList());
            dto.setDetails(details2);
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            Set<AppWebhookEndpointCheckService.AppWebhookEndpointCheckResultDto> appWebhookEndpointCheckResult = this.retrieveAppKeyMissingWebhooks(map);
            dto.setNumberOfOccurrences(Integer.valueOf(appWebhookEndpointCheckResult.size()));
            if (!((Collection)appWebhookEndpointCheckResult).isEmpty()) {
                details2.setListOfOccurrences((List)new ArrayList(appWebhookEndpointCheckResult));
                Map map2 = checkResult.details;
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"details");
                details2.setLongDescription(this.retrieveStepsToResolve(map2));
            }
            Map map3 = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"details");
            if (this.retrieveExecutionError(map3)) {
                dto.setDescription("We couldn't check if apps are registered for migration notifications");
                details2.setLongDescription("Retry the check. If the problem persists, contact Atlassian Support.");
            }
        }
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        try {
            CheckResult checkResult2;
            CheckResult result2 = this.appWebhookEndpointCheckService.performCheck(checkRequest);
            if (!this.migrationFeatures.getAppBlockOnMissingWebhooks()) {
                boolean bl = result2.success;
                Map map = result2.details;
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
                checkResult2 = new NotBlockingCheckResult(bl, map);
            } else {
                checkResult2 = checkResult;
            }
            checkResult = checkResult2;
        }
        catch (Exception e) {
            this.log.error("Failed to perform app webhook endpoint check", (Throwable)e);
            checkResult = !this.migrationFeatures.getAppBlockOnMissingWebhooks() ? (CheckResult)new NotBlockingCheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"executionError", (Object)true))) : new CheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"executionError", (Object)true)));
        }
        return checkResult;
    }

    private final Set<AppWebhookEndpointCheckService.AppWebhookEndpointCheckResultDto> retrieveAppKeyMissingWebhooks(Map<String, ? extends Object> checkResultDetails) {
        Object object = checkResultDetails.getOrDefault("appKeysMissingWebhooks", SetsKt.emptySet());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Set<com.atlassian.jira.migration.preflight.AppWebhookEndpointCheckService.AppWebhookEndpointCheckResultDto>");
        return (Set)object;
    }

    private final String retrieveStepsToResolve(Map<String, ? extends Object> checkResultDetails) {
        Object object = checkResultDetails.getOrDefault("stepsToResolve", "");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    private final boolean retrieveExecutionError(Map<String, ? extends Object> checkResultDetails) {
        Object object = checkResultDetails.getOrDefault("executionError", (Object)false);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

