/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.amsclient.AppWebhookEndpointCheckServiceClient;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.events.AppWebhookEndpointCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.preflight.AppWebhookEndpointCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.migration.app.AbstractCloudMigrationRegistrar;
import com.atlassian.migration.app.cloud.CloudAppPlatform;
import com.atlassian.migration.app.dto.AppWebhookEndpointCheckRequest;
import com.atlassian.migration.app.dto.AppWebhookEndpointCheckResponse;
import com.atlassian.migration.app.dto.MigrationPath;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService;", "", "appWebhookEndpointCheckServiceClient", "Lcom/atlassian/jira/migration/amsclient/AppWebhookEndpointCheckServiceClient;", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "cloudMigrationRegistrar", "Lcom/atlassian/migration/app/AbstractCloudMigrationRegistrar;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "(Lcom/atlassian/jira/migration/amsclient/AppWebhookEndpointCheckServiceClient;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/migration/app/AbstractCloudMigrationRegistrar;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "buildCloudAppKeyToMaaResponseMapping", "", "", "Lcom/atlassian/jira/migration/assessment/AppAggregatorResponse;", "serverAppKeys", "", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "AppWebhookEndpointCheckResultDto", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppWebhookEndpointCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppWebhookEndpointCheckService.kt\ncom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n766#2:137\n857#2,2:138\n766#2:140\n857#2,2:141\n766#2:143\n857#2,2:144\n1549#2:146\n1620#2,3:147\n1855#2,2:150\n1855#2:152\n1855#2,2:153\n1856#2:155\n*S KotlinDebug\n*F\n+ 1 AppWebhookEndpointCheckService.kt\ncom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService\n*L\n46#1:137\n46#1:138,2\n49#1:140\n49#1:141,2\n69#1:143\n69#1:144,2\n69#1:146\n69#1:147,3\n72#1:150,2\n113#1:152\n115#1:153,2\n113#1:155\n*E\n"})
public final class AppWebhookEndpointCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppWebhookEndpointCheckServiceClient appWebhookEndpointCheckServiceClient;
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final AbstractCloudMigrationRegistrar cloudMigrationRegistrar;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final SENSupplier senSupplier;
    private static final Logger log = LoggerFactory.getLogger(AppWebhookEndpointCheckService.class);

    @Inject
    public AppWebhookEndpointCheckService(@NotNull AppWebhookEndpointCheckServiceClient appWebhookEndpointCheckServiceClient, @NotNull AppAggregatorClient appAggregatorClient, @NotNull AbstractCloudMigrationRegistrar cloudMigrationRegistrar, @NotNull MigrationEventBus migrationEventBus, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter((Object)appWebhookEndpointCheckServiceClient, (String)"appWebhookEndpointCheckServiceClient");
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)cloudMigrationRegistrar, (String)"cloudMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this.appWebhookEndpointCheckServiceClient = appWebhookEndpointCheckServiceClient;
        this.appAggregatorClient = appAggregatorClient;
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.migrationEventBus = migrationEventBus;
        this.senSupplier = senSupplier;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        AppWebhookEndpointCheckResponse.AppWebhookEndpointCheckResult it;
        void $this$filterTo$iv$iv;
        String it2;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        Set appKeysWithMissingWebhooks = null;
        Iterable iterable = PreflightCheckKt.getAppKeys(checkRequest);
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (String)element$iv$iv;
            boolean bl = false;
            if (!(this.appAggregatorClient.getServerAppData(it2).getMigrationPath() == MigrationPath.AUTOMATED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            boolean bl;
            it2 = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                bl = this.cloudMigrationRegistrar.getListenerMetadata(it2).getCloudAppPlatform() == CloudAppPlatform.CONNECT;
            }
            catch (IllegalArgumentException ex) {
                log.info("App " + it2 + " does not have listener metadata.");
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set automatedConnectAppKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (automatedConnectAppKeys.isEmpty()) {
            return new CheckResult(true);
        }
        Map<String, AppAggregatorResponse> cloudAppKeyToMaaResponseMap = this.buildCloudAppKeyToMaaResponseMapping(automatedConnectAppKeys);
        AppWebhookEndpointCheckResponse serviceClientResponse = this.appWebhookEndpointCheckServiceClient.retrieveRegisteredWebhooks(PreflightCheckKt.getCloudId(checkRequest), new AppWebhookEndpointCheckRequest(cloudAppKeyToMaaResponseMap.keySet(), "jira", this.senSupplier.getHosting().getValue()));
        Set appWebhookEndpointCheckResults = serviceClientResponse.getAppEndpoints();
        Iterable $this$filter$iv2 = appWebhookEndpointCheckResults;
        boolean $i$f$filter2 = false;
        Iterable iterable2 = $this$filter$iv2;
        Pair[] destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AppWebhookEndpointCheckResponse.AppWebhookEndpointCheckResult)element$iv$iv;
            boolean bl = false;
            if (!(!it.getAvailable())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AppWebhookEndpointCheckResponse.AppWebhookEndpointCheckResult)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getAppKey());
        }
        appKeysWithMissingWebhooks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Set appWebhookCheckResultDtos = new LinkedHashSet();
        Iterable $this$forEach$iv = appKeysWithMissingWebhooks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String appKey = (String)element$iv;
            boolean bl = false;
            AppAggregatorResponse maaResponse = cloudAppKeyToMaaResponseMap.get(appKey);
            if (maaResponse == null) continue;
            appWebhookCheckResultDtos.add(new AppWebhookEndpointCheckResultDto(maaResponse.getName(), appKey, maaResponse.getContactSupport()));
        }
        boolean success = appKeysWithMissingWebhooks.isEmpty();
        if (success) {
            checkResult = new CheckResult(true);
        } else {
            destination$iv$iv2 = new Pair[]{TuplesKt.to((Object)"appKeysMissingWebhooks", (Object)appWebhookCheckResultDtos), TuplesKt.to((Object)"stepsToResolve", (Object)serviceClientResponse.getStepsToResolve())};
            CheckResult checkResult2 = new CheckResult(false, MapsKt.mapOf((Pair[])destination$iv$iv2));
            checkResult = checkResult2;
        }
        CheckResult checkResult3 = checkResult;
        Set<String> appsWithFailedCheck2 = appWebhookCheckResultDtos.stream().map(arg_0 -> AppWebhookEndpointCheckService.performCheck$lambda$5(performCheck.appsWithFailedCheck.1.INSTANCE, arg_0)).collect(Collectors.toSet());
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        long l = (endTime - startTime) / (long)1000000;
        boolean bl = !success;
        ExportStatistics exportStatistics = ExportStatistics.Companion.getEMPTY();
        int n = PreflightCheckKt.getAppKeys(checkRequest).size();
        int n2 = appWebhookCheckResultDtos.size();
        Set<String> set = PreflightCheckKt.getAppKeys(checkRequest);
        Intrinsics.checkNotNull(appsWithFailedCheck2);
        this.migrationEventBus.post(new AppWebhookEndpointCheckEvent("appWebhookEndpointCheck", string, string2, l, bl, exportStatistics, n, n2, SetsKt.minus(set, (Iterable)appsWithFailedCheck2), appsWithFailedCheck2, PreflightCheckKt.getCloudId(checkRequest)));
        return checkResult3;
    }

    private final Map<String, AppAggregatorResponse> buildCloudAppKeyToMaaResponseMapping(Set<String> serverAppKeys) {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = serverAppKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String serverAppKey = (String)element$iv;
            boolean bl = false;
            Set cloudAppKeys = this.cloudMigrationRegistrar.getRegisteredCloudKeys(serverAppKey);
            Iterable $this$forEach$iv2 = cloudAppKeys;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String cloudAppKey = (String)element$iv2;
                boolean bl2 = false;
                AppAggregatorResponse maaResponse = this.appAggregatorClient.getCloudAppData(cloudAppKey);
                map.put(cloudAppKey, maaResponse);
            }
        }
        return map;
    }

    private static final String performCheck$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService$AppWebhookEndpointCheckResultDto;", "Ljava/io/Serializable;", "name", "", "key", "contactVendorUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getContactVendorUrl", "()Ljava/lang/String;", "getKey", "getName", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "jira-migration-plugin"})
    public static final class AppWebhookEndpointCheckResultDto
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @Nullable
        private final String name;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @NotNull
        private final String key;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        @Nullable
        private final String contactVendorUrl;
        private static final long serialVersionUID = 9015192870054121545L;

        public AppWebhookEndpointCheckResultDto(@Nullable String name, @NotNull String key, @Nullable String contactVendorUrl) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.name = name;
            this.key = key;
            this.contactVendorUrl = contactVendorUrl;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @Nullable
        public final String getContactVendorUrl() {
            return this.contactVendorUrl;
        }

        @Nullable
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.key;
        }

        @Nullable
        public final String component3() {
            return this.contactVendorUrl;
        }

        @NotNull
        public final AppWebhookEndpointCheckResultDto copy(@Nullable String name, @NotNull String key, @Nullable String contactVendorUrl) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new AppWebhookEndpointCheckResultDto(name, key, contactVendorUrl);
        }

        public static /* synthetic */ AppWebhookEndpointCheckResultDto copy$default(AppWebhookEndpointCheckResultDto appWebhookEndpointCheckResultDto, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = appWebhookEndpointCheckResultDto.name;
            }
            if ((n & 2) != 0) {
                string2 = appWebhookEndpointCheckResultDto.key;
            }
            if ((n & 4) != 0) {
                string3 = appWebhookEndpointCheckResultDto.contactVendorUrl;
            }
            return appWebhookEndpointCheckResultDto.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "AppWebhookEndpointCheckResultDto(name=" + this.name + ", key=" + this.key + ", contactVendorUrl=" + this.contactVendorUrl + ')';
        }

        public int hashCode() {
            int result2 = this.name == null ? 0 : this.name.hashCode();
            result2 = result2 * 31 + this.key.hashCode();
            result2 = result2 * 31 + (this.contactVendorUrl == null ? 0 : this.contactVendorUrl.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AppWebhookEndpointCheckResultDto)) {
                return false;
            }
            AppWebhookEndpointCheckResultDto appWebhookEndpointCheckResultDto = (AppWebhookEndpointCheckResultDto)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)appWebhookEndpointCheckResultDto.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.key, (Object)appWebhookEndpointCheckResultDto.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contactVendorUrl, (Object)appWebhookEndpointCheckResultDto.contactVendorUrl);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService$AppWebhookEndpointCheckResultDto$Companion;", "", "()V", "serialVersionUID", "", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/AppWebhookEndpointCheckService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

