/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.amsclient.DefaultAppMigrationServiceClient;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.assessment.AppAssessmentServiceKt;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.events.AppCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.preflight.AppsNotInstalledOnCloudCheckResult;
import com.atlassian.jira.migration.preflight.AppsNotInstalledOnCloudCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.migration.app.MigratabliltyInfo;
import com.atlassian.migration.app.dto.AppCloudSiteInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/preflight/AppsNotInstalledOnCloudCheckService;", "", "amsClient", "Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migratibilityInfo", "Lcom/atlassian/migration/app/MigratabliltyInfo;", "(Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/migration/app/MigratabliltyInfo;)V", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppsNotInstalledOnCloudCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppsNotInstalledOnCloudCheckService.kt\ncom/atlassian/jira/migration/preflight/AppsNotInstalledOnCloudCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1549#2:92\n1620#2,3:93\n1045#2:96\n*S KotlinDebug\n*F\n+ 1 AppsNotInstalledOnCloudCheckService.kt\ncom/atlassian/jira/migration/preflight/AppsNotInstalledOnCloudCheckService\n*L\n37#1:92\n37#1:93,3\n57#1:96\n*E\n"})
public final class AppsNotInstalledOnCloudCheckService {
    @NotNull
    private final DefaultAppMigrationServiceClient amsClient;
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MigratabliltyInfo migratibilityInfo;

    @Inject
    public AppsNotInstalledOnCloudCheckService(@NotNull DefaultAppMigrationServiceClient amsClient, @NotNull AppAggregatorClient appAggregatorClient, @NotNull PluginManager pluginManager, @NotNull MigrationEventBus migrationEventBus, @NotNull MigratabliltyInfo migratibilityInfo) {
        Intrinsics.checkNotNullParameter((Object)amsClient, (String)"amsClient");
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migratibilityInfo, (String)"migratibilityInfo");
        this.amsClient = amsClient;
        this.appAggregatorClient = appAggregatorClient;
        this.pluginManager = pluginManager;
        this.migrationEventBus = migrationEventBus;
        this.migratibilityInfo = migratibilityInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        String cloudId2 = PreflightCheckKt.getCloudId(checkRequest);
        Set<String> serverAppKeys = PreflightCheckKt.getAppKeys(checkRequest);
        Iterable $this$map$iv = serverAppKeys;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)CollectionsKt.first((Iterable)this.migratibilityInfo.getCloudAppKeys((String)it, this.appAggregatorClient.getServerAppData((String)it).getCloudKey())), (Object)it));
        }
        Map cloudAppKeysToServerAppKeys = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable<Object> $i$f$map22 = this.amsClient.getAppInfoForSite(cloudId2, CollectionsKt.toList((Iterable)cloudAppKeysToServerAppKeys.keySet())).getApps().parallelStream().filter(arg_0 -> AppsNotInstalledOnCloudCheckService.performCheck$lambda$1(performCheck.appsNotInstalledInCloudResult.1.INSTANCE, arg_0)).map(arg_0 -> AppsNotInstalledOnCloudCheckService.performCheck$lambda$2((Function1)new Function1<AppCloudSiteInfo, AppsNotInstalledOnCloudCheckResult>(this, (Map<String, String>)cloudAppKeysToServerAppKeys){
            final /* synthetic */ AppsNotInstalledOnCloudCheckService this$0;
            final /* synthetic */ Map<String, String> $cloudAppKeysToServerAppKeys;
            {
                this.this$0 = $receiver;
                this.$cloudAppKeysToServerAppKeys = $cloudAppKeysToServerAppKeys;
                super(1);
            }

            public final AppsNotInstalledOnCloudCheckResult invoke(AppCloudSiteInfo it) {
                AppAggregatorResponse appAggregatorResponse = AppsNotInstalledOnCloudCheckService.access$getAppAggregatorClient$p(this.this$0).getCloudAppData(it.getKey());
                String string = it.getKey();
                PluginManager pluginManager = AppsNotInstalledOnCloudCheckService.access$getPluginManager$p(this.this$0);
                String string2 = this.$cloudAppKeysToServerAppKeys.get(it.getKey());
                Intrinsics.checkNotNull((Object)string2);
                String string3 = AppAssessmentServiceKt.getAppName(appAggregatorResponse, pluginManager.getPlugin(string2), it.getKey());
                String string4 = appAggregatorResponse.getCloudUrl();
                if (string4 == null) {
                    string4 = "";
                }
                return new AppsNotInstalledOnCloudCheckResult(string, string3, string4);
            }
        }, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue($i$f$map22, (String)"collect(...)");
        $i$f$map22 = $i$f$map22;
        boolean $i$f$sortedBy = false;
        List appsNotInstalledInCloudResult2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AppsNotInstalledOnCloudCheckResult it = (AppsNotInstalledOnCloudCheckResult)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (AppsNotInstalledOnCloudCheckResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        CheckResult checkResult = new CheckResult(appsNotInstalledInCloudResult2.isEmpty(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"appsNotInstalledOnCloud", (Object)appsNotInstalledInCloudResult2)));
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new AppCheckEvent("appsNotInstalledOnCloudCheck", string, string2, (endTime - startTime) / (long)1000000, checkResult.success, ExportStatistics.Companion.getEMPTY(), PreflightCheckKt.getAppKeys(checkRequest).size(), appsNotInstalledInCloudResult2.size()));
        return checkResult;
    }

    private static final boolean performCheck$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final AppsNotInstalledOnCloudCheckResult performCheck$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AppsNotInstalledOnCloudCheckResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ AppAggregatorClient access$getAppAggregatorClient$p(AppsNotInstalledOnCloudCheckService $this) {
        return $this.appAggregatorClient;
    }

    public static final /* synthetic */ PluginManager access$getPluginManager$p(AppsNotInstalledOnCloudCheckService $this) {
        return $this.pluginManager;
    }
}

