/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.assessment.NotReliableApp;
import com.atlassian.jira.migration.preflight.AppsReliabilityPreflightService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001a\u001a\u00020\u0013*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/preflight/AppsReliabilityCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "appNotReliablePreflightService", "Lcom/atlassian/jira/migration/preflight/AppsReliabilityPreflightService;", "(Lcom/atlassian/jira/migration/preflight/AppsReliabilityPreflightService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getOccurrences", "", "Lcom/atlassian/jira/migration/assessment/NotReliableApp;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "setPreflightCheckError", "setPreflightCheckDetails", "result", "jira-migration-plugin"})
public final class AppsReliabilityCheck
extends NotBlockingCheck {
    @NotNull
    private final AppsReliabilityPreflightService appNotReliablePreflightService;

    @Inject
    public AppsReliabilityCheck(@NotNull AppsReliabilityPreflightService appNotReliablePreflightService) {
        Intrinsics.checkNotNullParameter((Object)appNotReliablePreflightService, (String)"appNotReliablePreflightService");
        super("We couldn't check for app migration success rate", "Checking for app migration success rate", "All apps apps selected for this migration meet migration success rate criteria", "Some apps selected for this migration have low or unknown migration success rates");
        this.appNotReliablePreflightService = appNotReliablePreflightService;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return CheckType.AppsReliabilityCheck;
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.appNotReliablePreflightService.performCheck(checkRequest);
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appKeys", ctx.getAppKeys()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        super.inject(dto, checkResult);
        if (checkResult != null) {
            CheckResultDto checkResultDto;
            CheckResultDto $this$inject_u24lambda_u240 = checkResultDto = dto;
            boolean bl = false;
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: 
                case 2: {
                    this.setPreflightCheckDetails($this$inject_u24lambda_u240, checkResult);
                    break;
                }
                case 3: {
                    this.setPreflightCheckError($this$inject_u24lambda_u240);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private final void setPreflightCheckError(CheckResultDto dto) {
        CheckResultDto checkResultDto;
        CheckResultDto $this$setPreflightCheckError_u24lambda_u241 = checkResultDto = dto;
        boolean bl = false;
        $this$setPreflightCheckError_u24lambda_u241.setStatus(Status.WARNING);
        $this$setPreflightCheckError_u24lambda_u241.setDescription("We couldn't check for app migration success rate");
    }

    /*
     * WARNING - void declaration
     */
    private final void setPreflightCheckDetails(CheckResultDto $this$setPreflightCheckDetails, CheckResult result2) {
        void $this$setPreflightCheckDetails_u24lambda_u242;
        CheckDetailsDto checkDetailsDto;
        List<NotReliableApp> occurrences = this.getOccurrences(result2);
        $this$setPreflightCheckDetails.setNumberOfOccurrences(Integer.valueOf(occurrences.size()));
        CheckDetailsDto checkDetailsDto2 = checkDetailsDto = new CheckDetailsDto();
        CheckResultDto checkResultDto = $this$setPreflightCheckDetails;
        boolean bl = false;
        $this$setPreflightCheckDetails_u24lambda_u242.setListOfOccurrences(occurrences);
        $this$setPreflightCheckDetails_u24lambda_u242.setLongDescription("Some apps selected for this migration have low or unknown migration success rates");
        checkResultDto.setDetails(checkDetailsDto);
    }

    private final List<NotReliableApp> getOccurrences(CheckResult checkResult) {
        List result2 = new ArrayList();
        CheckResult $this$getOccurrences_u24lambda_u243 = checkResult;
        boolean bl = false;
        Object v = $this$getOccurrences_u24lambda_u243.details.get("listOfOccurrences");
        Set set = v instanceof Set ? (Set)v : null;
        Collection occurrences = set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
        result2.addAll(occurrences);
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

