/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.NotReliableApp;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.plugin.Plugin;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/preflight/AppsReliabilityPreflightService;", "", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "(Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/assessment/PluginManager;)V", "getAppAggregatorClient", "()Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "getAppAssessmentService", "()Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "appIsNotReliable", "", "plugin", "Lcom/atlassian/plugin/Plugin;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppsReliabilityPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppsReliabilityPreflightService.kt\ncom/atlassian/jira/migration/preflight/AppsReliabilityPreflightService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1855#2,2:52\n*S KotlinDebug\n*F\n+ 1 AppsReliabilityPreflightService.kt\ncom/atlassian/jira/migration/preflight/AppsReliabilityPreflightService\n*L\n23#1:52,2\n*E\n"})
public final class AppsReliabilityPreflightService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final AppAssessmentService appAssessmentService;
    @NotNull
    private final PluginManager pluginManager;
    private static final Logger log = LoggerFactory.getLogger(AppsReliabilityPreflightService.class);

    @Inject
    public AppsReliabilityPreflightService(@NotNull AppAggregatorClient appAggregatorClient, @NotNull AppAssessmentService appAssessmentService, @NotNull PluginManager pluginManager) {
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        this.appAggregatorClient = appAggregatorClient;
        this.appAssessmentService = appAssessmentService;
        this.pluginManager = pluginManager;
    }

    @NotNull
    public final AppAggregatorClient getAppAggregatorClient() {
        return this.appAggregatorClient;
    }

    @NotNull
    public final AppAssessmentService getAppAssessmentService() {
        return this.appAssessmentService;
    }

    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        NotBlockingCheckResult notBlockingCheckResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        try {
            Set listOfOccurrences = new LinkedHashSet();
            Iterable $this$forEach$iv = PreflightCheckKt.getAppKeys(checkRequest);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Plugin plugin;
                String appKey = (String)element$iv;
                boolean bl = false;
                if (this.pluginManager.getPlugin(appKey) == null) continue;
                boolean bl2 = false;
                if (!this.appIsNotReliable(plugin)) continue;
                String string = plugin.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                listOfOccurrences.add(new NotReliableApp(appKey, string));
            }
            Map details2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"listOfOccurrences", (Object)listOfOccurrences));
            notBlockingCheckResult = new NotBlockingCheckResult(listOfOccurrences.isEmpty(), details2);
        }
        catch (Exception ex) {
            log.error("Error while checking for apps reliability", (Throwable)ex);
            return new NotBlockingCheckResult(false, MapsKt.emptyMap());
        }
        return notBlockingCheckResult;
    }

    private final boolean appIsNotReliable(Plugin plugin) {
        String string = plugin.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        this.appAggregatorClient.getServerAppData(string);
        String string2 = plugin.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
        return !this.appAggregatorClient.isAppReliable(string2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/AppsReliabilityPreflightService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

