/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.features.StatsigFx3Gates;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 +2\u00020\u0001:\u0002*+B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\"\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010'\u001a\u00020(*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020)0\u000eH\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/preflight/ArchivedIssuePreflightCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "jiraIssueReader", "Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "check", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "checkImpl", "getCSVFileName", "executionId", "type", "planName", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "performCheck", "setPreflightCheckError", "hasPositiveValues", "", "", "ArchivedEntityCsvRow", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nArchivedIssuePreflightCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchivedIssuePreflightCheck.kt\ncom/atlassian/jira/migration/preflight/ArchivedIssuePreflightCheck\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n494#2,7:207\n494#2,7:234\n453#2:241\n403#2:242\n453#2:247\n403#2:248\n526#2:253\n511#2,6:254\n76#3:214\n96#3,2:215\n98#3,3:221\n187#3,3:260\n1549#4:217\n1620#4,3:218\n1549#4:224\n1620#4,3:225\n1271#4,2:228\n1285#4,4:230\n1238#4,4:243\n1238#4,4:249\n*S KotlinDebug\n*F\n+ 1 ArchivedIssuePreflightCheck.kt\ncom/atlassian/jira/migration/preflight/ArchivedIssuePreflightCheck\n*L\n143#1:207,7\n171#1:234,7\n175#1:241\n175#1:242\n177#1:247\n177#1:248\n182#1:253\n182#1:254,6\n144#1:214\n144#1:215,2\n144#1:221,3\n192#1:260,3\n151#1:217\n151#1:218,3\n157#1:224\n157#1:225,3\n171#1:228,2\n171#1:230,4\n175#1:243,4\n177#1:249,4\n*E\n"})
public final class ArchivedIssuePreflightCheck
extends NotBlockingCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final JiraIssueReader jiraIssueReader;
    @NotNull
    private final ProjectsReader projectsReader;
    private static final Logger log = LoggerFactory.getLogger(ArchivedIssuePreflightCheck.class);

    @Inject
    public ArchivedIssuePreflightCheck(@NotNull MigrationFeatures migrationFeatures, @NotNull JiraIssueReader jiraIssueReader, @NotNull ProjectsReader projectsReader) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)jiraIssueReader, (String)"jiraIssueReader");
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        super("Failed to check for archived projects and issues.", "Checking for archived projects and issues", "There are no archived projects or issues.", "Some projects have archived issues, which may require your attention.");
        this.migrationFeatures = migrationFeatures;
        this.jiraIssueReader = jiraIssueReader;
        this.projectsReader = projectsReader;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return CheckType.ArchivedIssueCheck;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        CheckRequest req = super.buildCheckRequest(ctx);
        if (req.parameters == null) {
            req = new CheckRequest(req.checkType, (Map)new LinkedHashMap());
        }
        Map map = req.parameters;
        Intrinsics.checkNotNull((Object)map);
        map.put("projectKeys", ctx.getProjectKeys());
        Map map2 = req.parameters;
        Intrinsics.checkNotNull((Object)map2);
        map2.put("migrateArchivedIssues", ctx.getMigrateArchivedIssues());
        return req;
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        NotBlockingCheckResult notBlockingCheckResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        try {
            notBlockingCheckResult = this.check(checkRequest);
        }
        catch (Exception e) {
            log.error("Failed to check for archived projects and issues.", (Throwable)e);
            notBlockingCheckResult = new NotBlockingCheckResult(false, MapsKt.emptyMap());
        }
        return notBlockingCheckResult;
    }

    private final NotBlockingCheckResult check(CheckRequest checkRequest) {
        NotBlockingCheckResult notBlockingCheckResult = this.migrationFeatures.buildRolloutWithStatsigFeature(StatsigFx3Gates.ENABLE_ARCHIVED_ISSUE_PREFLIGHT_CHECK).whenEnabled(() -> ArchivedIssuePreflightCheck.check$lambda$0(this, checkRequest)).run();
        if (notBlockingCheckResult == null) {
            notBlockingCheckResult = new NotBlockingCheckResult(true, MapsKt.emptyMap());
        }
        return notBlockingCheckResult;
    }

    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        super.inject(dto, checkResult);
        try {
            CheckDetailsDto checkDetailsDto;
            Set archivedProjects;
            Set set;
            Map projectToArchivedIssueMap;
            if (checkResult == null) {
                return;
            }
            NotBlockingCheckResult archivedIssueCheckResult = (NotBlockingCheckResult)checkResult;
            if (archivedIssueCheckResult.details == null) {
                return;
            }
            Map map = (Map)archivedIssueCheckResult.details.get("projectsWithArchivedIssues");
            if (map == null) {
                map = projectToArchivedIssueMap = MapsKt.emptyMap();
            }
            if ((set = (Set)archivedIssueCheckResult.details.get("archivedProjects")) == null) {
                set = archivedProjects = SetsKt.emptySet();
            }
            if (this.hasPositiveValues(projectToArchivedIssueMap) && !((Collection)archivedProjects).isEmpty()) {
                dto.setDescription("Some projects and issues are archived, which may require your attention.");
            } else if (this.hasPositiveValues(projectToArchivedIssueMap)) {
                dto.setDescription("Some projects have archived issues, which may require your attention.");
            } else if (!((Collection)archivedProjects).isEmpty()) {
                dto.setDescription("Some projects are archived, which may require your attention.");
            }
            if (dto.getDetails() == null) {
                dto.setDetails(new CheckDetailsDto());
            }
            CheckDetailsDto $this$inject_u24lambda_u241 = checkDetailsDto = dto.getDetails();
            boolean bl = false;
            if ($this$inject_u24lambda_u241.getInfo() == null) {
                $this$inject_u24lambda_u241.setInfo((Map)new LinkedHashMap());
            }
            Map map2 = $this$inject_u24lambda_u241.getInfo();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getInfo(...)");
            Map map3 = map2;
            map3.put("projectsWithArchivedIssues", projectToArchivedIssueMap);
            Map map4 = $this$inject_u24lambda_u241.getInfo();
            Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"getInfo(...)");
            map3 = map4;
            map3.put("archivedProjects", archivedProjects);
            dto.setNumberOfOccurrences(Integer.valueOf((int)CollectionsKt.sumOfLong((Iterable)projectToArchivedIssueMap.values()) + archivedProjects.size()));
        }
        catch (Exception e) {
            log.error("Failed to check for archived projects and issues.", (Throwable)e);
            this.setPreflightCheckError(dto);
        }
    }

    private final void setPreflightCheckError(CheckResultDto dto) {
        CheckResultDto checkResultDto;
        CheckResultDto $this$setPreflightCheckError_u24lambda_u242 = checkResultDto = dto;
        boolean bl = false;
        $this$setPreflightCheckError_u24lambda_u242.setStatus(Status.WARNING);
        $this$setPreflightCheckError_u24lambda_u242.setDescription("Failed to check for archived projects and issues.");
        $this$setPreflightCheckError_u24lambda_u242.setDetails(new CheckDetailsDto());
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return "ArchivedEntities-" + executionId + ".csv";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        List list;
        List list2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$flatMap$iv;
        Map map;
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        String[] stringArray = new String[]{"entity_type", "project_key", "project_id", "entity_id"};
        String[] headers = stringArray;
        String[] stringArray2 = new String[]{"entityType", "projectKey", "projectId", "entityId"};
        String[] headerMappings = stringArray2;
        Pair[] pairArray = checkStatus.checkResult.details;
        Map map2 = pairArray != null ? pairArray.get("projectsWithArchivedIssues") : null;
        if (map2 != null) {
            void $this$filterValues$iv;
            map = map2;
            boolean $i$f$filterValues22 = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                long it = ((Number)entry$iv.getValue()).longValue();
                boolean bl = false;
                if (!(it > 0L)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $i$f$filterValues22 = result$iv;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator<Object> iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                List list3;
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = (Map.Entry)iterator2.next();
                boolean bl = false;
                String projectKey = (String)entry.getKey();
                Long projectId = this.projectsReader.getProject(projectKey).getId();
                if (projectId == null) {
                    list3 = CollectionsKt.emptyList();
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Collection archivedIssues = JiraIssueReader.getIdsOfAllArchivedIssuesForProject$default(this.jiraIssueReader, projectId, 0, 2, null);
                    Iterable iterable2 = archivedIssues;
                    boolean $i$f$map = false;
                    void var22_27 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        long l = ((Number)item$iv$iv).longValue();
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(new ArchivedEntityCsvRow("Issue", projectKey, projectId, (long)it));
                    }
                    list3 = (List)destination$iv$iv2;
                }
                list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List archivedIssueRows = list2;
        map = checkStatus.checkResult.details;
        pairArray = map != null ? map.get("archivedProjects") : null;
        if (pairArray != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$flatMap$iv = (Iterable)pairArray;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void projectKey;
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Long projectId = this.projectsReader.getProject((String)projectKey).getId();
                Intrinsics.checkNotNull((Object)projectId);
                collection.add(new ArchivedEntityCsvRow("Project", (String)projectKey, projectId, projectId));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List archivedProjectsRows = list;
        pairArray = new Pair[]{TuplesKt.to((Object)"headers", (Object)headers), TuplesKt.to((Object)"mappings", (Object)headerMappings), TuplesKt.to((Object)"beans", (Object)CollectionsKt.plus((Collection)archivedProjectsRows, (Iterable)archivedIssueRows))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final NotBlockingCheckResult checkImpl(CheckRequest checkRequest) {
        Map map;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        Map map2;
        boolean $i$f$associateByTo;
        Iterable $this$associateByTo$iv$iv$iv;
        Map $this$mapValuesTo$iv$iv;
        boolean $i$f$mapValuesTo;
        boolean $i$f$mapValues;
        Map $this$mapValues$iv;
        void $this$filterValues$iv;
        Object object;
        Map map3;
        Object object2;
        List<String> projectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
        Object $this$associateWith$iv = projectKeys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean bl = false;
        Iterator iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void key;
            Object element$iv$iv = iterator2.next();
            String string = (String)element$iv$iv;
            object2 = element$iv$iv;
            map3 = result$iv;
            boolean bl2 = false;
            object = this.projectsReader.getProject((String)key);
            map3.put(object2, object);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry2 : $this$filterValues$iv.entrySet()) {
            Project it = (Project)entry2.getValue();
            boolean bl3 = false;
            if (!(it != null)) continue;
            result$iv.put(entry2.getKey(), entry2.getValue());
        }
        Map projectKeysToProject = result$iv;
        if (Intrinsics.areEqual((Object)PreflightCheckKt.getMigrateArchivedIssues(checkRequest), (Object)false)) {
            $this$mapValues$iv = projectKeysToProject;
            $i$f$mapValues = false;
            $this$associateWithTo$iv$iv = $this$mapValues$iv;
            Map map4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                map2 = map4;
                boolean bl2 = false;
                entry = (Map.Entry)element$iv$iv$iv;
                object2 = it$iv$iv.getKey();
                map3 = map2;
                boolean bl4 = false;
                object = 0L;
                map3.put(object2, object);
            }
            map = map4;
        } else {
            $this$mapValues$iv = projectKeysToProject;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            Map map5 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = map5;
                boolean bl3 = false;
                entry = (Map.Entry)element$iv$iv$iv;
                object2 = it$iv$iv.getKey();
                map3 = map2;
                boolean bl5 = false;
                Project proj = (Project)entry.getValue();
                Long l = proj.getId();
                Intrinsics.checkNotNull((Object)l);
                object = this.jiraIssueReader.getArchivedIssueCountForProject(l);
                map3.put(object2, object);
            }
            map = map5;
        }
        Map archivedIssuesCountByProjectKey = map;
        Map $this$filter$iv = projectKeysToProject;
        boolean $i$f$filter = false;
        Map map6 = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = map6.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry4 = element$iv$iv = iterator3.next();
            boolean bl6 = false;
            Project proj = (Project)entry4.getValue();
            if (!proj.isArchived()) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set archivedProjects = destination$iv$iv2.keySet();
        boolean success = !this.hasPositiveValues(archivedIssuesCountByProjectKey) && archivedProjects.isEmpty();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectsWithArchivedIssues", (Object)archivedIssuesCountByProjectKey), TuplesKt.to((Object)"archivedProjects", archivedProjects)};
        return new NotBlockingCheckResult(success, MapsKt.mapOf((Pair[])pairArray));
    }

    private final boolean hasPositiveValues(Map<String, Long> $this$hasPositiveValues) {
        boolean bl;
        block3: {
            Map<String, Long> $this$any$iv = $this$hasPositiveValues;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, Long>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, Long> element$iv;
                    Map.Entry<String, Long> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    long v = ((Number)entry.getValue()).longValue();
                    if (!(v > 0L)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final NotBlockingCheckResult check$lambda$0(ArchivedIssuePreflightCheck this$0, CheckRequest $checkRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$checkRequest, (String)"$checkRequest");
        return this$0.checkImpl($checkRequest);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/preflight/ArchivedIssuePreflightCheck$ArchivedEntityCsvRow;", "", "entityType", "", "projectKey", "projectId", "", "entityId", "(Ljava/lang/String;Ljava/lang/String;JJ)V", "getEntityId", "()J", "getEntityType", "()Ljava/lang/String;", "getProjectId", "getProjectKey", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class ArchivedEntityCsvRow {
        @NotNull
        private final String entityType;
        @NotNull
        private final String projectKey;
        private final long projectId;
        private final long entityId;

        public ArchivedEntityCsvRow(@NotNull String entityType, @NotNull String projectKey, long projectId, long entityId) {
            Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
            Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
            this.entityType = entityType;
            this.projectKey = projectKey;
            this.projectId = projectId;
            this.entityId = entityId;
        }

        @NotNull
        public final String getEntityType() {
            return this.entityType;
        }

        @NotNull
        public final String getProjectKey() {
            return this.projectKey;
        }

        public final long getProjectId() {
            return this.projectId;
        }

        public final long getEntityId() {
            return this.entityId;
        }

        @NotNull
        public final String component1() {
            return this.entityType;
        }

        @NotNull
        public final String component2() {
            return this.projectKey;
        }

        public final long component3() {
            return this.projectId;
        }

        public final long component4() {
            return this.entityId;
        }

        @NotNull
        public final ArchivedEntityCsvRow copy(@NotNull String entityType, @NotNull String projectKey, long projectId, long entityId) {
            Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
            Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
            return new ArchivedEntityCsvRow(entityType, projectKey, projectId, entityId);
        }

        public static /* synthetic */ ArchivedEntityCsvRow copy$default(ArchivedEntityCsvRow archivedEntityCsvRow, String string, String string2, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = archivedEntityCsvRow.entityType;
            }
            if ((n & 2) != 0) {
                string2 = archivedEntityCsvRow.projectKey;
            }
            if ((n & 4) != 0) {
                l = archivedEntityCsvRow.projectId;
            }
            if ((n & 8) != 0) {
                l2 = archivedEntityCsvRow.entityId;
            }
            return archivedEntityCsvRow.copy(string, string2, l, l2);
        }

        @NotNull
        public String toString() {
            return "ArchivedEntityCsvRow(entityType=" + this.entityType + ", projectKey=" + this.projectKey + ", projectId=" + this.projectId + ", entityId=" + this.entityId + ')';
        }

        public int hashCode() {
            int result2 = this.entityType.hashCode();
            result2 = result2 * 31 + this.projectKey.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.projectId);
            result2 = result2 * 31 + Long.hashCode(this.entityId);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArchivedEntityCsvRow)) {
                return false;
            }
            ArchivedEntityCsvRow archivedEntityCsvRow = (ArchivedEntityCsvRow)other;
            if (!Intrinsics.areEqual((Object)this.entityType, (Object)archivedEntityCsvRow.entityType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectKey, (Object)archivedEntityCsvRow.projectKey)) {
                return false;
            }
            if (this.projectId != archivedEntityCsvRow.projectId) {
                return false;
            }
            return this.entityId == archivedEntityCsvRow.entityId;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/ArchivedIssuePreflightCheck$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

