/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.base.CheckExecutor;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.mapper.ExecutionErrorCodes;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.events.AsyncCheckExecutionFailedEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreflightCheckGenericEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.LogLevel;
import com.atlassian.jira.migration.plan.PlanPhase;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.platform.TransferStatusRequest;
import com.atlassian.jira.migration.preflight.AsyncCheckExecutor;
import com.atlassian.jira.migration.preflight.AsyncCheckExecutorKt;
import com.atlassian.jira.migration.preflight.PreMigrationCheckOutcomeRepository;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.PreflightCheckLookup;
import com.atlassian.jira.migration.preflight.PreflightCheckRepository;
import com.atlassian.jira.migration.preflight.PreflightCheckStatus;
import com.atlassian.jira.migration.preflight.PreflightPersistenceManager;
import com.atlassian.jira.migration.preflight.model.CheckExecutionResult;
import com.atlassian.jira.migration.preflight.model.CheckMode;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.jira.migration.preflight.utils.DiskCheckErrorCode;
import com.atlassian.jira.migration.preflight.utils.PreflightUtils;
import com.atlassian.jira.migration.utils.PreflightLogMessage;
import com.atlassian.jira.migration.utils.PreflightLogger;
import com.atlassian.jira.migration.utils.TimeUtil;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.TransferId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 P2\u00020\u0001:\u0003NOPBO\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014B\u008f\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u0012\u001a\b\u0002\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0019\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001fJ,\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u000e\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001aJ\u001e\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001a2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020$0-H\u0016J$\u0010.\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010/\u001a\u0002002\f\u0010,\u001a\b\u0012\u0004\u0012\u00020$0-J \u00101\u001a\u0004\u0018\u0001022\u0006\u0010\"\u001a\u00020\u001a2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e04H\u0002J \u00105\u001a\u0004\u0018\u0001022\u0006\u0010\"\u001a\u00020\u001a2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e04H\u0002J\u001e\u00106\u001a\u0002022\u0006\u0010\"\u001a\u00020\u001a2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e04H\u0002J$\u00107\u001a\b\u0012\u0004\u0012\u000202082\u0006\u0010\"\u001a\u00020\u001a2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e04H\u0002J6\u00109\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u001a2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010<\u001a\u00020=J\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\"\u001a\u00020\u001aJ\u0016\u0010?\u001a\b\u0012\u0004\u0012\u000202082\u0006\u0010\"\u001a\u00020\u001aH\u0016J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u000202082\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u001eJ\u0018\u0010A\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020CH\u0002J \u0010D\u001a\u00020E2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010/\u001a\u0002002\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u001bH\u0002J\"\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\"\u001a\u00020\u001a2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\b\u0010J\u001a\u00020!H\u0007J\u0017\u0010K\u001a\u0004\u0018\u00010!2\u0006\u0010L\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010MR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor;", "Lcom/atlassian/cmpt/check/base/CheckExecutor;", "preflightCheckLookup", "Lcom/atlassian/jira/migration/preflight/PreflightCheckLookup;", "preflightPersistenceManager", "Lcom/atlassian/jira/migration/preflight/PreflightPersistenceManager;", "executor", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "preMigrationCheckOutcomeRepository", "Lcom/atlassian/jira/migration/preflight/PreMigrationCheckOutcomeRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "preflightCheckRepository", "Lcom/atlassian/jira/migration/preflight/PreflightCheckRepository;", "(Lcom/atlassian/jira/migration/preflight/PreflightCheckLookup;Lcom/atlassian/jira/migration/preflight/PreflightPersistenceManager;Lcom/google/common/util/concurrent/ListeningExecutorService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/preflight/PreMigrationCheckOutcomeRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/preflight/PreflightCheckRepository;)V", "currentTime", "Lkotlin/Function0;", "", "jobs", "", "", "Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor$CheckBatch;", "executionIdToOverriddenChecks", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "(Lcom/atlassian/jira/migration/preflight/PreflightCheckLookup;Lcom/atlassian/jira/migration/preflight/PreflightPersistenceManager;Lcom/google/common/util/concurrent/ListeningExecutorService;Lkotlin/jvm/functions/Function0;Ljava/util/Map;Ljava/util/Map;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/preflight/PreMigrationCheckOutcomeRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/preflight/PreflightCheckRepository;)V", "concludeTransfer", "", "executionId", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "executionStatus", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "deleteCheckExecution", "deletePreflightCheckResult", "executeChecks", "checks", "", "executeChecksListenable", "checkMode", "Lcom/atlassian/jira/migration/preflight/model/CheckMode;", "fetchFromInProgressStore", "Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "checkTypes", "", "fetchFromPreflightCheckRepository", "fetchFromPreflightPersistenceManager", "fetchStatus", "Ljava/util/Optional;", "getFinalPreflightChecksToRemove", "uniqueId", "checksToRemove", "isUpdatedAllInOnPbpPlan", "", "getOverriddenChecks", "getStatus", "checkType", "persistWhenDone", "checkExecution", "Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor$CheckExecution;", "runCheck", "Lcom/atlassian/jira/migration/preflight/model/CheckExecutionResult;", "scheduleCleanUp", "batch", "setChecksToOverride", "checksToOverride", "shutdown", "startTransfer", "check", "(Lcom/atlassian/cmpt/check/base/CheckRequest;)Lkotlin/Unit;", "CheckBatch", "CheckExecution", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAsyncCheckExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncCheckExecutor.kt\ncom/atlassian/jira/migration/preflight/AsyncCheckExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,570:1\n766#2:571\n857#2:572\n1747#2,3:573\n858#2:576\n1549#2:577\n1620#2,3:578\n1603#2,9:581\n1855#2:590\n1856#2:592\n1612#2:593\n1603#2,9:594\n1855#2:603\n1856#2:605\n1612#2:606\n1855#2,2:607\n1#3:591\n1#3:604\n*S KotlinDebug\n*F\n+ 1 AsyncCheckExecutor.kt\ncom/atlassian/jira/migration/preflight/AsyncCheckExecutor\n*L\n122#1:571\n122#1:572\n122#1:573,3\n122#1:576\n123#1:577\n123#1:578,3\n133#1:581,9\n133#1:590\n133#1:592\n133#1:593\n142#1:594,9\n142#1:603\n142#1:605\n142#1:606\n175#1:607,2\n133#1:591\n142#1:604\n*E\n"})
public final class AsyncCheckExecutor
implements CheckExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreflightCheckLookup preflightCheckLookup;
    @NotNull
    private final PreflightPersistenceManager preflightPersistenceManager;
    @NotNull
    private final ListeningExecutorService executor;
    @NotNull
    private final Function0<Long> currentTime;
    @NotNull
    private final Map<String, CheckBatch> jobs;
    @NotNull
    private final Map<String, EnumSet<CheckType>> executionIdToOverriddenChecks;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final PreMigrationCheckOutcomeRepository preMigrationCheckOutcomeRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final PreflightCheckRepository preflightCheckRepository;
    private static final Logger log = LoggerFactory.getLogger(AsyncCheckExecutor.class);
    @NotNull
    private static final String SUCCESS = "Success";
    @NotNull
    private static final String FAILED = "Failed";
    @NotNull
    private static final String EXECUTION_FAILED = "ExecutionFailed";
    @NotNull
    private static final String NO_SPACE_ON_DEVICE_ERR_CHECK = "No space left on device";
    private static final int MAX_EXCEPTION_MESSAGE_LENGTH = 200;

    @VisibleForTesting
    public AsyncCheckExecutor(@NotNull PreflightCheckLookup preflightCheckLookup, @NotNull PreflightPersistenceManager preflightPersistenceManager, @NotNull ListeningExecutorService executor, @NotNull Function0<Long> currentTime, @NotNull Map<String, CheckBatch> jobs, @NotNull Map<String, EnumSet<CheckType>> executionIdToOverriddenChecks, @NotNull MetricsEventService metricsEventService, @NotNull MigrationEventBus migrationEventBus, @NotNull PreMigrationCheckOutcomeRepository preMigrationCheckOutcomeRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull PlatformService platformService, @NotNull PreflightCheckRepository preflightCheckRepository) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckLookup, (String)"preflightCheckLookup");
        Intrinsics.checkNotNullParameter((Object)preflightPersistenceManager, (String)"preflightPersistenceManager");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(currentTime, (String)"currentTime");
        Intrinsics.checkNotNullParameter(jobs, (String)"jobs");
        Intrinsics.checkNotNullParameter(executionIdToOverriddenChecks, (String)"executionIdToOverriddenChecks");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)preMigrationCheckOutcomeRepository, (String)"preMigrationCheckOutcomeRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)preflightCheckRepository, (String)"preflightCheckRepository");
        this.preflightCheckLookup = preflightCheckLookup;
        this.preflightPersistenceManager = preflightPersistenceManager;
        this.executor = executor;
        this.currentTime = currentTime;
        this.jobs = jobs;
        this.executionIdToOverriddenChecks = executionIdToOverriddenChecks;
        this.metricsEventService = metricsEventService;
        this.migrationEventBus = migrationEventBus;
        this.preMigrationCheckOutcomeRepository = preMigrationCheckOutcomeRepository;
        this.migrationFeatures = migrationFeatures;
        this.platformService = platformService;
        this.preflightCheckRepository = preflightCheckRepository;
    }

    public /* synthetic */ AsyncCheckExecutor(PreflightCheckLookup preflightCheckLookup, PreflightPersistenceManager preflightPersistenceManager, ListeningExecutorService listeningExecutorService, Function0 function0, Map map, Map map2, MetricsEventService metricsEventService, MigrationEventBus migrationEventBus, PreMigrationCheckOutcomeRepository preMigrationCheckOutcomeRepository, MigrationFeatures migrationFeatures, PlatformService platformService, PreflightCheckRepository preflightCheckRepository, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            map = new ConcurrentHashMap();
        }
        if ((n & 0x20) != 0) {
            map2 = new ConcurrentHashMap();
        }
        this(preflightCheckLookup, preflightPersistenceManager, listeningExecutorService, (Function0<Long>)function0, map, map2, metricsEventService, migrationEventBus, preMigrationCheckOutcomeRepository, migrationFeatures, platformService, preflightCheckRepository);
    }

    @Inject
    public AsyncCheckExecutor(@NotNull PreflightCheckLookup preflightCheckLookup, @NotNull PreflightPersistenceManager preflightPersistenceManager, @NotNull ListeningExecutorService executor, @NotNull MetricsEventService metricsEventService, @NotNull MigrationEventBus migrationEventBus, @NotNull PreMigrationCheckOutcomeRepository preMigrationCheckOutcomeRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull PlatformService platformService, @NotNull PreflightCheckRepository preflightCheckRepository) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckLookup, (String)"preflightCheckLookup");
        Intrinsics.checkNotNullParameter((Object)preflightPersistenceManager, (String)"preflightPersistenceManager");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)preMigrationCheckOutcomeRepository, (String)"preMigrationCheckOutcomeRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)preflightCheckRepository, (String)"preflightCheckRepository");
        this(preflightCheckLookup, preflightPersistenceManager, executor, 1.INSTANCE, null, null, metricsEventService, migrationEventBus, preMigrationCheckOutcomeRepository, migrationFeatures, platformService, preflightCheckRepository, 48, null);
    }

    @NotNull
    public Optional<CheckExecutionStatus> getStatus(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return this.fetchStatus(executionId, (Set<? extends CheckType>)CheckType.Companion.getAllCheckTypesSet());
    }

    @NotNull
    public final Optional<CheckExecutionStatus> getStatus(@NotNull String executionId, @NotNull CheckType checkType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        return this.fetchStatus(executionId, SetsKt.setOf((Object)((Object)checkType)));
    }

    private final Optional<CheckExecutionStatus> fetchStatus(String executionId, Set<? extends CheckType> checkTypes) {
        CheckExecutionStatus checkExecutionStatus = this.fetchFromInProgressStore(executionId, checkTypes);
        if (checkExecutionStatus == null && (checkExecutionStatus = this.fetchFromPreflightCheckRepository(executionId, checkTypes)) == null) {
            checkExecutionStatus = this.fetchFromPreflightPersistenceManager(executionId, checkTypes);
        }
        Optional<CheckExecutionStatus> optional = Optional.ofNullable(checkExecutionStatus);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckExecutionStatus fetchFromInProgressStore(String executionId, Set<? extends CheckType> checkTypes) {
        CheckExecutionStatus checkExecutionStatus;
        CheckBatch checkBatch = this.jobs.get(executionId);
        if (checkBatch != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            CheckBatch job = checkBatch;
            boolean bl = false;
            Iterable iterable = job.getChecks();
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                block7: {
                    CheckExecution check = (CheckExecution)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$any$iv = checkTypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CheckType it = (CheckType)((Object)element$iv);
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.toString(), (Object)check.getRequest().checkType)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            Companion companion = Companion;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                CheckExecution bl3 = (CheckExecution)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(companion.extractResult((CheckExecution)p0));
            }
            List results2 = (List)destination$iv$iv2;
            checkExecutionStatus = !((Collection)results2).isEmpty() ? new CheckExecutionStatus(executionId, results2) : null;
        } else {
            checkExecutionStatus = null;
        }
        return checkExecutionStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckExecutionStatus fetchFromPreflightCheckRepository(String executionId, Set<? extends CheckType> checkTypes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        if (!this.migrationFeatures.getEnablePreflightCheckRepository()) {
            return null;
        }
        Iterable iterable = checkTypes;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CheckStatus it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CheckType it = (CheckType)((Object)element$iv$iv);
            boolean bl2 = false;
            PreflightCheckStatus preflightCheckStatus = this.preflightCheckRepository.getByExecutionId(executionId, it);
            if ((preflightCheckStatus != null ? preflightCheckStatus.getStatus() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List results2 = (List)destination$iv$iv;
        return !((Collection)results2).isEmpty() ? new CheckExecutionStatus(executionId, results2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckExecutionStatus fetchFromPreflightPersistenceManager(String executionId, Set<? extends CheckType> checkTypes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = checkTypes;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CheckStatus it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CheckType it = (CheckType)((Object)element$iv$iv);
            boolean bl2 = false;
            if (this.preflightPersistenceManager.fetchResult(executionId, it.name()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List results2 = (List)destination$iv$iv;
        return new CheckExecutionStatus(executionId, results2);
    }

    public final void getFinalPreflightChecksToRemove(@NotNull String executionId, @NotNull String uniqueId, @NotNull EnumSet<CheckType> checksToRemove, @NotNull CheckMode checkMode, boolean isUpdatedAllInOnPbpPlan) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter(checksToRemove, (String)"checksToRemove");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        this.preflightPersistenceManager.buildFinalPreflightChecksToRemoveSet(executionId, uniqueId, checksToRemove, checkMode, isUpdatedAllInOnPbpPlan);
    }

    public static /* synthetic */ void getFinalPreflightChecksToRemove$default(AsyncCheckExecutor asyncCheckExecutor, String string, String string2, EnumSet enumSet, CheckMode checkMode, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        asyncCheckExecutor.getFinalPreflightChecksToRemove(string, string2, enumSet, checkMode, bl);
    }

    public final void deletePreflightCheckResult(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.preflightPersistenceManager.deletePreflightCheckResultFromDB(executionId);
    }

    @NotNull
    public final EnumSet<CheckType> setChecksToOverride(@NotNull String executionId, @NotNull EnumSet<CheckType> checksToOverride) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(checksToOverride, (String)"checksToOverride");
        EnumSet<CheckType> enumSet = this.executionIdToOverriddenChecks.put(executionId, checksToOverride);
        if (enumSet == null) {
            enumSet = CheckType.Companion.getEmptyCheckTypeSet();
        }
        return enumSet;
    }

    @NotNull
    public final EnumSet<CheckType> getOverriddenChecks(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        EnumSet<CheckType> enumSet = this.executionIdToOverriddenChecks.get(executionId);
        if (enumSet == null) {
            enumSet = CheckType.Companion.getEmptyCheckTypeSet();
        }
        return enumSet;
    }

    public final void deleteCheckExecution(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        CheckBatch checkBatch = this.jobs.remove(executionId);
        if (checkBatch != null) {
            CheckBatch it = checkBatch;
            boolean bl = false;
            Iterable $this$forEach$iv = it.getChecks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CheckExecution chEx = (CheckExecution)element$iv;
                boolean bl2 = false;
                chEx.getResult().cancel(true);
            }
        }
        this.executionIdToOverriddenChecks.remove(executionId);
        this.preflightPersistenceManager.deleteResults(executionId);
    }

    public void executeChecks(@NotNull String executionId, @NotNull List<? extends CheckRequest> checks) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(checks, (String)"checks");
        this.executeChecksListenable(executionId, CheckMode.Companion.getDefaultCheckType(), checks);
    }

    private final Unit startTransfer(CheckRequest check) {
        Unit unit;
        TransferId transferId = PreflightCheckKt.getTransferId(check);
        if (transferId != null) {
            TransferId it = transferId;
            boolean bl = false;
            ContainerToken containerToken = new ContainerToken(PreflightCheckKt.getContainerToken(check));
            MigrationId migrationId = PreflightCheckKt.getPreflightId(check);
            Intrinsics.checkNotNull((Object)migrationId);
            this.platformService.queueTransferStatusUpdate(containerToken, migrationId, it, new TransferStatusRequest(TransferStatus.IN_PROGRESS, TransferStatus.IN_PROGRESS, null, null, 12, null));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void concludeTransfer(String executionId, CheckRequest checkRequest, CheckStatus checkStatus, TransferStatus executionStatus) {
        block3: {
            TransferId transferId = PreflightCheckKt.getTransferId(checkRequest);
            if (transferId == null) break block3;
            TransferId it = transferId;
            boolean bl = false;
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            String string = checkRequest.checkType;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
            CheckType checkType = CheckType.valueOf(string);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"transferId", (Object)it), TuplesKt.to((Object)"preflightId", (Object)PreflightCheckKt.getPreflightId(checkRequest))};
            Map map = MapsKt.mapOf((Pair[])pairArray);
            PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Settle preflight transfer status", null, checkType, executionId, map, null, 34, null));
            MigrationId migrationId = PreflightCheckKt.getPreflightId(checkRequest);
            Intrinsics.checkNotNull((Object)migrationId);
            MigrationId preflightId = migrationId;
            ContainerToken containerToken = new ContainerToken(PreflightCheckKt.getContainerToken(checkRequest));
            if (this.migrationFeatures.getEnablePreflightCheckRepository()) {
                String string2 = String.valueOf(PreflightCheckKt.getPreflightId(checkRequest));
                String string3 = checkRequest.checkType;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"checkType");
                this.preflightCheckRepository.update(new PreflightCheckStatus(null, string2, executionId, CheckType.Companion.fromString(string3), checkStatus, 0L, 0L, 97, null));
            }
            if (executionStatus == TransferStatus.CANCELLED) {
                this.platformService.queueTransferStatusUpdate(containerToken, preflightId, it, new TransferStatusRequest(executionStatus, executionStatus, null, null, 12, null));
                return;
            }
            String string4 = checkStatus.checkType;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"checkType");
            CheckResultDto checkResultDto = this.preflightCheckLookup.get(CheckType.valueOf(string4)).map(checkStatus);
            Status customStatus = checkResultDto.getStatus();
            TransferStatus businessStatus = checkStatus.checkResult.success ? TransferStatus.SUCCESS : TransferStatus.FAILED;
            TransferStatus transferStatus = executionStatus;
            if (transferStatus == null) {
                transferStatus = checkResultDto.getStatus() == Status.EXECUTION_ERROR ? TransferStatus.FAILED : TransferStatus.SUCCESS;
            }
            TransferStatus finalExecutionStatus = transferStatus;
            this.platformService.queueTransferStatusUpdate(containerToken, preflightId, it, new TransferStatusRequest(finalExecutionStatus, businessStatus, customStatus.value(), checkResultDto.getDescription()));
        }
    }

    static /* synthetic */ void concludeTransfer$default(AsyncCheckExecutor asyncCheckExecutor, String string, CheckRequest checkRequest, CheckStatus checkStatus, TransferStatus transferStatus, int n, Object object) {
        if ((n & 8) != 0) {
            transferStatus = null;
        }
        asyncCheckExecutor.concludeTransfer(string, checkRequest, checkStatus, transferStatus);
    }

    @NotNull
    public final CheckBatch executeChecksListenable(@NotNull String executionId, @NotNull CheckMode checkMode, @NotNull List<? extends CheckRequest> checks) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        Intrinsics.checkNotNullParameter(checks, (String)"checks");
        CheckBatch checkBatch = this.jobs.compute(executionId, (arg_0, arg_1) -> AsyncCheckExecutor.executeChecksListenable$lambda$9((Function2)new Function2<String, CheckBatch, CheckBatch>(checks, this, executionId, checkMode){
            final /* synthetic */ List<CheckRequest> $checks;
            final /* synthetic */ AsyncCheckExecutor this$0;
            final /* synthetic */ String $executionId;
            final /* synthetic */ CheckMode $checkMode;
            {
                this.$checks = $checks;
                this.this$0 = $receiver;
                this.$executionId = $executionId;
                this.$checkMode = $checkMode;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CheckBatch invoke(@NotNull String string, @Nullable CheckBatch checkBatch) {
                Collection<ListenableFuture<CheckExecutionResult>> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object $this$mapValuesTo$iv$iv;
                Map $this$associateByTo$iv$iv;
                Map map;
                Object object;
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Object object2 = checkBatch;
                if (object2 != null && (object2 = ((CheckBatch)object2).getChecks()) != null) {
                    void $this$associateByTo$iv$iv2;
                    Iterable $this$associateBy$iv = (Iterable)object2;
                    boolean $i$f$associateBy = false;
                    int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associateBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv2);
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
                        void it;
                        CheckExecution checkExecution = (CheckExecution)element$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.put(it.getRequest().checkType, element$iv$iv);
                    }
                    map = destination$iv$iv;
                } else {
                    map = MapsKt.emptyMap();
                }
                Map existingChecks = map;
                Iterable $this$associateBy$iv = this.$checks;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable capacity$iv2 = $this$associateBy$iv;
                Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                Iterator<T> $i$f$associateByTo2 = $this$associateByTo$iv$iv.iterator();
                while ($i$f$associateByTo2.hasNext()) {
                    Iterator<T> it;
                    Object element$iv$iv;
                    T element$iv$iv2 = $i$f$associateByTo2.next();
                    element$iv$iv = (CheckRequest)element$iv$iv2;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.put(((CheckRequest)it).checkType, element$iv$iv2);
                }
                Map checksRequested = destination$iv$iv;
                Map $this$mapValues$iv = existingChecks;
                boolean $i$f$mapValues22 = false;
                $this$associateByTo$iv$iv = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo22 = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo222 = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl2 = false;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    object = map2;
                    boolean bl3 = false;
                    CheckRequest checkRequest = ((CheckExecution)it.getValue()).getRequest();
                    object.put(k, checkRequest);
                }
                Map checksToSchedule = MapsKt.plus((Map)destination$iv$iv, (Map)checksRequested);
                Iterable $i$f$mapValues22 = checksToSchedule.values();
                $this$mapValuesTo$iv$iv = this.this$0;
                destination$iv$iv = this.$executionId;
                CheckMode $i$f$mapValuesTo22 = this.$checkMode;
                boolean $i$f$map = false;
                void $i$f$associateByTo222 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    CheckExecution existingExecution;
                    CheckExecution checkExecution;
                    CheckExecution checkExecution2;
                    void toSchedule;
                    CheckRequest bl2 = (CheckRequest)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    CheckExecution checkExecution3 = (CheckExecution)existingChecks.get(toSchedule.checkType);
                    if (checkExecution3 != null) {
                        CheckExecution checkExecution4;
                        CheckExecution existing = checkExecution4 = checkExecution3;
                        boolean bl4 = false;
                        boolean bl5 = existing.getResult().isDone() && checksRequested.containsKey(toSchedule.checkType);
                        checkExecution2 = !bl5 ? checkExecution4 : null;
                    } else {
                        checkExecution2 = null;
                    }
                    if ((checkExecution = (existingExecution = checkExecution2)) == null) {
                        CheckExecution checkExecution5;
                        Object $this$invoke_u24lambda_u247_u24lambda_u246 = $this$mapValuesTo$iv$iv;
                        boolean bl6 = false;
                        ListenableFuture listenableFuture = AsyncCheckExecutor.access$getExecutor$p((AsyncCheckExecutor)$this$invoke_u24lambda_u247_u24lambda_u246).submit(() -> executeChecksListenable.1.invoke$lambda$7$lambda$6$lambda$4((AsyncCheckExecutor)$this$invoke_u24lambda_u247_u24lambda_u246, (CheckRequest)toSchedule, (String)destination$iv$iv, $i$f$mapValuesTo22));
                        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"submit(...)");
                        CheckExecution $this$invoke_u24lambda_u247_u24lambda_u246_u24lambda_u245 = checkExecution5 = new CheckExecution((CheckRequest)toSchedule, (ListenableFuture<CheckExecutionResult>)listenableFuture);
                        boolean bl7 = false;
                        if (AsyncCheckExecutor.access$getMigrationFeatures$p((AsyncCheckExecutor)$this$invoke_u24lambda_u247_u24lambda_u246).getEnablePreflightCheckRepository()) {
                            PreflightCheckRepository preflightCheckRepository = AsyncCheckExecutor.access$getPreflightCheckRepository$p((AsyncCheckExecutor)$this$invoke_u24lambda_u247_u24lambda_u246);
                            String string2 = String.valueOf(PreflightCheckKt.getPreflightId((CheckRequest)toSchedule));
                            String string3 = toSchedule.checkType;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"checkType");
                            preflightCheckRepository.save(new PreflightCheckStatus(null, string2, (String)destination$iv$iv, CheckType.Companion.fromString(string3), com.atlassian.jira.migration.preflight.AsyncCheckExecutor$Companion.access$extractResult(AsyncCheckExecutor.Companion, $this$invoke_u24lambda_u247_u24lambda_u246_u24lambda_u245), 0L, 0L, 97, null));
                        }
                        AsyncCheckExecutor.access$persistWhenDone((AsyncCheckExecutor)$this$invoke_u24lambda_u247_u24lambda_u246, (String)destination$iv$iv, $this$invoke_u24lambda_u247_u24lambda_u246_u24lambda_u245);
                        checkExecution = checkExecution5;
                    }
                    object.add(checkExecution);
                }
                List executions = (List)destination$iv$iv2;
                $this$mapValuesTo$iv$iv = executions;
                List list = executions;
                String string4 = this.$executionId;
                object = this.this$0;
                boolean $i$f$map2 = false;
                $i$f$mapValuesTo22 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CheckExecution it$iv$iv = (CheckExecution)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    collection.add(it.getResult());
                }
                collection = (List)destination$iv$iv3;
                ListenableFuture listenableFuture = Futures.allAsList((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"allAsList(...)");
                ListenableFuture listenableFuture2 = listenableFuture;
                List list2 = list;
                String string5 = string4;
                return AsyncCheckExecutor.access$scheduleCleanUp((AsyncCheckExecutor)object, new CheckBatch(string5, list2, (ListenableFuture<List<CheckExecutionResult>>)listenableFuture2));
            }

            private static final CheckExecutionResult invoke$lambda$7$lambda$6$lambda$4(AsyncCheckExecutor $this_run, CheckRequest $toSchedule, String $executionId, CheckMode $checkMode) {
                Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
                Intrinsics.checkNotNullParameter((Object)$toSchedule, (String)"$toSchedule");
                Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
                Intrinsics.checkNotNullParameter((Object)((Object)$checkMode), (String)"$checkMode");
                AsyncCheckExecutor.access$startTransfer($this_run, $toSchedule);
                return AsyncCheckExecutor.access$runCheck($this_run, $executionId, $checkMode, $toSchedule);
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)checkBatch);
        return checkBatch;
    }

    private final void persistWhenDone(String executionId, CheckExecution checkExecution) {
        Futures.addCallback(checkExecution.getResult(), (FutureCallback)((FutureCallback)new FutureCallback<CheckExecutionResult>(checkExecution, this, executionId){
            final /* synthetic */ CheckExecution $checkExecution;
            final /* synthetic */ AsyncCheckExecutor this$0;
            final /* synthetic */ String $executionId;
            {
                this.$checkExecution = $checkExecution;
                this.this$0 = $receiver;
                this.$executionId = $executionId;
            }

            public void onSuccess(@Nullable CheckExecutionResult result2) {
                block2: {
                    CheckStatus checkStatus = com.atlassian.jira.migration.preflight.AsyncCheckExecutor$Companion.access$extractResult(AsyncCheckExecutor.Companion, this.$checkExecution);
                    if (checkStatus.checkResult.success) {
                        String string = checkStatus.checkType;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
                        if (CheckType.Companion.isOptimisedPreflightCheckType(string)) {
                            PreMigrationCheckOutcomeRepository preMigrationCheckOutcomeRepository = AsyncCheckExecutor.access$getPreMigrationCheckOutcomeRepository$p(this.this$0);
                            String string2 = checkStatus.checkType;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"checkType");
                            preMigrationCheckOutcomeRepository.cleanUpStaleResultsAndUpsertNewPreflightCheckResult(CheckType.valueOf(string2).ordinal(), System.currentTimeMillis(), PlanPhase.MIGRATE.ordinal(), this.$executionId, "");
                        }
                    }
                    AsyncCheckExecutor.access$getPreflightPersistenceManager$p(this.this$0).persistResult(this.$executionId, checkStatus);
                    AsyncCheckExecutor.concludeTransfer$default(this.this$0, this.$executionId, this.$checkExecution.getRequest(), checkStatus, null, 8, null);
                    CheckExecutionResult checkExecutionResult = result2;
                    if (checkExecutionResult == null) break block2;
                    CheckExecutionResult checkExecutionResult2 = checkExecutionResult;
                    AsyncCheckExecutor asyncCheckExecutor = this.this$0;
                    CheckExecutionResult it = checkExecutionResult2;
                    boolean bl = false;
                    MetricsEventService metricsEventService = AsyncCheckExecutor.access$getMetricsEventService$p(asyncCheckExecutor);
                    String string = it.getRequest().checkType;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
                    MetricsEventService.sendEventForPreflightChecks$default(metricsEventService, string, it.getCheckResult().success ? "Success" : "Failed", 0.0, 4, null);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                TransferStatus executionStatus;
                CheckStatus result2;
                block5: {
                    Object object;
                    CheckRequest checkRequest;
                    Throwable rootCause;
                    block7: {
                        block6: {
                            block4: {
                                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                                result2 = com.atlassian.jira.migration.preflight.AsyncCheckExecutor$Companion.access$extractResult(AsyncCheckExecutor.Companion, this.$checkExecution);
                                executionStatus = TransferStatus.FAILED;
                                MetricsEventService metricsEventService = AsyncCheckExecutor.access$getMetricsEventService$p(this.this$0);
                                String string = result2.checkType;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
                                MetricsEventService.sendEventForPreflightChecks$default(metricsEventService, string, "ExecutionFailed", 0.0, 4, null);
                                if (!(t instanceof CancellationException)) break block4;
                                executionStatus = TransferStatus.CANCELLED;
                                Logger logger2 = AsyncCheckExecutor.access$getLog$cp();
                                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLog$cp(...)");
                                String string2 = this.$checkExecution.getRequest().checkType;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"checkType");
                                PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Preflight Cancelled", null, CheckType.valueOf(string2), this.$executionId, null, null, 50, null));
                                break block5;
                            }
                            rootCause = PreflightUtils.Companion.rootCause(t);
                            checkRequest = this.$checkExecution.getRequest();
                            object = checkRequest.parameters;
                            if (object == null || (object = object.get("cloudId")) == null) break block6;
                            Object it = object;
                            boolean bl = false;
                            String string = PreflightCheckKt.getCloudId(checkRequest);
                            object = string;
                            if (string != null) break block7;
                        }
                        object = "";
                    }
                    Object cloudId2 = object;
                    MigrationEventBus migrationEventBus = AsyncCheckExecutor.access$getMigrationEventBus$p(this.this$0);
                    String string = result2.checkType;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
                    CheckType checkType = CheckType.valueOf(string);
                    Long l = result2.lastExecutionTime;
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"lastExecutionTime");
                    long l2 = ((Number)l).longValue();
                    String string3 = StringsKt.take((String)t.toString(), (int)200);
                    String string4 = StringsKt.take((String)rootCause.toString(), (int)200);
                    String string5 = PreflightUtils.Companion.getLimitedStackTrace$default(PreflightUtils.Companion, rootCause, 0, 2, null);
                    String string6 = PreflightCheckKt.getUniqueId(checkRequest);
                    if (string6 == null) {
                        string6 = "";
                    }
                    migrationEventBus.post(new AsyncCheckExecutionFailedEvent(this.$executionId, checkType, l2, string3, string4, string5, (String)cloudId2, string6));
                    Logger logger3 = AsyncCheckExecutor.access$getLog$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"access$getLog$cp(...)");
                    String string7 = this.$checkExecution.getRequest().checkType;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"checkType");
                    PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("Preflight Failed", LogLevel.WARN, CheckType.valueOf(string7), this.$executionId, null, t, 16, null));
                    AsyncCheckExecutor.access$getPreflightPersistenceManager$p(this.this$0).persistResult(this.$executionId, result2);
                }
                AsyncCheckExecutor.access$concludeTransfer(this.this$0, this.$executionId, this.$checkExecution.getRequest(), result2, executionStatus);
            }
        }), (Executor)((Executor)this.executor));
    }

    private final CheckBatch scheduleCleanUp(CheckBatch batch) {
        Futures.addCallback(batch.getResults(), (FutureCallback)((FutureCallback)new FutureCallback<List<? extends CheckExecutionResult>>(batch, this){
            final /* synthetic */ CheckBatch $batch;
            final /* synthetic */ AsyncCheckExecutor this$0;
            {
                this.$batch = $batch;
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable List<CheckExecutionResult> result2) {
                this.cleanUp();
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                String message = "Preflight CheckBatch Failed";
                if (t instanceof CancellationException) {
                    Logger logger2 = AsyncCheckExecutor.access$getLog$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLog$cp(...)");
                    PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage(message, LogLevel.WARN, null, this.$batch.getExecutionId(), null, null, 52, null));
                } else {
                    Logger logger3 = AsyncCheckExecutor.access$getLog$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"access$getLog$cp(...)");
                    PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage(message, LogLevel.WARN, null, this.$batch.getExecutionId(), null, t, 20, null));
                }
                this.cleanUp();
            }

            private final void cleanUp() {
                if (this.$batch == AsyncCheckExecutor.access$getJobs$p(this.this$0).get(this.$batch.getExecutionId())) {
                    AsyncCheckExecutor.access$getJobs$p(this.this$0).remove(this.$batch.getExecutionId());
                } else {
                    Logger logger2 = AsyncCheckExecutor.access$getLog$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLog$cp(...)");
                    PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Skipping clean up of the batch because another one is running", null, null, this.$batch.getExecutionId(), null, null, 54, null));
                }
            }
        }), (Executor)((Executor)this.executor));
        return batch;
    }

    private final CheckExecutionResult runCheck(String executionId, CheckMode checkMode, CheckRequest checkRequest) {
        String string = checkRequest.checkType;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
        CheckType type = CheckType.valueOf(string);
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Preflight Started", null, type, executionId, null, null, 50, null));
        long startTime = System.currentTimeMillis();
        String[] stringArray = new String[]{type.name().toString()};
        CheckResult checkResult = (CheckResult)((DistributionDataPoint)AsyncCheckExecutorKt.getPerformCheckHistogram().labelValues(stringArray)).time(() -> AsyncCheckExecutor.runCheck$lambda$10(this, type, checkRequest));
        long lastExecutionTime = ((Number)this.currentTime.invoke()).longValue();
        long endTime = System.currentTimeMillis();
        long elapsedTimeInMillis = endTime - startTime;
        boolean hasWarningsForNonBlockingCheck = checkResult instanceof NotBlockingCheckResult && ((NotBlockingCheckResult)checkResult).getHasWarnings();
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new PreflightCheckGenericEvent(executionId, string2, elapsedTimeInMillis, checkResult.success && !hasWarningsForNonBlockingCheck, !checkResult.success, type, true, lastExecutionTime, checkMode, false));
        Logger logger3 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ExecutionTime", (Object)TimeUtil.INSTANCE.toTimeFormat(elapsedTimeInMillis)), TuplesKt.to((Object)"Status", (Object)(checkResult.success ? SUCCESS : FAILED))};
        PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("Preflight Completed", null, type, executionId, MapsKt.mapOf((Pair[])pairArray), null, 34, null));
        Intrinsics.checkNotNull((Object)checkResult);
        return new CheckExecutionResult(lastExecutionTime, checkRequest, checkResult);
    }

    @PreDestroy
    public final void shutdown() {
        this.executor.shutdownNow();
    }

    private static final CheckBatch executeChecksListenable$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CheckBatch)$tmp0.invoke(p0, p1);
    }

    private static final CheckResult runCheck$lambda$10(AsyncCheckExecutor this$0, CheckType $type, CheckRequest $checkRequest) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$checkRequest, (String)"$checkRequest");
        return this$0.preflightCheckLookup.get($type).performCheck($checkRequest);
    }

    public static final /* synthetic */ CheckBatch access$scheduleCleanUp(AsyncCheckExecutor $this, CheckBatch batch) {
        return $this.scheduleCleanUp(batch);
    }

    public static final /* synthetic */ Unit access$startTransfer(AsyncCheckExecutor $this, CheckRequest check) {
        return $this.startTransfer(check);
    }

    public static final /* synthetic */ CheckExecutionResult access$runCheck(AsyncCheckExecutor $this, String executionId, CheckMode checkMode, CheckRequest checkRequest) {
        return $this.runCheck(executionId, checkMode, checkRequest);
    }

    public static final /* synthetic */ MigrationFeatures access$getMigrationFeatures$p(AsyncCheckExecutor $this) {
        return $this.migrationFeatures;
    }

    public static final /* synthetic */ PreflightCheckRepository access$getPreflightCheckRepository$p(AsyncCheckExecutor $this) {
        return $this.preflightCheckRepository;
    }

    public static final /* synthetic */ void access$persistWhenDone(AsyncCheckExecutor $this, String executionId, CheckExecution checkExecution) {
        $this.persistWhenDone(executionId, checkExecution);
    }

    public static final /* synthetic */ ListeningExecutorService access$getExecutor$p(AsyncCheckExecutor $this) {
        return $this.executor;
    }

    public static final /* synthetic */ PreMigrationCheckOutcomeRepository access$getPreMigrationCheckOutcomeRepository$p(AsyncCheckExecutor $this) {
        return $this.preMigrationCheckOutcomeRepository;
    }

    public static final /* synthetic */ PreflightPersistenceManager access$getPreflightPersistenceManager$p(AsyncCheckExecutor $this) {
        return $this.preflightPersistenceManager;
    }

    public static final /* synthetic */ MetricsEventService access$getMetricsEventService$p(AsyncCheckExecutor $this) {
        return $this.metricsEventService;
    }

    public static final /* synthetic */ MigrationEventBus access$getMigrationEventBus$p(AsyncCheckExecutor $this) {
        return $this.migrationEventBus;
    }

    public static final /* synthetic */ void access$concludeTransfer(AsyncCheckExecutor $this, String executionId, CheckRequest checkRequest, CheckStatus checkStatus, TransferStatus executionStatus) {
        $this.concludeTransfer(executionId, checkRequest, checkStatus, executionStatus);
    }

    public static final /* synthetic */ Map access$getJobs$p(AsyncCheckExecutor $this) {
        return $this.jobs;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\bH\u00c6\u0003J9\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor$CheckBatch;", "", "executionId", "", "checks", "", "Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor$CheckExecution;", "results", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/atlassian/jira/migration/preflight/model/CheckExecutionResult;", "(Ljava/lang/String;Ljava/util/List;Lcom/google/common/util/concurrent/ListenableFuture;)V", "getChecks", "()Ljava/util/List;", "getExecutionId", "()Ljava/lang/String;", "getResults", "()Lcom/google/common/util/concurrent/ListenableFuture;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class CheckBatch {
        @NotNull
        private final String executionId;
        @NotNull
        private final List<CheckExecution> checks;
        @NotNull
        private final ListenableFuture<List<CheckExecutionResult>> results;

        public CheckBatch(@NotNull String executionId, @NotNull List<CheckExecution> checks, @NotNull ListenableFuture<List<CheckExecutionResult>> results2) {
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter(checks, (String)"checks");
            Intrinsics.checkNotNullParameter(results2, (String)"results");
            this.executionId = executionId;
            this.checks = checks;
            this.results = results2;
        }

        @NotNull
        public final String getExecutionId() {
            return this.executionId;
        }

        @NotNull
        public final List<CheckExecution> getChecks() {
            return this.checks;
        }

        @NotNull
        public final ListenableFuture<List<CheckExecutionResult>> getResults() {
            return this.results;
        }

        @NotNull
        public final String component1() {
            return this.executionId;
        }

        @NotNull
        public final List<CheckExecution> component2() {
            return this.checks;
        }

        @NotNull
        public final ListenableFuture<List<CheckExecutionResult>> component3() {
            return this.results;
        }

        @NotNull
        public final CheckBatch copy(@NotNull String executionId, @NotNull List<CheckExecution> checks, @NotNull ListenableFuture<List<CheckExecutionResult>> results2) {
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter(checks, (String)"checks");
            Intrinsics.checkNotNullParameter(results2, (String)"results");
            return new CheckBatch(executionId, checks, results2);
        }

        public static /* synthetic */ CheckBatch copy$default(CheckBatch checkBatch, String string, List list, ListenableFuture listenableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                string = checkBatch.executionId;
            }
            if ((n & 2) != 0) {
                list = checkBatch.checks;
            }
            if ((n & 4) != 0) {
                listenableFuture = checkBatch.results;
            }
            return checkBatch.copy(string, list, listenableFuture);
        }

        @NotNull
        public String toString() {
            return "CheckBatch(executionId=" + this.executionId + ", checks=" + this.checks + ", results=" + this.results + ')';
        }

        public int hashCode() {
            int result2 = this.executionId.hashCode();
            result2 = result2 * 31 + ((Object)this.checks).hashCode();
            result2 = result2 * 31 + this.results.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CheckBatch)) {
                return false;
            }
            CheckBatch checkBatch = (CheckBatch)other;
            if (!Intrinsics.areEqual((Object)this.executionId, (Object)checkBatch.executionId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.checks, checkBatch.checks)) {
                return false;
            }
            return Intrinsics.areEqual(this.results, checkBatch.results);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor$CheckExecution;", "", "request", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "result", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/atlassian/jira/migration/preflight/model/CheckExecutionResult;", "(Lcom/atlassian/cmpt/check/base/CheckRequest;Lcom/google/common/util/concurrent/ListenableFuture;)V", "getRequest", "()Lcom/atlassian/cmpt/check/base/CheckRequest;", "getResult", "()Lcom/google/common/util/concurrent/ListenableFuture;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class CheckExecution {
        @NotNull
        private final CheckRequest request;
        @NotNull
        private final ListenableFuture<CheckExecutionResult> result;

        public CheckExecution(@NotNull CheckRequest request, @NotNull ListenableFuture<CheckExecutionResult> result2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.request = request;
            this.result = result2;
        }

        @NotNull
        public final CheckRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final ListenableFuture<CheckExecutionResult> getResult() {
            return this.result;
        }

        @NotNull
        public final CheckRequest component1() {
            return this.request;
        }

        @NotNull
        public final ListenableFuture<CheckExecutionResult> component2() {
            return this.result;
        }

        @NotNull
        public final CheckExecution copy(@NotNull CheckRequest request, @NotNull ListenableFuture<CheckExecutionResult> result2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            return new CheckExecution(request, result2);
        }

        public static /* synthetic */ CheckExecution copy$default(CheckExecution checkExecution, CheckRequest checkRequest, ListenableFuture listenableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                checkRequest = checkExecution.request;
            }
            if ((n & 2) != 0) {
                listenableFuture = checkExecution.result;
            }
            return checkExecution.copy(checkRequest, listenableFuture);
        }

        @NotNull
        public String toString() {
            return "CheckExecution(request=" + this.request + ", result=" + this.result + ')';
        }

        public int hashCode() {
            int result2 = this.request.hashCode();
            result2 = result2 * 31 + this.result.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CheckExecution)) {
                return false;
            }
            CheckExecution checkExecution = (CheckExecution)other;
            if (!Intrinsics.areEqual((Object)this.request, (Object)checkExecution.request)) {
                return false;
            }
            return Intrinsics.areEqual(this.result, checkExecution.result);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor$Companion;", "", "()V", "EXECUTION_FAILED", "", "FAILED", "MAX_EXCEPTION_MESSAGE_LENGTH", "", "NO_SPACE_ON_DEVICE_ERR_CHECK", "SUCCESS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "extractResult", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "checkExecution", "Lcom/atlassian/jira/migration/preflight/AsyncCheckExecutor$CheckExecution;", "getExecutionError", "Lcom/atlassian/cmpt/check/base/CheckResult;", "exception", "Ljava/util/concurrent/ExecutionException;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final CheckStatus extractResult(CheckExecution checkExecution) {
            try {
                if (checkExecution.getResult().isDone()) {
                    CheckExecutionResult result2 = (CheckExecutionResult)checkExecution.getResult().get();
                    return new CheckStatus(checkExecution.getRequest().checkType, result2.getCheckResult(), Long.valueOf(result2.getLastExecutionTime()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Logger logger2 = log;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLog$cp(...)");
                LogLevel logLevel = LogLevel.ERROR;
                String string = checkExecution.getRequest().checkType;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
                CheckType checkType = CheckType.valueOf(string);
                PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Preflight Execution Error", logLevel, checkType, "", null, e, 16, null));
                CheckResult executionError = this.getExecutionError(checkExecution, e);
                return new CheckStatus(checkExecution.getRequest().checkType, executionError, Long.valueOf(0L));
            }
            catch (CancellationException e) {
                Logger logger3 = log;
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"access$getLog$cp(...)");
                String string = checkExecution.getRequest().checkType;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
                CheckType checkType = CheckType.valueOf(string);
                PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("Preflight Cancelled", null, checkType, null, null, e, 26, null));
            }
            return new CheckStatus(checkExecution.getRequest().checkType, null, Long.valueOf(0L));
        }

        /*
         * Enabled aggressive block sorting
         */
        private final CheckResult getExecutionError(CheckExecution checkExecution, ExecutionException exception) {
            CheckResult checkResult;
            Throwable rootCause = PreflightUtils.Companion.rootCause(exception);
            String string = checkExecution.getRequest().checkType;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
            new PreflightLogMessage("Preflight Execution Root Cause Error", LogLevel.ERROR, CheckType.valueOf(string), null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"rootCause", (Object)rootCause)), null, 40, null);
            String string2 = checkExecution.getRequest().checkType;
            Intrinsics.checkNotNull((Object)string2);
            if (!Intrinsics.areEqual((Object)"ProjectErrorReport", (Object)string2)) {
                checkResult = Checker.buildCheckResultWithExecutionError((int)ExecutionErrorCodes.GENERIC.getErrorCode());
                return checkResult;
            }
            if (rootCause instanceof AccessDeniedException) {
                checkResult = Checker.buildCheckResultWithExecutionError((int)DiskCheckErrorCode.ACCESS_DENIED_ERR_CODE.getErrorCode());
                return checkResult;
            }
            if (rootCause instanceof IOException) {
                String string3 = rootCause.getMessage();
                boolean bl = string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)AsyncCheckExecutor.NO_SPACE_ON_DEVICE_ERR_CHECK, (boolean)false, (int)2, null) : false;
                if (bl) {
                    checkResult = Checker.buildCheckResultWithExecutionError((int)DiskCheckErrorCode.NO_SPACE_ON_DEVICE_ERR_CODE.getErrorCode());
                    return checkResult;
                }
            }
            checkResult = Checker.buildCheckResultWithExecutionError((int)ExecutionErrorCodes.GENERIC.getErrorCode());
            return checkResult;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

