/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.email.UserEmailFixer;
import com.atlassian.jira.migration.email.db.CorrectedEmailRepository;
import com.atlassian.jira.migration.email.model.CorrectedEmail;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.MergedUsers;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;", "", "correctedEmailRepository", "Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;", "userEmailFixer", "Lcom/atlassian/jira/migration/email/UserEmailFixer;", "(Lcom/atlassian/jira/migration/email/db/CorrectedEmailRepository;Lcom/atlassian/jira/migration/email/UserEmailFixer;)V", "findDuplicatesInFix", "", "", "request", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "emailCheckType", "Lcom/atlassian/migration/udc/common/model/EmailCheckType;", "udcMode", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UDCMode;", "generateCsv", "emails", "injectBiCompatibilityWithUdcInfo", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBulkImportCompatibilityWithUdcService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BulkImportCompatibilityWithUdcService.kt\ncom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n494#2,7:100\n372#2,7:123\n526#2:133\n511#2,6:134\n125#3:107\n152#3,2:108\n154#3:114\n1549#4:110\n1620#4,3:111\n1549#4:115\n1620#4,3:116\n1477#4:119\n1502#4,3:120\n1505#4,3:130\n*S KotlinDebug\n*F\n+ 1 BulkImportCompatibilityWithUdcService.kt\ncom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService\n*L\n36#1:100,7\n59#1:123,7\n62#1:133\n62#1:134,6\n37#1:107\n37#1:108,2\n37#1:114\n40#1:110\n40#1:111,3\n58#1:115\n58#1:116,3\n59#1:119\n59#1:120,3\n59#1:130,3\n*E\n"})
public final class BulkImportCompatibilityWithUdcService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CorrectedEmailRepository correctedEmailRepository;
    @NotNull
    private final UserEmailFixer userEmailFixer;
    @NotNull
    public static final String BI_WITH_MERGE = "isBulkImportWithMerge";
    @NotNull
    public static final String BI_WITH_CSV_MERGE = "isBulkImportWithCsvMerge";

    @Inject
    public BulkImportCompatibilityWithUdcService(@NotNull CorrectedEmailRepository correctedEmailRepository, @NotNull UserEmailFixer userEmailFixer) {
        Intrinsics.checkNotNullParameter((Object)correctedEmailRepository, (String)"correctedEmailRepository");
        Intrinsics.checkNotNullParameter((Object)userEmailFixer, (String)"userEmailFixer");
        this.correctedEmailRepository = correctedEmailRepository;
        this.userEmailFixer = userEmailFixer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> findDuplicatesInFix(@NotNull CheckRequest request, @NotNull EmailCheckType emailCheckType, @NotNull UDCMode udcMode) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object sanitizedCorrectedEmailsToOriginal;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Object it;
        Map $this$filterValues$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)emailCheckType, (String)"emailCheckType");
        Intrinsics.checkNotNullParameter((Object)udcMode, (String)"udcMode");
        List<JiraUser> fixedUsers = PreflightCheckKt.getUsersFixedData(request).getFixAllEmailsResult().allFixedUsers();
        Map<JiraUser, MergedUsers> map = this.userEmailFixer.mergeDuplicateUsers(fixedUsers);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            it = (MergedUsers)entry$iv.getValue();
            boolean bl = false;
            boolean bl2 = !((Collection)((MergedUsers)it).getMergedUsers()).isEmpty();
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$map22 = false;
        result$iv = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        it = $this$mapTo$iv$iv2.entrySet().iterator();
        while (it.hasNext()) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)it.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = new String[]{((JiraUser)it2.getKey()).getEmail()};
            Set allMergedUsers = SetsKt.mutableSetOf((Object[])object);
            object = ((MergedUsers)it2.getValue()).getMergedUsers();
            Set set = allMergedUsers;
            boolean $i$f$map = false;
            void var19_32 = $this$map$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void user;
                JiraUser jiraUser = (JiraUser)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                collection2.add(UserEmailFixer.Companion.sanitizeDuplicatedEmailForMerge(user.getEmail()));
            }
            set.addAll((List)destination$iv$iv2);
            collection.add(allMergedUsers);
        }
        Set allMergedUsers = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        if (allMergedUsers.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable $i$f$map22 = emailCheckType == EmailCheckType.DUP && udcMode == UDCMode.ADVANCED ? CorrectedEmailRepository.fetchByEmailCheckTypeWithValidEmails$default(this.correctedEmailRepository, emailCheckType, udcMode, false, 4, null) : CorrectedEmailRepository.fetchByEmailCheckType$default(this.correctedEmailRepository, emailCheckType, udcMode, false, 4, null);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Object destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void correctedEmailRecord;
            CorrectedEmail bl = (CorrectedEmail)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            collection.add(correctedEmailRecord.getNewEmail());
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it3 = (String)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = UserEmailFixer.Companion.sanitizeDuplicatedEmailForMerge(it3);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = sanitizedCorrectedEmailsToOriginal = destination$iv$iv3;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it4 = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            if (!allMergedUsers.contains(it4.getKey())) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)destination$iv$iv3.values()));
    }

    public final void injectBiCompatibilityWithUdcInfo(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Object biWithCsvMergeDuplicatedUsers;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        if (dto.getDetails() == null) {
            dto.setDetails(new CheckDetailsDto());
        }
        boolean bl = (object2 = checkResult) != null && (object2 = ((CheckResult)object2).details) != null ? object2.containsKey(BI_WITH_MERGE) : false;
        if (bl) {
            Map map = dto.getDetails().getInfo();
            if (map == null || (map = MapsKt.toMutableMap((Map)map)) == null) {
                map = new LinkedHashMap();
            }
            Map info = map;
            info.put(BI_WITH_MERGE, true);
            dto.getDetails().setInfo(info);
        }
        Object v3 = (object = checkResult) != null && (object = ((CheckResult)object).details) != null ? object.get(BI_WITH_CSV_MERGE) : (biWithCsvMergeDuplicatedUsers = null);
        if (biWithCsvMergeDuplicatedUsers != null) {
            Set users2 = biWithCsvMergeDuplicatedUsers;
            String csvText = this.generateCsv(users2);
            Map map = dto.getDetails().getInfo();
            if (map == null || (map = MapsKt.toMutableMap((Map)map)) == null) {
                map = new LinkedHashMap();
            }
            Map info = map;
            info.put(BI_WITH_CSV_MERGE, csvText);
            dto.getDetails().setInfo(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public final String generateCsv(@NotNull Set<String> emails) {
        Intrinsics.checkNotNullParameter(emails, (String)"emails");
        StringWriter stringWriter = new StringWriter();
        Closeable closeable = (Closeable)new CsvListWriter((Writer)stringWriter, CsvPreference.STANDARD_PREFERENCE);
        Throwable throwable = null;
        try {
            CsvListWriter it = (CsvListWriter)closeable;
            boolean bl = false;
            String[] stringArray = new String[]{"Email"};
            it.writeHeader(stringArray);
            for (String email : emails) {
                String[] stringArray2 = new String[]{email};
                it.write(stringArray2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService$Companion;", "", "()V", "BI_WITH_CSV_MERGE", "", "BI_WITH_MERGE", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

