/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.jira.migration.preflight.AppCheckResult;
import com.atlassian.jira.migration.preflight.CheckResultDto;
import com.atlassian.jira.migration.preflight.CheckStatusDto;
import com.atlassian.jira.migration.preflight.NotBlockingCheckResultDto;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/CheckStatusConverter;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "deserialize", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "json", "", "deserializeDetails", "", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "details", "fromDTO", "dto", "Lcom/atlassian/jira/migration/preflight/CheckStatusDto;", "serialize", "status", "toDTO", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightCheckRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightCheckRepository.kt\ncom/atlassian/jira/migration/preflight/CheckStatusConverter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n453#2:293\n403#2:294\n453#2:297\n403#2:298\n1238#3,2:295\n1238#3,4:299\n1241#3:303\n*S KotlinDebug\n*F\n+ 1 PreflightCheckRepository.kt\ncom/atlassian/jira/migration/preflight/CheckStatusConverter\n*L\n240#1:293\n240#1:294\n242#1:297\n242#1:298\n240#1:295,2\n242#1:299,4\n240#1:303\n*E\n"})
public final class CheckStatusConverter {
    @NotNull
    public static final CheckStatusConverter INSTANCE = new CheckStatusConverter();
    private static final ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new KotlinModule.Builder().build());

    private CheckStatusConverter() {
    }

    @NotNull
    public final String serialize(@NotNull CheckStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        CheckStatusDto dto = this.toDTO(status);
        String string = mapper.writeValueAsString((Object)dto);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @NotNull
    public final CheckStatus deserialize(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Object object = mapper.readValue(json, CheckStatusDto.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        CheckStatusDto dto = (CheckStatusDto)object;
        return this.fromDTO(dto);
    }

    private final CheckStatusDto toDTO(CheckStatus status) {
        CheckResultDto checkResultDto;
        CheckResult checkResult = status.checkResult;
        if (checkResult instanceof NotBlockingCheckResult) {
            boolean bl = ((NotBlockingCheckResult)checkResult).getHasWarnings();
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResultDto = new NotBlockingCheckResultDto(bl, map);
        } else if (checkResult != null) {
            boolean bl = checkResult.success;
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResultDto = new CheckResultDto(bl, map);
        } else {
            checkResultDto = null;
        }
        CheckResultDto checkResultDto2 = checkResultDto;
        String string = status.checkType;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
        Long l = status.lastExecutionTime;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"lastExecutionTime");
        return new CheckStatusDto(string, checkResultDto2, ((Number)l).longValue());
    }

    private final CheckStatus fromDTO(CheckStatusDto dto) {
        CheckResultDto resultDto = dto.getCheckResult();
        CheckResult checkResult = resultDto instanceof NotBlockingCheckResultDto ? (CheckResult)new NotBlockingCheckResult(!((NotBlockingCheckResultDto)resultDto).getHasWarnings(), this.deserializeDetails(CheckType.Companion.fromString(dto.getCheckType()), ((NotBlockingCheckResultDto)resultDto).getDetails())) : (resultDto != null ? new CheckResult(resultDto.getSuccess(), resultDto.getDetails()) : null);
        return new CheckStatus(dto.getCheckType(), checkResult, Long.valueOf(dto.getLastExecutionTime()));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> deserializeDetails(CheckType checkType, Map<String, ? extends Object> details2) {
        Map map;
        if (checkType != CheckType.AppVendorCheck) {
            map = details2;
        } else {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = details2;
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapValuesTo$iv$iv2;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                Object value = entry2.getValue();
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map $this$mapValues$iv2 = (Map)value;
                boolean $i$f$mapValues2 = false;
                Map map5 = $this$mapValues$iv2;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
                boolean $i$f$mapValuesTo2 = false;
                Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv2.entrySet();
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv2) {
                    void it$iv$iv2;
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv2;
                    Map map6 = destination$iv$iv2;
                    $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                    Map.Entry entry4 = (Map.Entry)element$iv$iv$iv2;
                    Object k2 = it$iv$iv2.getKey();
                    Map map7 = map6;
                    boolean bl3 = false;
                    Object nestedValue = entry4.getValue();
                    Intrinsics.checkNotNull(nestedValue, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    AppCheckResult appCheckResult = AppCheckResult.Companion.fromMap((Map)nestedValue);
                    map7.put(k2, appCheckResult);
                }
                Map map8 = destination$iv$iv2;
                map4.put(k, map8);
            }
            map = destination$iv$iv;
        }
        return map;
    }
}

