/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.migrationservice.CloudSiteRequestEntry;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.SiteDetailsRequest;
import com.atlassian.jira.migration.migrationservice.SiteDetailsResponse;
import com.atlassian.jira.migration.migrationservice.SiteDetailsWithCloudId;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.preflight.FreeEditionResult;
import com.atlassian.jira.migration.preflight.JiraProductsCloudFreeUserLimitPreflightService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\bH\u0016J\f\u0010\u001c\u001a\u00020\u0013*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/preflight/CloudFreeUserLimitPreflightService;", "Lcom/atlassian/jira/migration/preflight/JiraProductsCloudFreeUserLimitPreflightService;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;)V", "getCurrentSiteDetails", "Lcom/atlassian/jira/migration/migrationservice/SiteDetailsResponse;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "getEdition", "", "currentSiteDetails", "it", "Lcom/atlassian/jira/migration/migrationservice/SiteDetailsWithCloudId;", "getSavedCloudDetails", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "isCloudEditionChanged", "", "savedCloudSite", "siteDetailsResponse", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "redirectLinkToBilling", "cloudSite", "updateEdition", "", "hasAnyFreeEditionSubscription", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudFreeUserLimitPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudFreeUserLimitPreflightService.kt\ncom/atlassian/jira/migration/preflight/CloudFreeUserLimitPreflightService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1855#2,2:109\n1360#2:111\n1446#2,5:112\n766#2:117\n857#2,2:118\n2624#2,3:120\n1360#2:123\n1446#2,5:124\n766#2:129\n857#2,2:130\n1747#2,3:132\n*S KotlinDebug\n*F\n+ 1 CloudFreeUserLimitPreflightService.kt\ncom/atlassian/jira/migration/preflight/CloudFreeUserLimitPreflightService\n*L\n47#1:109,2\n72#1:111\n72#1:112,5\n72#1:117\n72#1:118,2\n72#1:120,3\n98#1:123\n98#1:124,5\n98#1:129\n98#1:130,2\n98#1:132,3\n*E\n"})
public final class CloudFreeUserLimitPreflightService
extends JiraProductsCloudFreeUserLimitPreflightService {
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;

    @Inject
    public CloudFreeUserLimitPreflightService(@NotNull MigrationServiceClient migrationServiceClient, @NotNull CloudSiteRepository cloudSiteRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        this.migrationServiceClient = migrationServiceClient;
        this.cloudSiteRepository = cloudSiteRepository;
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        CloudSite savedCloudSiteDetails = this.getSavedCloudDetails(checkRequest);
        SiteDetailsResponse currentSiteDetails = this.getCurrentSiteDetails(checkRequest);
        CheckResult checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"RESULT_KEY", (Object)new FreeEditionResult(this.isCloudEditionChanged(savedCloudSiteDetails, currentSiteDetails), this.hasAnyFreeEditionSubscription(currentSiteDetails), this.redirectLinkToBilling(savedCloudSiteDetails)))));
        this.updateEdition(savedCloudSiteDetails, currentSiteDetails);
        return checkResult;
    }

    @Override
    public void updateEdition(@NotNull CloudSite savedCloudSite, @NotNull SiteDetailsResponse currentSiteDetails) {
        Intrinsics.checkNotNullParameter((Object)savedCloudSite, (String)"savedCloudSite");
        Intrinsics.checkNotNullParameter((Object)currentSiteDetails, (String)"currentSiteDetails");
        Iterable $this$forEach$iv = currentSiteDetails.getSites();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SiteDetailsWithCloudId it = (SiteDetailsWithCloudId)element$iv;
            boolean bl = false;
            CloudSite $this$updateEdition_u24lambda_u241_u24lambda_u240 = savedCloudSite;
            boolean bl2 = false;
            this.cloudSiteRepository.saveOrUpdate($this$updateEdition_u24lambda_u241_u24lambda_u240.getCloudId(), $this$updateEdition_u24lambda_u241_u24lambda_u240.getCloudUrl(), $this$updateEdition_u24lambda_u241_u24lambda_u240.getContainerToken(), this.getEdition(currentSiteDetails, it), it.getProducts(), $this$updateEdition_u24lambda_u241_u24lambda_u240.getCloudType());
        }
    }

    private final String getEdition(SiteDetailsResponse currentSiteDetails, SiteDetailsWithCloudId it) {
        return this.hasAnyFreeEditionSubscription(currentSiteDetails) ? "FREE" : ((TcsProductInfo)CollectionsKt.first(it.getProducts())).getEdition().name();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCloudEditionChanged(CloudSite savedCloudSite, SiteDetailsResponse siteDetailsResponse) {
        boolean bl;
        block7: {
            Edition edition = savedCloudSite.getCloudEdition();
            if (edition != null) {
                void $this$none$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Object it;
                void $this$flatMapTo$iv$iv;
                Edition edition2 = edition;
                boolean bl2 = false;
                Iterable $this$flatMap$iv = siteDetailsResponse.getSites();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (SiteDetailsWithCloudId)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = ((SiteDetailsWithCloudId)it).getProducts();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$flatMapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (TcsProductInfo)element$iv$iv;
                    boolean bl4 = false;
                    if (!(((TcsProductInfo)it).getProductKey() != Product.JIRA_SERVICEDESK)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        TcsProductInfo it2 = (TcsProductInfo)element$iv;
                        boolean bl5 = false;
                        if (!(it2.getEdition() == edition2)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public SiteDetailsResponse getCurrentSiteDetails(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        if (checkRequest.parameters == null) {
            boolean bl = false;
            String string = "Free Edition preflight check request parameter not found.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Product[]{Product.JIRA_CORE, Product.JIRA_SOFTWARE, Product.JIRA_SERVICEDESK};
        return this.migrationServiceClient.fetchSiteDetails(PreflightCheckKt.getContainerToken(checkRequest), new SiteDetailsRequest(SetsKt.setOf((Object)new CloudSiteRequestEntry(PreflightCheckKt.getCloudId(checkRequest), SetsKt.setOfNotNull((Object[])objectArray)))));
    }

    @Override
    @NotNull
    public CloudSite getSavedCloudDetails(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(PreflightCheckKt.getCloudId(checkRequest));
        Intrinsics.checkNotNull((Object)cloudSite2);
        return cloudSite2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasAnyFreeEditionSubscription(SiteDetailsResponse $this$hasAnyFreeEditionSubscription) {
        boolean bl;
        block5: {
            void $this$filterTo$iv$iv;
            Object it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = $this$hasAnyFreeEditionSubscription.getSites();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (SiteDetailsWithCloudId)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = ((SiteDetailsWithCloudId)it).getProducts();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TcsProductInfo)element$iv$iv;
                boolean bl3 = false;
                if (!(((TcsProductInfo)it).getProductKey() != Product.JIRA_SERVICEDESK)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TcsProductInfo it2 = (TcsProductInfo)element$iv;
                    boolean bl4 = false;
                    if (!(it2.getEdition() == Edition.FREE)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String redirectLinkToBilling(CloudSite cloudSite2) {
        return cloudSite2.getCloudUrl() + "/admin/billing/applications";
    }
}

