/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.CloudSiteNotEmptyCheckKt;
import com.atlassian.jira.migration.preflight.CloudSiteNotEmptyCheckResult;
import com.atlassian.jira.migration.preflight.CloudSiteNotEmptyCsvData;
import com.atlassian.jira.migration.preflight.CloudSiteNotEmptyService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0014J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0011H\u0016J$\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/preflight/CloudSiteNotEmptyCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "cloudSiteNotEmptyService", "Lcom/atlassian/jira/migration/preflight/CloudSiteNotEmptyService;", "(Lcom/atlassian/jira/migration/preflight/CloudSiteNotEmptyService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "numberOfProjectsInTrash", "", "projectList", "", "Lcom/atlassian/jira/migration/preflight/CloudSiteNotEmptyCheckResult;", "performCheck", "checkRequest", "retrieveProjectList", "details", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudSiteNotEmptyCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudSiteNotEmptyCheck.kt\ncom/atlassian/jira/migration/preflight/CloudSiteNotEmptyCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1855#2,2:179\n1774#2,4:181\n*S KotlinDebug\n*F\n+ 1 CloudSiteNotEmptyCheck.kt\ncom/atlassian/jira/migration/preflight/CloudSiteNotEmptyCheck\n*L\n109#1:179,2\n137#1:181,4\n*E\n"})
public final class CloudSiteNotEmptyCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final CloudSiteNotEmptyService cloudSiteNotEmptyService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public CloudSiteNotEmptyCheck(@NotNull CloudSiteNotEmptyService cloudSiteNotEmptyService) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteNotEmptyService, (String)"cloudSiteNotEmptyService");
        this.cloudSiteNotEmptyService = cloudSiteNotEmptyService;
        this.checkType = CheckType.CloudSiteNotEmpty;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"preflightChecksToOverride", ctx.getPreflightChecksToOverride()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.cloudSiteNotEmptyService.performCheck(checkRequest);
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            dto.setNumberOfOccurrences(Integer.valueOf(0));
            CheckResult checkResult2 = checkResult;
            List<CloudSiteNotEmptyCheckResult> projectList = this.retrieveProjectList(checkResult2 != null ? checkResult2.details : null);
            int numberOfProjectsInTrash = this.numberOfProjectsInTrash(projectList);
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    dto.setDescription("Checking if migrating all data at once is available for your cloud site");
                    break;
                }
                case 2: {
                    if (numberOfProjectsInTrash > 0) {
                        dto.setStatus(Status.WARNING);
                        dto.setDescription("Projects in trash will be deleted");
                        break;
                    }
                    dto.setDescription("Migrating all data at once is available for your cloud site");
                    break;
                }
                case 3: {
                    dto.setDescription("We couldn't check if migrating all data at once is available for your cloud site");
                    break;
                }
                default: {
                    if (checkResult == null) {
                        dto.setStatus(Status.RUNNING);
                        dto.setDescription("Checking if migrating all data at once is available for your cloud site");
                        break;
                    }
                    dto.setStatus(Status.ERROR);
                    dto.setDescription("Migrating all data at once is not available for your cloud site");
                }
            }
            CheckResult checkResult3 = checkResult;
            if (checkResult3 == null) break block9;
            CheckResult it = checkResult3;
            boolean bl = false;
            dto.setNumberOfOccurrences(Integer.valueOf(projectList.size()));
            Boolean bl2 = it.details.getOrDefault("overrideCloudSite", false);
            Intrinsics.checkNotNull((Object)bl2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean overrideCloudSite = bl2;
            if (overrideCloudSite) {
                dto.setDescription("Migrating all data at once will overwrite existing data in your cloud site");
            }
            CheckDetailsDto details2 = new CheckDetailsDto();
            details2.setLongDescription(dto.getDescription());
            details2.setListOfOccurrences(projectList);
            if (dto.getStatus() == Status.ERROR) {
                Pair[] pairArray = new Pair[3];
                pairArray[0] = TuplesKt.to((Object)"isCloudSiteTrashEmpty", (Object)(numberOfProjectsInTrash <= 0 ? 1 : 0));
                pairArray[1] = TuplesKt.to((Object)"lastCloudSiteBackupDate", it.details.get("lastBackUpDate"));
                Boolean bl3 = it.details.getOrDefault("backupRequired", true);
                Intrinsics.checkNotNull((Object)bl3, (String)"null cannot be cast to non-null type kotlin.Boolean");
                pairArray[2] = TuplesKt.to((Object)"hasRecentCloudSiteBackup", (Object)(bl3 == false ? 1 : 0));
                details2.setInfo(MapsKt.mapOf((Pair[])pairArray));
            }
            dto.setDetails(details2);
        }
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return executionId + '-' + type.name() + "-result.csv";
    }

    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        if (checkStatus.checkResult == null || checkStatus.checkResult.success && checkStatus.checkResult.details.isEmpty() || checkStatus.checkResult.details.get("cloudSiteNotEmptyResults") == null) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)CloudSiteNotEmptyCheckKt.getCLOUD_SITE_NOT_EMPTY_CSV_HEADERS()));
        }
        List<CloudSiteNotEmptyCheckResult> projects = this.retrieveProjectList(checkStatus.checkResult.details);
        List beans = new ArrayList();
        Iterable $this$forEach$iv = projects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloudSiteNotEmptyCheckResult it = (CloudSiteNotEmptyCheckResult)element$iv;
            boolean bl = false;
            beans.add(new CloudSiteNotEmptyCsvData(it.getProjectKey(), it.getProjectName(), it.getProjectUrl(), it.getProjectStatus()));
        }
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"headers", (Object)CloudSiteNotEmptyCheckKt.getCLOUD_SITE_NOT_EMPTY_CSV_HEADERS());
        String[] stringArray = new String[]{"key", "name", "url", "status"};
        pairArray[1] = TuplesKt.to((Object)"mappings", (Object)stringArray);
        pairArray[2] = TuplesKt.to((Object)"beans", (Object)beans);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final List<CloudSiteNotEmptyCheckResult> retrieveProjectList(Map<String, ? extends Object> details2) {
        List list;
        if (details2 == null) {
            list = CollectionsKt.emptyList();
        } else {
            Object object = details2.getOrDefault("cloudSiteNotEmptyResults", CollectionsKt.emptyList());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<com.atlassian.jira.migration.preflight.CloudSiteNotEmptyCheckResult>");
            list = (List)object;
        }
        return list;
    }

    private final int numberOfProjectsInTrash(List<CloudSiteNotEmptyCheckResult> projectList) {
        int n;
        Iterable $this$count$iv = projectList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CloudSiteNotEmptyCheckResult it = (CloudSiteNotEmptyCheckResult)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProjectStatus(), (Object)"DELETED") || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

