/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.jiracloudservice.GetJiraCloudBackupInformationResponse;
import com.atlassian.jira.migration.jiracloudservice.GetJiraCloudProjectsResponse;
import com.atlassian.jira.migration.jiracloudservice.JiraCloudClient;
import com.atlassian.jira.migration.preflight.CloudSiteNotEmptyCheckResult;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.migration.api.ContainerToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/preflight/CloudSiteNotEmptyService;", "", "jiraCloudClient", "Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "(Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;)V", "getCloudProjectUrl", "", "cloudId", "numberOfProjectsInTrash", "", "projectList", "", "Lcom/atlassian/jira/migration/preflight/CloudSiteNotEmptyCheckResult;", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudSiteNotEmptyService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudSiteNotEmptyService.kt\ncom/atlassian/jira/migration/preflight/CloudSiteNotEmptyService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1549#2:75\n1620#2,3:76\n1774#2,4:79\n*S KotlinDebug\n*F\n+ 1 CloudSiteNotEmptyService.kt\ncom/atlassian/jira/migration/preflight/CloudSiteNotEmptyService\n*L\n28#1:75\n28#1:76,3\n53#1:79,4\n*E\n"})
public final class CloudSiteNotEmptyService {
    @NotNull
    private final JiraCloudClient jiraCloudClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;

    @Inject
    public CloudSiteNotEmptyService(@NotNull JiraCloudClient jiraCloudClient, @NotNull CloudSiteRepository cloudSiteRepository) {
        Intrinsics.checkNotNullParameter((Object)jiraCloudClient, (String)"jiraCloudClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        this.jiraCloudClient = jiraCloudClient;
        this.cloudSiteRepository = cloudSiteRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        ContainerToken containerToken = new ContainerToken(PreflightCheckKt.getContainerToken(checkRequest));
        String cloudId2 = PreflightCheckKt.getCloudId(checkRequest);
        Pair[] $this$map$iv = (Pair[])this.jiraCloudClient.getProjectsForSite(containerToken, cloudId2).getProjectList();
        boolean $i$f$map = false;
        Pair[] pairArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GetJiraCloudProjectsResponse.JiraCloudProject jiraCloudProject = (GetJiraCloudProjectsResponse.JiraCloudProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CloudSiteNotEmptyCheckResult(it.getKey(), it.getName(), this.getCloudProjectUrl(cloudId2), it.getStatus()));
        }
        List existingCloudProjects = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (existingCloudProjects.isEmpty()) {
            return new CheckResult(true);
        }
        Map details2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"cloudSiteNotEmptyResults", (Object)existingCloudProjects));
        if (this.numberOfProjectsInTrash(existingCloudProjects) == existingCloudProjects.size()) {
            checkResult = new CheckResult(true, details2);
        } else {
            GetJiraCloudBackupInformationResponse.JiraCloudBackupInformation cloudBackupInformation = this.jiraCloudClient.getCloudBackupInformation(containerToken, cloudId2).getLastBackupInfo();
            pairArray = new Pair[]{TuplesKt.to((Object)"lastBackUpDate", (Object)cloudBackupInformation.getLastBackUpDate()), TuplesKt.to((Object)"backupRequired", (Object)cloudBackupInformation.getBackupRequired()), TuplesKt.to((Object)"overrideCloudSite", (Object)PreflightCheckKt.getPreflightChecksToOverride(checkRequest).contains((Object)CheckType.CloudSiteNotEmpty))};
            CheckResult checkResult2 = new CheckResult(false, MapsKt.plus((Map)details2, (Map)MapsKt.mapOf((Pair[])pairArray)));
            checkResult = checkResult2;
        }
        return checkResult;
    }

    private final int numberOfProjectsInTrash(List<CloudSiteNotEmptyCheckResult> projectList) {
        int n;
        Iterable $this$count$iv = projectList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CloudSiteNotEmptyCheckResult it = (CloudSiteNotEmptyCheckResult)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProjectStatus(), (Object)"DELETED") || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private final String getCloudProjectUrl(String cloudId2) {
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        if (cloudSite2 == null) {
            return "";
        }
        CloudSite cloudSite3 = cloudSite2;
        return cloudSite3.getCloudUrl() + "/jira/projects";
    }
}

