/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u0002H\u0002J\b\u0010\u000b\u001a\u00020\u0002H\u0002J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/ContainerTokenExpirationCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "(Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "containerTokenExpired", "containerTokenValid", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
public final class ContainerTokenExpirationCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    @NotNull
    private final CheckType checkType;
    @NotNull
    public static final String STATUS_SUCCESS_DESCRIPTION = "Your cloud token is active";
    @NotNull
    public static final String STATUS_RUNNING_DESCRIPTION = "Checking if your cloud token is active";
    @NotNull
    public static final String STATUS_FAILURE_DESCRIPTION = "Your cloud token has expired";
    @NotNull
    public static final String STATUS_EXEC_ERROR_DESCRIPTION = "We couldn\u2019t check if your cloud token is active";

    @Inject
    public ContainerTokenExpirationCheck(@NotNull ContainerTokenTTLService containerTokenTTLService) {
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        this.containerTokenTTLService = containerTokenTTLService;
        this.checkType = CheckType.ContainerTokenExpiration;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.containerTokenTTLService.isValidToken(PreflightCheckKt.getContainerToken(checkRequest)) ? this.containerTokenValid() : this.containerTokenExpired();
    }

    private final CheckResult containerTokenExpired() {
        return new CheckResult(false);
    }

    private final CheckResult containerTokenValid() {
        return new CheckResult(true);
    }

    protected void inject(@Nullable CheckResultDto dto, @Nullable CheckResult checkResult) {
        CheckResultDto checkResultDto = dto;
        if (checkResultDto != null) {
            String string;
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    string = STATUS_SUCCESS_DESCRIPTION;
                    break;
                }
                case 2: {
                    string = STATUS_FAILURE_DESCRIPTION;
                    break;
                }
                case 3: {
                    string = STATUS_RUNNING_DESCRIPTION;
                    break;
                }
                default: {
                    string = STATUS_EXEC_ERROR_DESCRIPTION;
                }
            }
            checkResultDto.setDescription(string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/ContainerTokenExpirationCheck$Companion;", "", "()V", "STATUS_EXEC_ERROR_DESCRIPTION", "", "STATUS_FAILURE_DESCRIPTION", "STATUS_RUNNING_DESCRIPTION", "STATUS_SUCCESS_DESCRIPTION", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

