/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.CrossProjectEntityMissingProjectSelectionCheckKt;
import com.atlassian.jira.migration.preflight.CrossProjectEntityMissingProjectSelectionService;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.csv.CrossProjectEntityMissingProjectSelectionCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "crossProjectEntityMissingProjectSelectionService", "Lcom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService;", "(Lcom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "getMissingProjectKeySet", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCrossProjectEntityMissingProjectSelectionCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossProjectEntityMissingProjectSelectionCheck.kt\ncom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1549#2:95\n1620#2,3:96\n*S KotlinDebug\n*F\n+ 1 CrossProjectEntityMissingProjectSelectionCheck.kt\ncom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionCheck\n*L\n75#1:95\n75#1:96,3\n*E\n"})
public final class CrossProjectEntityMissingProjectSelectionCheck
extends NotBlockingCheck {
    @NotNull
    private final CrossProjectEntityMissingProjectSelectionService crossProjectEntityMissingProjectSelectionService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public CrossProjectEntityMissingProjectSelectionCheck(@NotNull CrossProjectEntityMissingProjectSelectionService crossProjectEntityMissingProjectSelectionService) {
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityMissingProjectSelectionService, (String)"crossProjectEntityMissingProjectSelectionService");
        super("We couldn't check for projects related to cross-project boards and filters", "Checking for projects related to cross-project boards and filters", "All projects related to cross-project boards and filters have been selected", "Not all projects related to cross-project boards and filters have been selected");
        this.crossProjectEntityMissingProjectSelectionService = crossProjectEntityMissingProjectSelectionService;
        this.checkType = CheckType.CrossProjectEntityMissingProjectSelection;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"crossProjectConfig", (Object)ctx.getCrossProjectConfig()), TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.crossProjectEntityMissingProjectSelectionService.performCheck(checkRequest);
    }

    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block1: {
            Set projectKeysMissing;
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            super.inject(dto, checkResult);
            dto.setNumberOfOccurrences(Integer.valueOf(0));
            CheckResult checkResult2 = checkResult;
            if (checkResult2 == null) break block1;
            CheckResult it = checkResult2;
            boolean bl = false;
            Object object = this.getMissingProjectKeySet(it);
            Set set = projectKeysMissing = object instanceof Set ? (Set)object : null;
            if (set != null) {
                Set $this$inject_u24lambda_u241_u24lambda_u240 = set;
                boolean bl2 = false;
                CheckDetailsDto details2 = new CheckDetailsDto();
                details2.setListOfOccurrences(CollectionsKt.listOf((Object)$this$inject_u24lambda_u241_u24lambda_u240));
                dto.setDetails(details2);
                dto.setNumberOfOccurrences(Integer.valueOf($this$inject_u24lambda_u241_u24lambda_u240.size()));
            }
        }
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        String string = planName;
        if (string == null) {
            string = executionId;
        }
        String migrationName = string;
        return migrationName + "_Pre-migration_checks_Cross-projects boards and filters_Missing projects_Jira_" + dateTime + ".csv";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        void $this$mapTo$iv$iv;
        Set projectKeys;
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        Pair[] pairArray = this.getMissingProjectKeySet(checkStatus.checkResult);
        Set set = pairArray instanceof Set ? (Set)pairArray : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        if ((projectKeys = set).isEmpty()) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)CrossProjectEntityMissingProjectSelectionCheckKt.access$getCROSS_PROJECT_ENTITY_MISSING_PROJECT_SELECTION_CHECK_CSV_HEADERS$p()));
        }
        Iterable $this$map$iv = projectKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CrossProjectEntityMissingProjectSelectionCSVData((String)it));
        }
        List beans = (List)destination$iv$iv;
        pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"headers", (Object)CrossProjectEntityMissingProjectSelectionCheckKt.access$getCROSS_PROJECT_ENTITY_MISSING_PROJECT_SELECTION_CHECK_CSV_HEADERS$p());
        String[] stringArray = new String[]{"projectKey"};
        pairArray[1] = TuplesKt.to((Object)"mappings", (Object)stringArray);
        pairArray[2] = TuplesKt.to((Object)"beans", (Object)beans);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Object getMissingProjectKeySet(CheckResult checkResult) {
        Object object = checkResult;
        return object != null && (object = ((CheckResult)object).details) != null ? object.get("missingProjectKeysSelection") : null;
    }
}

