/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.jira.migration.preflight.utils.PreflightUtils;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CPBFilterService;
import com.atlassian.jira.migration.validation.PlanValidation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0012\u0010#\u001a\u00020\u001d2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService;", "", "cpbFilterService", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;", "planValidation", "Lcom/atlassian/jira/migration/validation/PlanValidation;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "crossProjectEntityEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "(Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;Lcom/atlassian/jira/migration/validation/PlanValidation;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;)V", "convertProjectIdsToProjectKeysSet", "", "", "referencedProjectIdsSet", "", "getCrossProjectBoardsAndFiltersMigrationMode", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "getProjectRefInfoSetFromEligibleCrossProjectBoardsAndFilters", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "crossProjectBoardAndFiltersMigrationMode", "selectedProjectKeys", "", "getReferencedProjectKeysFromEligibleCrossProjectBoardsAndFilters", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "sendCrossProjectMissingProjectSelectionCheckStatsEvent", "", "preflightCheckExecutionId", "uniqueId", "timeTakenToComplete", "success", "", "validateCrossProjectBoardsAndFiltersMigrationMode", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCrossProjectEntityMissingProjectSelectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossProjectEntityMissingProjectSelectionService.kt\ncom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1855#2,2:162\n1603#2,9:164\n1855#2:173\n1856#2:175\n1612#2:176\n1#3:174\n*S KotlinDebug\n*F\n+ 1 CrossProjectEntityMissingProjectSelectionService.kt\ncom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService\n*L\n110#1:162,2\n129#1:164,9\n129#1:173\n129#1:175\n129#1:176\n129#1:174\n*E\n"})
public final class CrossProjectEntityMissingProjectSelectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CPBFilterService cpbFilterService;
    @NotNull
    private final PlanValidation planValidation;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final CrossProjectEntityStatsEventService crossProjectEntityEventService;
    private static final Logger log = LoggerFactory.getLogger(CrossProjectEntityMissingProjectSelectionService.class);

    @Inject
    public CrossProjectEntityMissingProjectSelectionService(@NotNull CPBFilterService cpbFilterService, @NotNull PlanValidation planValidation, @NotNull ProjectManager projectManager, @NotNull CrossProjectEntityStatsEventService crossProjectEntityEventService) {
        Intrinsics.checkNotNullParameter((Object)cpbFilterService, (String)"cpbFilterService");
        Intrinsics.checkNotNullParameter((Object)planValidation, (String)"planValidation");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityEventService, (String)"crossProjectEntityEventService");
        this.cpbFilterService = cpbFilterService;
        this.planValidation = planValidation;
        this.projectManager = projectManager;
        this.crossProjectEntityEventService = crossProjectEntityEventService;
    }

    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        NotBlockingCheckResult notBlockingCheckResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.currentTimeMillis();
        List<String> selectedProjectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
        log.debug("Project keys selected: {}", selectedProjectKeys);
        CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode = this.getCrossProjectBoardsAndFiltersMigrationMode(checkRequest);
        log.info("Cross Project Board and Filter Migration Mode selected: {}", (Object)String.valueOf((Object)crossProjectBoardAndFiltersMigrationMode));
        this.validateCrossProjectBoardsAndFiltersMigrationMode(crossProjectBoardAndFiltersMigrationMode);
        CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode2 = crossProjectBoardAndFiltersMigrationMode;
        Intrinsics.checkNotNull((Object)((Object)crossProjectBoardAndFiltersMigrationMode2));
        Set<String> referencedProjectKeys = this.getReferencedProjectKeysFromEligibleCrossProjectBoardsAndFilters(crossProjectBoardAndFiltersMigrationMode2, selectedProjectKeys);
        log.debug("Project keys referenced in cross project boards and filters: {}", referencedProjectKeys);
        Set<String> validProjectKeySelections = PreflightUtils.Companion.getValidProjectKeysSelections(selectedProjectKeys, this.planValidation);
        log.debug("Valid project key selections: {}", validProjectKeySelections);
        Set<String> projectKeysNotSelectedForMigration = PreflightUtils.Companion.getProjectKeysNotSelectedForMigration(referencedProjectKeys, validProjectKeySelections);
        if (projectKeysNotSelectedForMigration.isEmpty()) {
            log.info("All referenced project keys are selected for migration");
            notBlockingCheckResult = new NotBlockingCheckResult(true);
        } else {
            log.info("Project keys: " + projectKeysNotSelectedForMigration + " are not selected for migration");
            notBlockingCheckResult = new NotBlockingCheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"missingProjectKeysSelection", projectKeysNotSelectedForMigration)));
        }
        NotBlockingCheckResult checkResult = notBlockingCheckResult;
        long endTime = System.currentTimeMillis();
        long elapsedTime2 = endTime - startTime;
        log.debug(checkRequest.checkType + " took " + elapsedTime2 + " ms to finish");
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.sendCrossProjectMissingProjectSelectionCheckStatsEvent(string, string2, elapsedTime2, !checkResult.getHasWarnings(), crossProjectBoardAndFiltersMigrationMode);
        return checkResult;
    }

    private final CrossProjectBoardAndFiltersMigrationMode getCrossProjectBoardsAndFiltersMigrationMode(CheckRequest checkRequest) {
        CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode;
        if (PreflightCheckKt.getCrossProjectConfig(checkRequest) != null) {
            CrossProjectConfig crossProjectConfig = PreflightCheckKt.getCrossProjectConfig(checkRequest);
            Intrinsics.checkNotNull((Object)crossProjectConfig);
            CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption = crossProjectConfig.getCrossProjectExportConfig().getCrossProjectDataMigrationOption();
            crossProjectBoardAndFiltersMigrationMode = crossProjectBoardsAndFiltersMigrationOption != null ? crossProjectBoardsAndFiltersMigrationOption.getBoardsAndFiltersMigrationMode() : null;
        } else {
            crossProjectBoardAndFiltersMigrationMode = null;
        }
        return crossProjectBoardAndFiltersMigrationMode;
    }

    private final void validateCrossProjectBoardsAndFiltersMigrationMode(CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode) {
        if (!(crossProjectBoardAndFiltersMigrationMode == CrossProjectBoardAndFiltersMigrationMode.ALL || crossProjectBoardAndFiltersMigrationMode == CrossProjectBoardAndFiltersMigrationMode.SELECTED_PROJECTS)) {
            boolean bl = false;
            String string = "Unsupported migration mode for cross project boards and filters";
            throw new IllegalStateException(string.toString());
        }
    }

    private final Set<String> getReferencedProjectKeysFromEligibleCrossProjectBoardsAndFilters(CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, List<String> selectedProjectKeys) {
        Set<FilterJqlService.JqlProjectReferenceInfo> jqlProjectRefInfoSetFromEligibleCrossProjectBoardsAndFilters = this.getProjectRefInfoSetFromEligibleCrossProjectBoardsAndFilters(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeys);
        Set referencedProjectIdsSet = new LinkedHashSet();
        Iterable $this$forEach$iv = jqlProjectRefInfoSetFromEligibleCrossProjectBoardsAndFilters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilterJqlService.JqlProjectReferenceInfo it = (FilterJqlService.JqlProjectReferenceInfo)element$iv;
            boolean bl = false;
            referencedProjectIdsSet.addAll((Collection)it.getReferringProjectIds());
        }
        return this.convertProjectIdsToProjectKeysSet(referencedProjectIdsSet);
    }

    @NotNull
    public final Set<FilterJqlService.JqlProjectReferenceInfo> getProjectRefInfoSetFromEligibleCrossProjectBoardsAndFilters(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, @NotNull List<String> selectedProjectKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        return this.cpbFilterService.getJqlProjectRefInfoSetFromEligibleCrossProjectFilters(crossProjectBoardAndFiltersMigrationMode, selectedProjectKeys);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> convertProjectIdsToProjectKeysSet(Set<Long> referencedProjectIdsSet) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = referencedProjectIdsSet;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            try {
                Project project = this.projectManager.getProjectObj(Long.valueOf(it));
                string = project != null ? project.getKey() : null;
            }
            catch (DataAccessException ex) {
                log.error("Could not fetch project with id " + it + " \n" + ex.getMessage());
                throw ex;
            }
            if (string == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final void sendCrossProjectMissingProjectSelectionCheckStatsEvent(String preflightCheckExecutionId, String uniqueId, long timeTakenToComplete, boolean success, CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode) {
        this.crossProjectEntityEventService.sendCrossProjectRapidViewFilterMissingProjectSelectionCheckStatsEvent(preflightCheckExecutionId, uniqueId, timeTakenToComplete, success, crossProjectBoardAndFiltersMigrationMode);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/CrossProjectEntityMissingProjectSelectionService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

