/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.export.core.portalpage.DashboardsExtractionHelper;
import com.atlassian.jira.migration.export.core.portalpage.PortletConfigReportWrapper;
import com.atlassian.jira.migration.export.core.portalpage.SharePermissionWrapper;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.DashboardsMissingProjectSelectionCheckKt;
import com.atlassian.jira.migration.preflight.DashboardsMissingProjectSelectionService;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.csv.DashboardsMissingProjectSelectionCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0012H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "dashboardsMissingProjectSelectionService", "Lcom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionService;", "dashboardsExtractionHelper", "Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;", "(Lcom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionService;Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "getMissingProjectKeyToGadgetsSet", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "getMissingProjectKeyToSharePermissionSet", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDashboardsMissingProjectSelectionCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DashboardsMissingProjectSelectionCheck.kt\ncom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionCheck\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n125#2:131\n152#2,2:132\n154#2:142\n125#2:143\n152#2,2:144\n154#2:158\n1549#3:134\n1620#3,3:135\n1549#3:138\n1620#3,3:139\n1549#3:146\n1620#3,3:147\n1549#3:150\n1620#3,3:151\n1549#3:154\n1620#3,3:155\n1045#3:159\n*S KotlinDebug\n*F\n+ 1 DashboardsMissingProjectSelectionCheck.kt\ncom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionCheck\n*L\n86#1:131\n86#1:132,2\n86#1:142\n96#1:143\n96#1:144,2\n96#1:158\n90#1:134\n90#1:135,3\n91#1:138\n91#1:139,3\n100#1:146\n100#1:147,3\n101#1:150\n101#1:151,3\n104#1:154\n104#1:155,3\n110#1:159\n*E\n"})
public final class DashboardsMissingProjectSelectionCheck
extends NotBlockingCheck {
    @NotNull
    private final DashboardsMissingProjectSelectionService dashboardsMissingProjectSelectionService;
    @NotNull
    private final DashboardsExtractionHelper dashboardsExtractionHelper;
    @NotNull
    private final CheckType checkType;

    @Inject
    public DashboardsMissingProjectSelectionCheck(@NotNull DashboardsMissingProjectSelectionService dashboardsMissingProjectSelectionService, @NotNull DashboardsExtractionHelper dashboardsExtractionHelper) {
        Intrinsics.checkNotNullParameter((Object)dashboardsMissingProjectSelectionService, (String)"dashboardsMissingProjectSelectionService");
        Intrinsics.checkNotNullParameter((Object)dashboardsExtractionHelper, (String)"dashboardsExtractionHelper");
        super("We couldn't check for projects related to dashboards", "Checking for projects related to dashboards", "All projects related to dashboards have been selected", "Not all projects related to dashboards have been selected");
        this.dashboardsMissingProjectSelectionService = dashboardsMissingProjectSelectionService;
        this.dashboardsExtractionHelper = dashboardsExtractionHelper;
        this.checkType = CheckType.DashboardsMissingProjectSelection;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.dashboardsMissingProjectSelectionService.performCheck(checkRequest);
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"crossProjectConfig", (Object)ctx.getCrossProjectConfig()), TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            super.inject(dto, checkResult);
            dto.setNumberOfOccurrences(Integer.valueOf(0));
            CheckResult checkResult2 = checkResult;
            if (checkResult2 == null) break block2;
            CheckResult it = checkResult2;
            boolean bl = false;
            Object object = this.getMissingProjectKeyToGadgetsSet(it);
            Map projectKeyToGadgetsMissing = object instanceof Map ? (Map)object : null;
            Object object2 = this.getMissingProjectKeyToSharePermissionSet(it);
            Map projectKeyToSharePermissions = object2 instanceof Map ? (Map)object2 : null;
            CheckDetailsDto details2 = new CheckDetailsDto();
            Map map = projectKeyToGadgetsMissing;
            if (map != null) {
                Map $this$inject_u24lambda_u242_u24lambda_u240 = map;
                boolean bl2 = false;
                details2.setListOfOccurrences(CollectionsKt.listOf((Object)$this$inject_u24lambda_u242_u24lambda_u240));
                dto.setDetails(details2);
                dto.setNumberOfOccurrences(Integer.valueOf($this$inject_u24lambda_u242_u24lambda_u240.size()));
            }
            Map map2 = projectKeyToSharePermissions;
            if (map2 != null) {
                Map $this$inject_u24lambda_u242_u24lambda_u241 = map2;
                boolean bl3 = false;
                List list = details2.getListOfOccurrences();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getListOfOccurrences(...)");
                details2.setListOfOccurrences(CollectionsKt.plus((Collection)list, (Iterable)CollectionsKt.listOf((Object)$this$inject_u24lambda_u242_u24lambda_u241)));
                dto.setDetails(details2);
                dto.setNumberOfOccurrences(Integer.valueOf(dto.getNumberOfOccurrences() + $this$inject_u24lambda_u242_u24lambda_u241.size()));
            }
        }
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        String string = planName;
        if (string == null) {
            string = executionId;
        }
        String migrationName = string;
        return migrationName + "_Pre-migration_checks_Dashboards_Missing projects_Jira_" + dateTime + ".csv";
    }

    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        SharePermissionWrapper wrapper;
        Object object;
        Serializable x;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        String string;
        String string2;
        Map.Entry it;
        Collection collection;
        Map.Entry item$iv$iv;
        Map $this$mapTo$iv$iv2;
        Map projectKeyToSharePermissionId;
        Pair[] pairArray;
        Map map;
        Map projectKeyToGadgetIds;
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        Object object3 = this.getMissingProjectKeyToGadgetsSet(checkStatus.checkResult);
        Map map2 = object3 instanceof Map ? (Map)object3 : null;
        if (map2 == null) {
            map2 = projectKeyToGadgetIds = MapsKt.emptyMap();
        }
        if ((map = (pairArray = this.getMissingProjectKeyToSharePermissionSet(checkStatus.checkResult)) instanceof Map ? (Map)pairArray : null) == null) {
            map = projectKeyToSharePermissionId = MapsKt.emptyMap();
        }
        if (projectKeyToGadgetIds.isEmpty() && projectKeyToSharePermissionId.isEmpty()) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)DashboardsMissingProjectSelectionCheckKt.getGADGETS_MISSING_PROJECT_SELECTION_CHECK_CSV_HEADERS()));
        }
        Map $this$map$iv2 = projectKeyToGadgetIds;
        boolean $i$f$map2 = false;
        Map map3 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl = false;
            Iterable iterable = (Iterable)it.getValue();
            string2 = "Gadget";
            string = (String)it.getKey();
            $i$f$map = false;
            void var18_20 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                PortletConfigReportWrapper portletConfigReportWrapper = (PortletConfigReportWrapper)item$iv$iv2;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                object2.add(((PortletConfigReportWrapper)x).getPortalPageId());
            }
            object2 = (List)destination$iv$iv;
            $this$map$iv = (Iterable)it.getValue();
            object2 = CollectionsKt.toSet((Iterable)((Iterable)object2)).toString();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                x = (PortletConfigReportWrapper)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(this.dashboardsExtractionHelper.getPortalPageName(String.valueOf(((PortletConfigReportWrapper)((Object)wrapper)).getPortalPageId())));
            }
            object = (List)destination$iv$iv;
            String string3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)((Iterable)it.getValue())), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String string4 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)((Iterable)object)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Object object4 = object2;
            String string5 = string2;
            String string6 = string;
            collection.add(new DashboardsMissingProjectSelectionCSVData(string6, string5, (String)object4, string4, string3));
        }
        $this$map$iv2 = projectKeyToSharePermissionId;
        collection = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        $i$f$mapTo2 = false;
        iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<String> collection2;
            it = item$iv$iv = iterator2.next();
            Collection collection3 = destination$iv$iv2;
            boolean bl = false;
            $this$map$iv = (Iterable)it.getValue();
            string2 = "SharePermission";
            string = (String)it.getKey();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                wrapper = (SharePermissionWrapper)item$iv$iv2;
                object2 = destination$iv$iv;
                boolean bl4 = false;
                object2.add(((SharePermissionWrapper)x).getPortalPageId());
            }
            object2 = (List)destination$iv$iv;
            $this$map$iv = (Iterable)it.getValue();
            object2 = CollectionsKt.toSet((Iterable)((Iterable)object2)).toString();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                x = (SharePermissionWrapper)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl5 = false;
                object.add(this.dashboardsExtractionHelper.getPortalPageName(String.valueOf(wrapper.getPortalPageId())));
            }
            object = (List)destination$iv$iv;
            $this$map$iv = (Iterable)it.getValue();
            object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)((Iterable)object)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                wrapper = (SharePermissionWrapper)item$iv$iv2;
                collection2 = destination$iv$iv;
                boolean bl6 = false;
                collection2.add("sharepermission-" + ((SharePermissionWrapper)x).getSharePermissionId());
            }
            collection2 = (List)destination$iv$iv;
            String string7 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)collection2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Object object5 = object;
            Object object6 = object2;
            String string8 = string2;
            String string9 = string;
            collection3.add(new DashboardsMissingProjectSelectionCSVData(string9, string8, (String)object6, (String)object5, string7));
        }
        List beans = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
        pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"headers", (Object)DashboardsMissingProjectSelectionCheckKt.getGADGETS_MISSING_PROJECT_SELECTION_CHECK_CSV_HEADERS());
        String[] $i$f$map22 = new String[]{"projectKey", "entity", "dashboardIds", "dashboardNames", "entityNameAndIds"};
        pairArray[1] = TuplesKt.to((Object)"mappings", (Object)$i$f$map22);
        Iterable $this$sortedBy$iv = beans;
        boolean $i$f$sortedBy = false;
        pairArray[2] = TuplesKt.to((Object)"beans", (Object)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DashboardsMissingProjectSelectionCSVData it = (DashboardsMissingProjectSelectionCSVData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getProjectKey());
                it = (DashboardsMissingProjectSelectionCSVData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getProjectKey())));
            }
        }));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Object getMissingProjectKeyToGadgetsSet(CheckResult checkResult) {
        Object object = checkResult;
        return object != null && (object = ((CheckResult)object).details) != null ? object.get("missingProjectKeysToGadgetsSelection") : null;
    }

    private final Object getMissingProjectKeyToSharePermissionSet(CheckResult checkResult) {
        Object object = checkResult;
        return object != null && (object = ((CheckResult)object).details) != null ? object.get("missingProjectKeysToSharePermissionsSelection") : null;
    }
}

