/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.export.core.portalpage.DashboardProjectSharePermissions;
import com.atlassian.jira.migration.export.core.portalpage.DashboardsExtractionHelper;
import com.atlassian.jira.migration.export.core.portalpage.PortletConfigReportWrapper;
import com.atlassian.jira.migration.export.core.portalpage.SharePermissionWrapper;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.preflight.DashboardPreflightMetaData;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.ProjectKeysMapping;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.jira.migration.preflight.utils.PreflightUtils;
import com.atlassian.jira.migration.validation.PlanValidation;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J$\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J \u0010\u001a\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J(\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00100\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0010H\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&2\u0006\u0010'\u001a\u00020\u0013H\u0002J(\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010-\u001a\u00020)2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionService;", "", "planValidation", "Lcom/atlassian/jira/migration/validation/PlanValidation;", "crossProjectEntityStatsEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "dashboardsExtractionHelper", "Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;", "(Lcom/atlassian/jira/migration/validation/PlanValidation;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;)V", "extractDashboardPreflightMetaData", "Lcom/atlassian/jira/migration/preflight/DashboardPreflightMetaData;", "dashboardsMigrationMode", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "selectedProjectKeys", "", "", "extractProjectKeysFromGadgetsAndSharePemissions", "Lcom/atlassian/jira/migration/preflight/ProjectKeysMapping;", "dashboardPreflightMetaData", "filterMissingProjectKeysMapping", "referencedProjectKeysMapping", "isMissing", "Lkotlin/Function1;", "", "getDashboardPreflightMetaData", "getReferencedProjectKeysFromDashboards", "", "Lcom/atlassian/jira/migration/export/core/portalpage/PortletConfigReportWrapper;", "portalPageIds", "", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "retrieveCheckResult", "projectKeysNotSelectedForMigration", "", "missingProjectKeysMapping", "sendDashboardsMissingProjectSelectionCheckStatsEvent", "", "preflightCheckExecutionId", "timeTakenToComplete", "success", "validateDashboardsMigrationMode", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDashboardsMissingProjectSelectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DashboardsMissingProjectSelectionService.kt\ncom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionService\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,171:1\n17#2,6:172\n478#3,7:178\n478#3,7:185\n*S KotlinDebug\n*F\n+ 1 DashboardsMissingProjectSelectionService.kt\ncom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionService\n*L\n35#1:172,6\n84#1:178,7\n85#1:185,7\n*E\n"})
public final class DashboardsMissingProjectSelectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanValidation planValidation;
    @NotNull
    private final CrossProjectEntityStatsEventService crossProjectEntityStatsEventService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final DashboardsExtractionHelper dashboardsExtractionHelper;
    private static final Logger log = LoggerFactory.getLogger(DashboardsMissingProjectSelectionService.class);
    @NotNull
    public static final String UNSUPPORTED_MIGRATION_MODE_EXCEPTION_MESSAGE = "Unsupported migration mode for dashboards";
    @NotNull
    public static final String MISSING_PROJECT_KEYS_TO_GADGETS_SELECTION = "missingProjectKeysToGadgetsSelection";
    @NotNull
    public static final String MISSING_PROJECT_KEYS_TO_SHARE_PERMISSIONS_SELECTION = "missingProjectKeysToSharePermissionsSelection";

    @Inject
    public DashboardsMissingProjectSelectionService(@NotNull PlanValidation planValidation, @NotNull CrossProjectEntityStatsEventService crossProjectEntityStatsEventService, @NotNull MigrationFeatures migrationFeatures, @NotNull DashboardsExtractionHelper dashboardsExtractionHelper) {
        Intrinsics.checkNotNullParameter((Object)planValidation, (String)"planValidation");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityStatsEventService, (String)"crossProjectEntityStatsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)dashboardsExtractionHelper, (String)"dashboardsExtractionHelper");
        this.planValidation = planValidation;
        this.crossProjectEntityStatsEventService = crossProjectEntityStatsEventService;
        this.migrationFeatures = migrationFeatures;
        this.dashboardsExtractionHelper = dashboardsExtractionHelper;
    }

    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        NotBlockingCheckResult checkResult = null;
        checkResult = new NotBlockingCheckResult(true);
        List<String> selectedProjectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
        log.debug("Project keys selected: {}", selectedProjectKeys);
        DashboardsMigrationMode dashboardsMigrationMode = this.dashboardsExtractionHelper.getDashboardsMigrationMode(PreflightCheckKt.getCrossProjectConfig(checkRequest));
        log.debug("Dashboards Migration Mode selected: {}", (Object)String.valueOf((Object)dashboardsMigrationMode));
        this.validateDashboardsMigrationMode(dashboardsMigrationMode);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        DashboardPreflightMetaData dashboardPreflightMetaData = this.extractDashboardPreflightMetaData(dashboardsMigrationMode, selectedProjectKeys);
        ProjectKeysMapping referencedProjectKeysMapping = this.extractProjectKeysFromGadgetsAndSharePemissions(dashboardPreflightMetaData);
        Set<String> validProjectKeySelections = PreflightUtils.Companion.getValidProjectKeysSelections(selectedProjectKeys, this.planValidation);
        log.debug("Valid project key selections: {}", validProjectKeySelections);
        Set<String> projectKeysNotSelectedForMigration = PreflightUtils.Companion.getProjectKeysNotSelectedForMigration(referencedProjectKeysMapping.getAllKeys(), validProjectKeySelections);
        ProjectKeysMapping missingProjectKeysMapping2 = this.filterMissingProjectKeysMapping(referencedProjectKeysMapping, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(projectKeysNotSelectedForMigration){
            final /* synthetic */ Set<String> $projectKeysNotSelectedForMigration;
            {
                this.$projectKeysNotSelectedForMigration = $projectKeysNotSelectedForMigration;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$projectKeysNotSelectedForMigration.contains(it);
            }
        }));
        checkResult = this.retrieveCheckResult(projectKeysNotSelectedForMigration, missingProjectKeysMapping2);
        long elapsedTime2 = System.currentTimeMillis() - start$iv;
        log.debug(checkRequest.checkType + " took " + elapsedTime2 + " ms to finish");
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        boolean bl2 = !checkResult.getHasWarnings();
        DashboardsMigrationMode dashboardsMigrationMode2 = dashboardsMigrationMode;
        Intrinsics.checkNotNull((Object)((Object)dashboardsMigrationMode2));
        this.sendDashboardsMissingProjectSelectionCheckStatsEvent(string, elapsedTime2, bl2, dashboardsMigrationMode2);
        return checkResult;
    }

    private final NotBlockingCheckResult retrieveCheckResult(Set<String> projectKeysNotSelectedForMigration, ProjectKeysMapping missingProjectKeysMapping2) {
        NotBlockingCheckResult notBlockingCheckResult;
        if (projectKeysNotSelectedForMigration.isEmpty()) {
            log.info("All referenced project keys are selected for migration");
            notBlockingCheckResult = new NotBlockingCheckResult(true);
        } else {
            log.info("Project keys: " + projectKeysNotSelectedForMigration + " are not selected for migration");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MISSING_PROJECT_KEYS_TO_GADGETS_SELECTION, missingProjectKeysMapping2.getProjectKeyToGadgets()), TuplesKt.to((Object)MISSING_PROJECT_KEYS_TO_SHARE_PERMISSIONS_SELECTION, missingProjectKeysMapping2.getProjectKeyToSharePermissions())};
            NotBlockingCheckResult notBlockingCheckResult2 = new NotBlockingCheckResult(false, MapsKt.mapOf((Pair[])pairArray));
            notBlockingCheckResult = notBlockingCheckResult2;
        }
        return notBlockingCheckResult;
    }

    private final ProjectKeysMapping filterMissingProjectKeysMapping(ProjectKeysMapping referencedProjectKeysMapping, Function1<? super String, Boolean> isMissing) {
        boolean bl;
        String it;
        Map<String, List<Serializable>> $this$filterKeys$iv = referencedProjectKeysMapping.getProjectKeyToSharePermissions();
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, List<Serializable>> result$iv = new LinkedHashMap<String, List<Serializable>>();
        for (Map.Entry<String, List<SharePermissionWrapper>> entry : $this$filterKeys$iv.entrySet()) {
            it = entry.getKey();
            bl = false;
            if (!((Boolean)isMissing.invoke((Object)it)).booleanValue()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterKeys$iv = referencedProjectKeysMapping.getProjectKeyToGadgets();
        Map map = result$iv;
        $i$f$filterKeys = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry<String, List<Serializable>> entry : $this$filterKeys$iv.entrySet()) {
            it = entry.getKey();
            bl = false;
            if (!((Boolean)isMissing.invoke((Object)it)).booleanValue()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map map2 = result$iv;
        Map map3 = map;
        return new ProjectKeysMapping(map3, map2);
    }

    private final ProjectKeysMapping extractProjectKeysFromGadgetsAndSharePemissions(DashboardPreflightMetaData dashboardPreflightMetaData) {
        Map<String, List<PortletConfigReportWrapper>> projectKeyToGadgets = this.getReferencedProjectKeysFromDashboards(dashboardPreflightMetaData.getPortalPageIds());
        Set referencedProjectKeys = SetsKt.plus(projectKeyToGadgets.keySet(), (Iterable)dashboardPreflightMetaData.getProjectKeyToSharePermissions().keySet());
        log.debug("Project keys referenced in gadgets and sharePermissions: {}", (Object)referencedProjectKeys);
        return new ProjectKeysMapping(dashboardPreflightMetaData.getProjectKeyToSharePermissions(), projectKeyToGadgets);
    }

    private final DashboardPreflightMetaData getDashboardPreflightMetaData(DashboardsMigrationMode dashboardsMigrationMode, List<String> selectedProjectKeys) {
        DashboardProjectSharePermissions dashboardProjectSharePermissions = this.dashboardsExtractionHelper.mapDashboardsProjectSharepermissions(this.dashboardsExtractionHelper.getPortalPagesForMigrationMode(dashboardsMigrationMode, selectedProjectKeys));
        List<Long> portalPageIds = dashboardProjectSharePermissions.component1();
        Map<String, List<SharePermissionWrapper>> referredProjectSharePermissions = dashboardProjectSharePermissions.component2();
        return new DashboardPreflightMetaData(portalPageIds, referredProjectSharePermissions);
    }

    private final Map<String, List<PortletConfigReportWrapper>> getReferencedProjectKeysFromDashboards(List<Long> portalPageIds) {
        Map<String, List<PortletConfigReportWrapper>> projectKeyToGadgets = this.dashboardsExtractionHelper.mapDashboardsProjectPortletConfigurations(portalPageIds).component2();
        return projectKeyToGadgets;
    }

    private final void sendDashboardsMissingProjectSelectionCheckStatsEvent(String preflightCheckExecutionId, long timeTakenToComplete, boolean success, DashboardsMigrationMode dashboardsMigrationMode) {
        this.crossProjectEntityStatsEventService.sendDashboardsMissingProjectSelectionCheckStatsEvent(preflightCheckExecutionId, timeTakenToComplete, success, dashboardsMigrationMode);
    }

    private final void validateDashboardsMigrationMode(DashboardsMigrationMode dashboardsMigrationMode) {
        if (!(dashboardsMigrationMode == DashboardsMigrationMode.ALL || dashboardsMigrationMode == DashboardsMigrationMode.SELECTED_PROJECTS)) {
            boolean bl = false;
            String string = UNSUPPORTED_MIGRATION_MODE_EXCEPTION_MESSAGE;
            throw new IllegalStateException(string.toString());
        }
    }

    private final DashboardPreflightMetaData extractDashboardPreflightMetaData(DashboardsMigrationMode dashboardsMigrationMode, List<String> selectedProjectKeys) {
        boolean shouldFetchMetaData = dashboardsMigrationMode == DashboardsMigrationMode.ALL || dashboardsMigrationMode == DashboardsMigrationMode.SELECTED_PROJECTS && this.migrationFeatures.getEnableScopedDashboardsFeature();
        return shouldFetchMetaData ? this.getDashboardPreflightMetaData(dashboardsMigrationMode, selectedProjectKeys) : new DashboardPreflightMetaData(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/preflight/DashboardsMissingProjectSelectionService$Companion;", "", "()V", "MISSING_PROJECT_KEYS_TO_GADGETS_SELECTION", "", "MISSING_PROJECT_KEYS_TO_SHARE_PERMISSIONS_SELECTION", "UNSUPPORTED_MIGRATION_MODE_EXCEPTION_MESSAGE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

