/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.events.DatabaseSizeCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.size.ExportSizeService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiracloudservice.JiraCloudClient;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.migration.api.ContainerToken;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0011H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/preflight/DatabaseSizeCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "exportSizeService", "Lcom/atlassian/jira/migration/export/size/ExportSizeService;", "jiraCloudClient", "Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/export/size/ExportSizeService;Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "determineCheckResultFromEstimate", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "onSkippableShard", "", "shard", "", "performCheck", "checkRequest", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseSizeCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSizeCheck.kt\ncom/atlassian/jira/migration/preflight/DatabaseSizeCheck\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,128:1\n17#2,6:129\n*S KotlinDebug\n*F\n+ 1 DatabaseSizeCheck.kt\ncom/atlassian/jira/migration/preflight/DatabaseSizeCheck\n*L\n47#1:129,6\n*E\n"})
public final class DatabaseSizeCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportSizeService exportSizeService;
    @NotNull
    private final JiraCloudClient jiraCloudClient;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final CheckType checkType;
    @NotNull
    public static final String ESTIMATED_SIZE_BYTES = "estimatedSizeInBytes";
    @NotNull
    public static final String CHECK_FAILED_TO_RUN_MESSAGE = "The size of your data may cause migration failure";
    @NotNull
    public static final String CHECK_RUNNING_MESSAGE = "We're checking the size of your data";
    @NotNull
    public static final String CHECK_SUCCESSFUL_MESSAGE = "The size of your data is within migration limits";
    @NotNull
    public static final String MC_SHARD_MATCHER = "jira-prod-.*-mc.*";
    @NotNull
    private static final String IMPORT_SHARD_MATCHER = "jira-.*-import.*";

    @Inject
    public DatabaseSizeCheck(@NotNull ExportSizeService exportSizeService, @NotNull JiraCloudClient jiraCloudClient, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)exportSizeService, (String)"exportSizeService");
        Intrinsics.checkNotNullParameter((Object)jiraCloudClient, (String)"jiraCloudClient");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.exportSizeService = exportSizeService;
        this.jiraCloudClient = jiraCloudClient;
        this.migrationFeatures = migrationFeatures;
        this.migrationEventBus = migrationEventBus;
        this.checkType = CheckType.DatabaseSize;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        String cloudId2 = PreflightCheckKt.getCloudId(checkRequest);
        CheckResult checkResult2 = null;
        Companion.SkippedStatus skippedStatus = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (this.migrationFeatures.getSkipDatabaseSizeCheck()) {
            skippedStatus = Companion.SkippedStatus.DF_ENABLED;
            checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)ESTIMATED_SIZE_BYTES, (Object)0L)));
        } else {
            String shard = this.jiraCloudClient.getTenantInformation(new ContainerToken(PreflightCheckKt.getContainerToken(checkRequest)), cloudId2).getShard();
            if (this.onSkippableShard(shard)) {
                skippedStatus = Companion.SkippedStatus.ON_SKIPPABLE_SHARD;
                checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)ESTIMATED_SIZE_BYTES, (Object)0L)));
            } else {
                skippedStatus = Companion.SkippedStatus.NOT_SKIPPED;
                checkResult = this.determineCheckResultFromEstimate();
            }
        }
        checkResult2 = checkResult;
        long timeToComplete = System.currentTimeMillis() - start$iv;
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        boolean bl2 = checkResult2.success;
        ExportStatistics exportStatistics = ExportStatistics.Companion.getEMPTY();
        Object v = checkResult2.details.get(ESTIMATED_SIZE_BYTES);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Long");
        this.migrationEventBus.post(new DatabaseSizeCheckEvent(string, string2, timeToComplete, bl2, exportStatistics, (Long)v, skippedStatus.toString()));
        return checkResult2;
    }

    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block5: {
            String string;
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    string = CHECK_RUNNING_MESSAGE;
                    break;
                }
                case 2: {
                    string = CHECK_SUCCESSFUL_MESSAGE;
                    break;
                }
                case 3: {
                    string = CHECK_FAILED_TO_RUN_MESSAGE;
                    break;
                }
                default: {
                    string = CHECK_FAILED_TO_RUN_MESSAGE;
                }
            }
            dto.setDescription(string);
            CheckResult checkResult2 = checkResult;
            if (checkResult2 == null) break block5;
            CheckResult it = checkResult2;
            boolean bl = false;
            dto.setNumberOfOccurrences(Integer.valueOf(1));
            dto.setDetails(new CheckDetailsDto());
            dto.getDetails().setInfo(checkResult.details);
        }
    }

    private final boolean onSkippableShard(String shard) {
        CharSequence charSequence = shard;
        return new Regex(MC_SHARD_MATCHER).matches(charSequence) || new Regex(IMPORT_SHARD_MATCHER).matches(charSequence = (CharSequence)shard);
    }

    private final CheckResult determineCheckResultFromEstimate() {
        long total = this.exportSizeService.getDatabaseSizeEstimateCached().getTotal();
        return total < 0x280000000L ? new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)ESTIMATED_SIZE_BYTES, (Object)total))) : new CheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)ESTIMATED_SIZE_BYTES, (Object)total)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/preflight/DatabaseSizeCheck$Companion;", "", "()V", "CHECK_FAILED_TO_RUN_MESSAGE", "", "CHECK_RUNNING_MESSAGE", "CHECK_SUCCESSFUL_MESSAGE", "ESTIMATED_SIZE_BYTES", "IMPORT_SHARD_MATCHER", "MC_SHARD_MATCHER", "SkippedStatus", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/DatabaseSizeCheck$Companion$SkippedStatus;", "", "(Ljava/lang/String;I)V", "NOT_SKIPPED", "DF_ENABLED", "ON_SKIPPABLE_SHARD", "jira-migration-plugin"})
        public static final class SkippedStatus
        extends Enum<SkippedStatus> {
            public static final /* enum */ SkippedStatus NOT_SKIPPED = new SkippedStatus();
            public static final /* enum */ SkippedStatus DF_ENABLED = new SkippedStatus();
            public static final /* enum */ SkippedStatus ON_SKIPPABLE_SHARD = new SkippedStatus();
            private static final /* synthetic */ SkippedStatus[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static SkippedStatus[] values() {
                return (SkippedStatus[])$VALUES.clone();
            }

            public static SkippedStatus valueOf(String value) {
                return Enum.valueOf(SkippedStatus.class, value);
            }

            @NotNull
            public static EnumEntries<SkippedStatus> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = skippedStatusArray = new SkippedStatus[]{SkippedStatus.NOT_SKIPPED, SkippedStatus.DF_ENABLED, SkippedStatus.ON_SKIPPABLE_SHARD};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

