/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.jira.migration.email.FixAllEmailsResult;
import com.atlassian.jira.migration.email.UserEmailFixer;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreflightCheckEvent;
import com.atlassian.jira.migration.events.SharedEmailsCheckEvent;
import com.atlassian.jira.migration.preflight.EmailCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.UnsupportedUserHandler;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/preflight/DuplicateEmailCheckService;", "Lcom/atlassian/jira/migration/preflight/EmailCheckService;", "unsupportedUserHandler", "Lcom/atlassian/jira/migration/preflight/UnsupportedUserHandler;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/preflight/UnsupportedUserHandler;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "buildEvent", "Lcom/atlassian/jira/migration/events/PreflightCheckEvent;", "preflightCheckExecutionId", "", "uniqueId", "extractionResult", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "timeToComplete", "", "getCheckResultFromFixedData", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "performCheck", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailPreflightService.kt\ncom/atlassian/jira/migration/preflight/DuplicateEmailCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,250:1\n1490#2:251\n1520#2,3:252\n1523#2,3:262\n1490#2:269\n1520#2,3:270\n1523#2,3:280\n1360#2:294\n1446#2,5:295\n372#3,7:255\n372#3,7:273\n526#3:287\n511#3,6:288\n125#4:265\n152#4,3:266\n125#4:283\n152#4,3:284\n*S KotlinDebug\n*F\n+ 1 EmailPreflightService.kt\ncom/atlassian/jira/migration/preflight/DuplicateEmailCheckService\n*L\n208#1:251\n208#1:252,3\n208#1:262,3\n218#1:269\n218#1:270,3\n218#1:280,3\n245#1:294\n245#1:295,5\n208#1:255,7\n218#1:273,7\n242#1:287\n242#1:288,6\n209#1:265\n209#1:266,3\n220#1:283\n220#1:284,3\n*E\n"})
public final class DuplicateEmailCheckService
extends EmailCheckService {
    @NotNull
    private final UnsupportedUserHandler unsupportedUserHandler;

    @Inject
    public DuplicateEmailCheckService(@NotNull UnsupportedUserHandler unsupportedUserHandler, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)unsupportedUserHandler, (String)"unsupportedUserHandler");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        super(migrationEventBus, null);
        this.unsupportedUserHandler = unsupportedUserHandler;
    }

    @Override
    @NotNull
    protected CheckResult performCheck(@NotNull CheckRequest checkRequest, @NotNull UsersGroupsExtractionResult extractionResult) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Intrinsics.checkNotNullParameter((Object)extractionResult, (String)"extractionResult");
        CheckResult checkResult = this.getCheckResultFromFixedData(checkRequest);
        return this.unsupportedUserHandler.checkDuplicateEmailsResolutionStatus(PreflightCheckKt.getPreflightCheckExecutionId(checkRequest), checkResult, PreflightCheckKt.getLoggedUser(checkRequest), checkRequest);
    }

    /*
     * WARNING - void declaration
     */
    private final CheckResult getCheckResultFromFixedData(CheckRequest checkRequest) {
        CheckResult checkResult;
        FixAllEmailsResult fixedResult = PreflightCheckKt.getUsersFixedData(checkRequest).getFixAllEmailsResult();
        boolean bl = false;
        List<JiraUser> duplicateEmails = fixedResult.getDuplicate();
        if (!((Collection)duplicateEmails).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Object list$iv$iv;
            JiraUser it;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = duplicateEmails;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                void it2;
                Object object2;
                it = (JiraUser)t;
                boolean $i$a$-groupBy-DuplicateEmailCheckService$getCheckResultFromFixedData$1$violations$332 = false;
                String key$iv$iv = UserEmailFixer.Companion.sanitizeDuplicatedEmailForMerge(it.getEmail());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                JiraUser $i$a$-groupBy-DuplicateEmailCheckService$getCheckResultFromFixedData$1$violations$332 = (JiraUser)t;
                object = list$iv$iv;
                boolean bl3 = false;
                object.add(it2.getUserName());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                list$iv$iv = entry;
                object = destination$iv$iv;
                boolean bl4 = false;
                object.add(new EmailDuplicate((String)it.getKey(), (List)it.getValue()));
            }
            List violations = (List)destination$iv$iv;
            checkResult = new CheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"violations", (Object)violations)));
        } else if (!((Collection)fixedResult.getDuplicateEmailsBeforeFix()).isEmpty()) {
            void $this$map$iv;
            Object object;
            Object list$iv$iv;
            JiraUser it;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = fixedResult.getDuplicateEmailsBeforeFix();
            boolean $i$f$groupBy = false;
            Iterable $this$mapTo$iv$iv = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                void it3;
                Object object3;
                it = (JiraUser)t;
                boolean $i$a$-groupBy-DuplicateEmailCheckService$getCheckResultFromFixedData$1$violations$632 = false;
                String key$iv$iv = UserEmailFixer.Companion.sanitizeDuplicatedEmailForMerge(it.getEmail());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                JiraUser $i$a$-groupBy-DuplicateEmailCheckService$getCheckResultFromFixedData$1$violations$632 = (JiraUser)t;
                object = list$iv$iv;
                boolean bl6 = false;
                object.add(it3.getUserName());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                list$iv$iv = entry;
                object = destination$iv$iv;
                boolean bl7 = false;
                object.add(new EmailDuplicate((String)it.getKey(), (List)it.getValue()));
            }
            List violations = (List)destination$iv$iv;
            checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"violations", (Object)violations)));
        } else {
            checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"violations", (Object)CollectionsKt.emptyList())));
        }
        return checkResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PreflightCheckEvent buildEvent(@NotNull String preflightCheckExecutionId, @NotNull String uniqueId, @NotNull UsersGroupsExtractionResult extractionResult, @NotNull CheckResult checkResult, long timeToComplete) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        EmailDuplicate it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)extractionResult, (String)"extractionResult");
        Intrinsics.checkNotNullParameter((Object)checkResult, (String)"checkResult");
        List duplicateEmails = EmailDuplicateChecker.retrieveEmailDuplicates((Map)checkResult.details);
        boolean bl = checkResult.success;
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        Map map2 = map;
        boolean bl2 = bl;
        long l = timeToComplete;
        String string = uniqueId;
        String string2 = preflightCheckExecutionId;
        boolean $i$f$filter = false;
        void var10_13 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            EmailDuplicate element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            if (!(!Intrinsics.areEqual(it.getKey(), (Object)"violations"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map3 = destination$iv$iv;
        ExportStatistics exportStatistics = extractionResult.getExportStatistics();
        int n = duplicateEmails.size();
        Intrinsics.checkNotNull((Object)duplicateEmails);
        $this$filter$iv = duplicateEmails;
        int n2 = n;
        ExportStatistics exportStatistics2 = exportStatistics;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (EmailDuplicate element$iv$iv : $this$flatMapTo$iv$iv) {
            it = element$iv$iv;
            boolean bl4 = false;
            List list = it.ids;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ids");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        boolean bl5 = true;
        int n3 = list.size();
        int n4 = n2;
        ExportStatistics exportStatistics3 = exportStatistics2;
        Map map4 = map3;
        boolean bl6 = bl2;
        long l2 = l;
        String string3 = string;
        String string4 = string2;
        return new SharedEmailsCheckEvent(string4, string3, l2, bl6, map4, exportStatistics3, n4, n3, bl5);
    }
}

