/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.jira.migration.common.DomainId;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailAliasesHandler;", "", "()V", "buildCheckResultDetails", "", "", "userExceedingAliasLimits", "", "Lcom/atlassian/jira/migration/preflight/EmailAliasesHandler$UserExceedingAliasLimit;", "checkEmailAliases", "Lcom/atlassian/cmpt/check/base/CheckResult;", "usersAndGroups", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "checkResult", "generateCsvString", "invalidEmailData", "Companion", "UserExceedingAliasLimit", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailAliasesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailAliasesHandler.kt\ncom/atlassian/jira/migration/preflight/EmailAliasesHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n372#2,7:77\n526#2:84\n511#2,6:85\n1549#3:91\n1620#3,3:92\n1855#3,2:95\n*S KotlinDebug\n*F\n+ 1 EmailAliasesHandler.kt\ncom/atlassian/jira/migration/preflight/EmailAliasesHandler\n*L\n29#1:77,7\n36#1:84\n36#1:85,6\n48#1:91\n48#1:92,3\n56#1:95,2\n*E\n"})
public final class EmailAliasesHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int EMAIL_ALIAS_LIMIT = 10;
    @NotNull
    public static final String INFO_ERROR_REASON = "info_errorReason";
    @NotNull
    public static final String INFO_USERS_EXCEEDING_EMAIL_ALIAS_LIMIT_CSV = "info_usersExceedingEmailAliasLimitCsv";
    @NotNull
    public static final String ALIAS_VIOLATION_ERROR = "ALIAS_LIMIT_VIOLATION";
    @NotNull
    private static final String[] CSV_HEADER;
    @NotNull
    private static final List<String> ALIASED_DOMAINS;
    private static final Logger log;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult checkEmailAliases(@NotNull UsersGroupsExtractionResult usersAndGroups, @NotNull CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)usersAndGroups, (String)"usersAndGroups");
        Intrinsics.checkNotNullParameter((Object)checkResult, (String)"checkResult");
        if (checkResult.success) {
            void $this$filterTo$iv$iv;
            HashMap baseWithEmailData = new HashMap();
            for (JiraUser user : usersAndGroups.getUsers()) {
                Unit unit;
                String email = user.getEmail();
                int plusIndex = StringsKt.indexOf$default((CharSequence)email, (char)'+', (int)0, (boolean)false, (int)6, null);
                if (plusIndex == -1) continue;
                if (DomainId.Companion.fromEmail(email) != null) {
                    DomainId it;
                    boolean bl = false;
                    String domain = it.getStandardizedDomain();
                    if (ALIASED_DOMAINS.contains(domain)) {
                        Object object;
                        void $this$getOrPut$iv;
                        String string = email.substring(0, plusIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String string2 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        String base = IdentityAcceptedEmailValidator.cleanse((String)string2);
                        Map map = baseWithEmailData;
                        Intrinsics.checkNotNull((Object)base);
                        String key$iv = base;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(new UserExceedingAliasLimit(user.getUserName(), user.getEmail(), base + '@' + domain));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) continue;
                log.warn("Could not extract domain from email for user with key: {}", (Object)user.getUserKey());
            }
            Map $this$filter$iv = baseWithEmailData;
            boolean $i$f$filter = false;
            Map plusIndex = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(((List)it.getValue()).size() + 1 > 10)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map filteredMap = destination$iv$iv;
            if (!filteredMap.isEmpty()) {
                return new CheckResult(false, this.buildCheckResultDetails(CollectionsKt.flatten((Iterable)filteredMap.values())));
            }
        }
        return checkResult;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> buildCheckResultDetails(List<UserExceedingAliasLimit> userExceedingAliasLimits) {
        Collection<EmailData> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)INFO_ERROR_REASON, (Object)ALIAS_VIOLATION_ERROR);
        pairArray[1] = TuplesKt.to((Object)INFO_USERS_EXCEEDING_EMAIL_ALIAS_LIMIT_CSV, (Object)this.generateCsvString(userExceedingAliasLimits));
        Iterable iterable = userExceedingAliasLimits;
        String string = "violations";
        int n = 2;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserExceedingAliasLimit userExceedingAliasLimit = (UserExceedingAliasLimit)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EmailData(it.getUsername(), it.getEmail()));
        }
        collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String generateCsvString(List<UserExceedingAliasLimit> invalidEmailData) {
        String string;
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter stringWriter = (StringWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new CsvListWriter((Writer)stringWriter, CsvPreference.STANDARD_PREFERENCE);
            Throwable throwable2 = null;
            try {
                CsvListWriter it = (CsvListWriter)closeable2;
                boolean bl2 = false;
                String[] stringArray = CSV_HEADER;
                it.writeHeader(Arrays.copyOf(stringArray, stringArray.length));
                Iterable $this$forEach$iv = invalidEmailData;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UserExceedingAliasLimit emailData = (UserExceedingAliasLimit)element$iv;
                    boolean bl3 = false;
                    Object[] objectArray = new String[]{emailData.getUsername(), emailData.getEmail(), emailData.getPrimaryEmail()};
                    it.write(CollectionsKt.listOf((Object[])objectArray));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String string2 = stringWriter.toString();
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    static {
        Object[] objectArray = new String[]{"Username", "Email", "Primary Email"};
        CSV_HEADER = objectArray;
        objectArray = new String[]{"gmail.com", "protonmail.com", "yandex.ru", "hotmail.com", "outlook.com"};
        ALIASED_DOMAINS = CollectionsKt.listOf((Object[])objectArray);
        log = LoggerFactory.getLogger(EmailAliasesHandler.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailAliasesHandler$Companion;", "", "()V", "ALIASED_DOMAINS", "", "", "ALIAS_VIOLATION_ERROR", "CSV_HEADER", "", "[Ljava/lang/String;", "EMAIL_ALIAS_LIMIT", "", "INFO_ERROR_REASON", "INFO_USERS_EXCEEDING_EMAIL_ALIAS_LIMIT_CSV", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailAliasesHandler$UserExceedingAliasLimit;", "", "username", "", "email", "primaryEmail", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEmail", "()Ljava/lang/String;", "getPrimaryEmail", "getUsername", "jira-migration-plugin"})
    private static final class UserExceedingAliasLimit {
        @NotNull
        private final String username;
        @NotNull
        private final String email;
        @NotNull
        private final String primaryEmail;

        public UserExceedingAliasLimit(@NotNull String username, @NotNull String email, @NotNull String primaryEmail) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Intrinsics.checkNotNullParameter((Object)primaryEmail, (String)"primaryEmail");
            this.username = username;
            this.email = email;
            this.primaryEmail = primaryEmail;
        }

        @NotNull
        public final String getUsername() {
            return this.username;
        }

        @NotNull
        public final String getEmail() {
            return this.email;
        }

        @NotNull
        public final String getPrimaryEmail() {
            return this.primaryEmail;
        }
    }
}

