/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.email.DomainScanService;
import com.atlassian.jira.migration.email.EmailTrustedDomainService;
import com.atlassian.jira.migration.email.model.BlockedDomainLookupMethod;
import com.atlassian.jira.migration.email.model.DomainScan;
import com.atlassian.jira.migration.email.model.UserEmailDomain;
import com.atlassian.jira.migration.events.DomainScanFailedEvent;
import com.atlassian.jira.migration.events.DomainScanFinishedEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.UsersGroupsAndCustomerService;
import com.atlassian.jira.migration.preflight.model.DomainScanStatus;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.utils.CompletableFutureUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.udc.common.model.context.Context;
import com.atlassian.migration.udc.common.model.email.DomainId;
import com.atlassian.migration.udc.invalidemail.BlockedDomainUmsService;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0007\u0018\u0000 I2\u00020\u0001:\u0001IB_\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'J*\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020$0\u001eJ\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0-2\u0006\u0010%\u001a\u00020$H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0002J\b\u00100\u001a\u000201H\u0007J\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0016J&\u00105\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J7\u0010;\u001a\u0002012\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u0002092\u0006\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u0010AJ\u0016\u0010B\u001a\u0002012\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'J\u0018\u0010C\u001a\n E*\u0004\u0018\u00010D0D2\u0006\u0010F\u001a\u00020\u001aH\u0002J$\u0010G\u001a\u0002012\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService;", "Lcom/atlassian/scheduler/JobRunner;", "usersGroupsAndCustomerService", "Lcom/atlassian/jira/migration/preflight/UsersGroupsAndCustomerService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "emailTrustedDomainService", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;", "blockedDomainUmsService", "Lcom/atlassian/migration/udc/invalidemail/BlockedDomainUmsService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "domainScanService", "Lcom/atlassian/jira/migration/email/DomainScanService;", "(Lcom/atlassian/jira/migration/preflight/UsersGroupsAndCustomerService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;Lcom/atlassian/migration/udc/invalidemail/BlockedDomainUmsService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/email/DomainScanService;)V", "domainScanStatus", "Lcom/atlassian/jira/migration/preflight/model/DomainScanStatus;", "getDomainScanStatus", "()Lcom/atlassian/jira/migration/preflight/model/DomainScanStatus;", "buildDomainToUserCountMap", "", "Lcom/atlassian/jira/migration/email/model/UserEmailDomain;", "usersExtractionResult", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "getBlockedDomainsForCloudId", "", "", "cloudId", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "getDomainsWithUserCount", "usersAndGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "projectKeys", "getTokenAndMigrationScopeIdFor", "Lkotlin/Pair;", "performScan", "Lcom/atlassian/scheduler/JobRunnerResponse;", "register", "", "runJob", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "saveAnalytics", "start", "", "distinctDomainsCount", "", "blockedDomains", "sendFinishedAnalyticsEvent", "blockedDomainsCount", "executionTime", "lookupMethod", "Lcom/atlassian/jira/migration/email/model/BlockedDomainLookupMethod;", "firstScanDistinctDomains", "(IIJLcom/atlassian/jira/migration/email/model/BlockedDomainLookupMethod;Ljava/lang/Long;)V", "startDomainScanSafely", "updateDomainScanStatus", "", "kotlin.jvm.PlatformType", "status", "updateEmailTrustedDomainRepository", "domainsWithUserCount", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailBlockedDomainUmsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailBlockedDomainUmsService.kt\ncom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n1549#3:253\n1620#3,3:254\n1549#3:257\n1620#3,3:258\n766#3:261\n857#3,2:262\n766#3:264\n857#3,2:265\n1855#3,2:267\n*S KotlinDebug\n*F\n+ 1 EmailBlockedDomainUmsService.kt\ncom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService\n*L\n89#1:253\n89#1:254,3\n90#1:257\n90#1:258,3\n173#1:261\n173#1:262,2\n174#1:264\n174#1:265,2\n195#1:267,2\n*E\n"})
public final class EmailBlockedDomainUmsService
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsersGroupsAndCustomerService usersGroupsAndCustomerService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final EmailTrustedDomainService emailTrustedDomainService;
    @NotNull
    private final BlockedDomainUmsService blockedDomainUmsService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final PluginSettingsFactory pluginSettingsFactory;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final DomainScanService domainScanService;
    @NotNull
    private static final String LOGGED_IN_USER_ID = "loggedInUserId";
    @NotNull
    private static final String CLOUD_ID = "cloudId";
    @NotNull
    public static final String DOMAIN_SCAN_LOCK = "jcma.migration.trusted.domains.scan";
    @NotNull
    public static final String DOMAIN_SCAN_STATUS = "com.atlassian.jira.migration.jira-migration-plugin:domainScanStatus";
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    private static final Logger log;

    @Inject
    public EmailBlockedDomainUmsService(@NotNull UsersGroupsAndCustomerService usersGroupsAndCustomerService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationScopeManager migrationScopeManager, @NotNull EmailTrustedDomainService emailTrustedDomainService, @NotNull BlockedDomainUmsService blockedDomainUmsService, @NotNull MigrationEventBus migrationEventBus, @NotNull ClusterLockService clusterLockService, @NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull SchedulerService schedulerService, @NotNull UserManager userManager, @NotNull DomainScanService domainScanService) {
        Intrinsics.checkNotNullParameter((Object)usersGroupsAndCustomerService, (String)"usersGroupsAndCustomerService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)emailTrustedDomainService, (String)"emailTrustedDomainService");
        Intrinsics.checkNotNullParameter((Object)blockedDomainUmsService, (String)"blockedDomainUmsService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)domainScanService, (String)"domainScanService");
        this.usersGroupsAndCustomerService = usersGroupsAndCustomerService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationScopeManager = migrationScopeManager;
        this.emailTrustedDomainService = emailTrustedDomainService;
        this.blockedDomainUmsService = blockedDomainUmsService;
        this.migrationEventBus = migrationEventBus;
        this.clusterLockService = clusterLockService;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.schedulerService = schedulerService;
        this.userManager = userManager;
        this.domainScanService = domainScanService;
    }

    @NotNull
    public final DomainScanStatus getDomainScanStatus() {
        Object object;
        block3: {
            block2: {
                object = this.pluginSettingsFactory.createGlobalSettings().get(DOMAIN_SCAN_STATUS);
                if (object == null) break block2;
                Object it = object;
                boolean bl = false;
                DomainScanStatus domainScanStatus = DomainScanStatus.valueOf((String)it);
                object = domainScanStatus;
                if (domainScanStatus != null) break block3;
            }
            object = DomainScanStatus.NOT_STARTED;
        }
        return object;
    }

    @PostConstruct
    public final void register() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
    }

    @NotNull
    public final Set<String> getBlockedDomainsForCloudId(@NotNull String cloudId2, @NotNull ApplicationUser loggedInUser) {
        DomainId it;
        Collection<DomainId> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)CLOUD_ID);
        Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
        long start = System.currentTimeMillis();
        List<UserEmailDomain> domainsWithUserCount = this.getDomainsWithUserCount(loggedInUser, UsersGroupsMigrationOption.Companion.getALL_EXCEPT_MEMBERSHIPS(), CollectionsKt.emptyList());
        int distinctDomainsCount = domainsWithUserCount.size();
        Pair<String, String> pair = this.getTokenAndMigrationScopeIdFor(cloudId2);
        String containerToken = (String)pair.component1();
        String migrationScopeId2 = (String)pair.component2();
        Iterable iterable = domainsWithUserCount;
        Context context = (Context)new Context.CloudContext(containerToken, migrationScopeId2);
        Object object = this.blockedDomainUmsService;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UserEmailDomain userEmailDomain = (UserEmailDomain)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DomainId(it.getDomainName()));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = object.getBlockedDomainsFromUms(context, CollectionsKt.toSet((Iterable)collection));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DomainId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getStandardizedDomain());
        }
        Set blockedDomains = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.updateEmailTrustedDomainRepository(domainsWithUserCount, blockedDomains);
        this.saveAnalytics(start, distinctDomainsCount, blockedDomains);
        return blockedDomains;
    }

    private final void saveAnalytics(long start, int distinctDomainsCount, Set<String> blockedDomains) {
        long finishedTime = System.currentTimeMillis();
        BlockedDomainLookupMethod blockedDomainsLookupMethod = BlockedDomainLookupMethod.UMS;
        long executionTime = finishedTime - start;
        DomainScan firstScan = this.domainScanService.getFirstScan();
        long l = distinctDomainsCount;
        long l2 = blockedDomains.size();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.domainScanService.insertDomainsScan(new DomainScan(blockedDomainsLookupMethod, start, finishedTime, DomainScanStatus.FINISHED, executionTime, l, l2, string));
        DomainScan domainScan = firstScan;
        this.sendFinishedAnalyticsEvent(distinctDomainsCount, blockedDomains.size(), executionTime, blockedDomainsLookupMethod, domainScan != null ? Long.valueOf(domainScan.getDistinctDomainsCount()) : null);
    }

    @NotNull
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object v = request.getJobConfig().getParameters().get(CLOUD_ID);
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        String cloudId2 = (String)v;
        Serializable loggedInUserId = (Serializable)request.getJobConfig().getParameters().get(LOGGED_IN_USER_ID);
        Intrinsics.checkNotNull((Object)loggedInUserId, (String)"null cannot be cast to non-null type kotlin.Long");
        Optional applicationUserOptional = this.userManager.getUserById((Long)loggedInUserId);
        if (!applicationUserOptional.isPresent()) {
            log.error("Could not find user with id " + loggedInUserId);
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.aborted((String)("Could not find user with id " + loggedInUserId));
            Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse, (String)"aborted(...)");
            return jobRunnerResponse;
        }
        Object t = applicationUserOptional.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        ApplicationUser applicationUser = (ApplicationUser)t;
        log.debug("Attempting to start domain scan triggered by " + applicationUser.getKey());
        return this.performScan(cloudId2, applicationUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JobRunnerResponse performScan(String cloudId2, ApplicationUser loggedInUser) {
        JobRunnerResponse jobRunnerResponse;
        ClusterLock lock = this.clusterLockService.getLockForName(DOMAIN_SCAN_LOCK);
        if (lock.tryLock()) {
            JobRunnerResponse jobRunnerResponse2;
            try {
                this.updateDomainScanStatus(DomainScanStatus.IN_PROGRESS);
                this.getBlockedDomainsForCloudId(cloudId2, loggedInUser);
                this.updateDomainScanStatus(DomainScanStatus.FINISHED);
                jobRunnerResponse2 = JobRunnerResponse.success();
            }
            catch (Exception ex) {
                log.error("Exception during domain scan with cluster lock", (Throwable)ex);
                this.updateDomainScanStatus(DomainScanStatus.FAILED);
                this.migrationEventBus.post(new DomainScanFailedEvent());
                jobRunnerResponse2 = JobRunnerResponse.failed((Throwable)ex);
            }
            finally {
                lock.unlock();
            }
            JobRunnerResponse jobRunnerResponse3 = jobRunnerResponse2;
            Intrinsics.checkNotNull((Object)jobRunnerResponse3);
            jobRunnerResponse = jobRunnerResponse3;
        } else {
            log.debug("Could not acquire lock jcma.migration.trusted.domains.scan");
            JobRunnerResponse jobRunnerResponse4 = JobRunnerResponse.aborted((String)"could not acquire lock jcma.migration.trusted.domains.scan");
            Intrinsics.checkNotNull((Object)jobRunnerResponse4);
            jobRunnerResponse = jobRunnerResponse4;
        }
        return jobRunnerResponse;
    }

    public final void startDomainScanSafely(@NotNull String cloudId2, @NotNull ApplicationUser loggedInUser) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)CLOUD_ID);
        Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
        this.updateDomainScanStatus(DomainScanStatus.IN_PROGRESS);
        try {
            JobId jobId = JobId.of((String)"runDomainScan");
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY);
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)CLOUD_ID, (Object)cloudId2);
            Long l = loggedInUser.getId();
            Intrinsics.checkNotNull((Object)l);
            pairArray[1] = TuplesKt.to((Object)LOGGED_IN_USER_ID, (Object)l);
            this.schedulerService.scheduleJob(jobId, jobConfig.withParameters(MapsKt.mapOf((Pair[])pairArray)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null)));
        }
        catch (SchedulerServiceException e) {
            this.updateDomainScanStatus(DomainScanStatus.FAILED);
            throw e;
        }
    }

    private final void updateEmailTrustedDomainRepository(List<UserEmailDomain> domainsWithUserCount, Set<String> blockedDomains) {
        UserEmailDomain it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        this.emailTrustedDomainService.batchDeleteStaleDomains(domainsWithUserCount);
        Iterable iterable = domainsWithUserCount;
        EmailTrustedDomainService emailTrustedDomainService = this.emailTrustedDomainService;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UserEmailDomain)element$iv$iv;
            boolean bl = false;
            if (!blockedDomains.contains(it.getDomainName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        emailTrustedDomainService.batchUpsertBlockedDomains((List)destination$iv$iv);
        $this$filter$iv = domainsWithUserCount;
        emailTrustedDomainService = this.emailTrustedDomainService;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UserEmailDomain)element$iv$iv;
            boolean bl = false;
            if (!(!blockedDomains.contains(it.getDomainName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        emailTrustedDomainService.batchUpsertNonBlockedDomains((List)destination$iv$iv);
    }

    @NotNull
    public final List<UserEmailDomain> getDomainsWithUserCount(@NotNull ApplicationUser loggedInUser, @NotNull UsersGroupsMigrationOption usersAndGroupsMigrationOption, @NotNull List<String> projectKeys) {
        Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
        Intrinsics.checkNotNullParameter((Object)usersAndGroupsMigrationOption, (String)"usersAndGroupsMigrationOption");
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String executionId = string;
        CompletableFuture usersAndGroupsFuture = (CompletableFuture)UsersGroupsAndCustomerService.getUsersGroupsAndCustomers$default(this.usersGroupsAndCustomerService, usersAndGroupsMigrationOption, executionId, loggedInUser, projectKeys, ProjectDataMigrationMode.ALL, MigrationType.CLASSIC, CollectionsKt.emptyList(), null, null, null, null, 1792, null).component1();
        UsersGroupsExtractionResult usersAndGroupsResult = (UsersGroupsExtractionResult)CompletableFutureUtil.INSTANCE.getCompletedValue((Future)usersAndGroupsFuture);
        Intrinsics.checkNotNull((Object)usersAndGroupsResult);
        return this.buildDomainToUserCountMap(usersAndGroupsResult);
    }

    private final List<UserEmailDomain> buildDomainToUserCountMap(UsersGroupsExtractionResult usersExtractionResult) {
        HashMap domainsWithUserCount = new HashMap();
        Iterable $this$forEach$iv = usersExtractionResult.getUsers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserEmailDomain userEmailDomain;
            JiraUser user = (JiraUser)element$iv;
            boolean bl = false;
            DomainId domain = DomainId.Companion.fromEmail(user.getEmail());
            if (domain == null || !IdentityAcceptedEmailValidator.isValidEmailAddress((String)domain.generateRandomEmail())) continue;
            if (!((Map)domainsWithUserCount).containsKey(domain)) {
                ((Map)domainsWithUserCount).put(domain, new UserEmailDomain(domain.getStandardizedDomain(), 0, 0));
            }
            if (user.getActive()) {
                Object v = domainsWithUserCount.get(domain);
                Intrinsics.checkNotNull(v);
                userEmailDomain = (UserEmailDomain)v;
                userEmailDomain.setActiveUsers(userEmailDomain.getActiveUsers() + 1);
                continue;
            }
            Object v = domainsWithUserCount.get(domain);
            Intrinsics.checkNotNull(v);
            userEmailDomain = (UserEmailDomain)v;
            userEmailDomain.setInactiveUsers(userEmailDomain.getInactiveUsers() + 1);
        }
        Collection collection = domainsWithUserCount.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private final Pair<String, String> getTokenAndMigrationScopeIdFor(String cloudId2) {
        CloudSite cloudSite2;
        CloudSite cloudSite3 = cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        String containerToken = cloudSite3 != null ? cloudSite3.getContainerToken() : null;
        if (containerToken == null) {
            boolean $i$a$-requireNotNull-EmailBlockedDomainUmsService$getTokenAndMigrationScopeIdFor$22 = false;
            String $i$a$-requireNotNull-EmailBlockedDomainUmsService$getTokenAndMigrationScopeIdFor$22 = "Container token is required to get invalid emails using UMS";
            throw new IllegalArgumentException($i$a$-requireNotNull-EmailBlockedDomainUmsService$getTokenAndMigrationScopeIdFor$22.toString());
        }
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite2);
        return new Pair((Object)containerToken, (Object)migrationScopeId2);
    }

    private final Object updateDomainScanStatus(DomainScanStatus status) {
        return this.pluginSettingsFactory.createGlobalSettings().put(DOMAIN_SCAN_STATUS, (Object)status.toString());
    }

    private final void sendFinishedAnalyticsEvent(int distinctDomainsCount, int blockedDomainsCount, long executionTime, BlockedDomainLookupMethod lookupMethod, Long firstScanDistinctDomains) {
        Integer n;
        Integer n2;
        int it;
        Integer domainsRemovedComparedToFirstScan;
        Integer n3;
        Long l = firstScanDistinctDomains;
        if (l != null) {
            long it2 = ((Number)l).longValue();
            boolean bl = false;
            n3 = (int)it2 - distinctDomainsCount;
        } else {
            n3 = null;
        }
        Integer n4 = domainsRemovedComparedToFirstScan = n3;
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl = false;
            n2 = it < 0 ? Math.abs(it) : 0;
        } else {
            n2 = null;
        }
        Integer domainsAddedComparedToFirstScan = n2;
        MigrationEventBus migrationEventBus = this.migrationEventBus;
        int n5 = distinctDomainsCount;
        int n6 = blockedDomainsCount;
        String string = lookupMethod.name();
        long l2 = executionTime;
        Integer n7 = domainsAddedComparedToFirstScan;
        Integer n8 = domainsRemovedComparedToFirstScan;
        if (n8 != null) {
            it = ((Number)n8).intValue();
            Integer n9 = n7;
            long l3 = l2;
            String string2 = string;
            int n10 = n6;
            int n11 = n5;
            MigrationEventBus migrationEventBus2 = migrationEventBus;
            boolean bl = false;
            Integer n12 = it < 0 ? 0 : it;
            migrationEventBus = migrationEventBus2;
            n5 = n11;
            n6 = n10;
            string = string2;
            l2 = l3;
            n7 = n9;
            n = n12;
        } else {
            n = null;
        }
        Integer n13 = n;
        Integer n14 = n7;
        long l4 = l2;
        String string3 = string;
        int n15 = n6;
        int n16 = n5;
        migrationEventBus.post(new DomainScanFinishedEvent(n16, n15, string3, l4, n14, n13));
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)Companion.toString());
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        log = LoggerFactory.getLogger(EmailBlockedDomainUmsService.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService$Companion;", "", "()V", "CLOUD_ID", "", "DOMAIN_SCAN_LOCK", "getDOMAIN_SCAN_LOCK$annotations", "DOMAIN_SCAN_STATUS", "getDOMAIN_SCAN_STATUS$annotations", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "LOGGED_IN_USER_ID", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getDOMAIN_SCAN_LOCK$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getDOMAIN_SCAN_STATUS$annotations() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

