/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckContext;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreflightCheckEvent;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH$J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailCheckService;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "buildEvent", "Lcom/atlassian/jira/migration/events/PreflightCheckEvent;", "preflightCheckExecutionId", "", "uniqueId", "extractionResult", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "timeToComplete", "", "performCheck", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "runCheck", "Companion", "Lcom/atlassian/jira/migration/preflight/DuplicateEmailCheckService;", "Lcom/atlassian/jira/migration/preflight/EmailFormatCheckService;", "jira-migration-plugin"})
public abstract class EmailCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private static final Set<String> INCLUDED_DETAILS_KEYS;

    private EmailCheckService(MigrationEventBus migrationEventBus) {
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final CheckResult runCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        UsersGroupsExtractionResult extractionResult = PreflightCheckKt.getUsersAndGroups(checkRequest);
        CheckResult it = checkResult = this.performCheck(checkRequest, extractionResult);
        boolean bl = false;
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(this.buildEvent(string, string2, extractionResult, it, (endTime - startTime) / (long)1000000));
        return checkResult;
    }

    @NotNull
    protected abstract CheckResult performCheck(@NotNull CheckRequest var1, @NotNull UsersGroupsExtractionResult var2);

    @NotNull
    protected abstract PreflightCheckEvent buildEvent(@NotNull String var1, @NotNull String var2, @NotNull UsersGroupsExtractionResult var3, @NotNull CheckResult var4, long var5);

    public /* synthetic */ EmailCheckService(MigrationEventBus migrationEventBus, DefaultConstructorMarker $constructor_marker) {
        this(migrationEventBus);
    }

    static {
        Object[] objectArray = new String[]{"info_errorReason", "configOption", "udcMode", "tombstonedInvalidUsers", "numberOfTombstonedUsers", "mergeDuplicatedUsers", "numberOfMergedUsers"};
        INCLUDED_DETAILS_KEYS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailCheckService$Companion;", "", "()V", "INCLUDED_DETAILS_KEYS", "", "", "getINCLUDED_DETAILS_KEYS", "()Ljava/util/Set;", "performSimplifiedMainCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checker", "Lcom/atlassian/cmpt/check/base/Checker;", "Lcom/atlassian/cmpt/check/email/EmailCheckContext;", "jiraUserList", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nEmailPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailPreflightService.kt\ncom/atlassian/jira/migration/preflight/EmailCheckService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1549#2:251\n1620#2,3:252\n*S KotlinDebug\n*F\n+ 1 EmailPreflightService.kt\ncom/atlassian/jira/migration/preflight/EmailCheckService$Companion\n*L\n44#1:251\n44#1:252,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getINCLUDED_DETAILS_KEYS() {
            return INCLUDED_DETAILS_KEYS;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CheckResult performSimplifiedMainCheck(@NotNull Checker<EmailCheckContext> checker, @NotNull List<JiraUser> jiraUserList) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(checker, (String)"checker");
            Intrinsics.checkNotNullParameter(jiraUserList, (String)"jiraUserList");
            Iterable $this$map$iv = jiraUserList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void jiraUser;
                JiraUser jiraUser2 = (JiraUser)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EmailData(jiraUser.getUserName(), jiraUser.getEmail()));
            }
            List list = (List)destination$iv$iv;
            EmailCheckContext context = new EmailCheckContext(list);
            CheckResult checkResult = checker.check((CheckContext)context);
            Intrinsics.checkNotNullExpressionValue((Object)checkResult, (String)"check(...)");
            return checkResult;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

