/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.jira.migration.email.FixAllEmailsResult;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.InvalidEmailsCheckEvent;
import com.atlassian.jira.migration.events.InvalidUserLastUpdatedStatus;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreflightCheckEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.EmailAliasesHandler;
import com.atlassian.jira.migration.preflight.EmailCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.UnsupportedUserHandler;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraDirectoryService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.utils.EmailValidityCheckerUtil;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailFormatCheckService;", "Lcom/atlassian/jira/migration/preflight/EmailCheckService;", "unsupportedUserHandler", "Lcom/atlassian/jira/migration/preflight/UnsupportedUserHandler;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "jiraDirectoryService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/UnsupportedUserHandler;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraDirectoryService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "buildEvent", "Lcom/atlassian/jira/migration/events/PreflightCheckEvent;", "preflightCheckExecutionId", "", "uniqueId", "extractionResult", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "timeToComplete", "", "getCheckResultFromFixedData", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "getInvalidUserLastUpdatedStatus", "Lcom/atlassian/jira/migration/events/InvalidUserLastUpdatedStatus;", "performCheck", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailPreflightService.kt\ncom/atlassian/jira/migration/preflight/EmailFormatCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,250:1\n1549#2:251\n1620#2,3:252\n1549#2:255\n1620#2,3:256\n1549#2:266\n1620#2,3:267\n1855#2,2:270\n526#3:259\n511#3,6:260\n*S KotlinDebug\n*F\n+ 1 EmailPreflightService.kt\ncom/atlassian/jira/migration/preflight/EmailFormatCheckService\n*L\n114#1:251\n114#1:252,3\n118#1:255\n118#1:256,3\n149#1:266\n149#1:267,3\n161#1:270,2\n137#1:259\n137#1:260,6\n*E\n"})
public final class EmailFormatCheckService
extends EmailCheckService {
    @NotNull
    private final UnsupportedUserHandler unsupportedUserHandler;
    @NotNull
    private final JiraDirectoryService jiraDirectoryService;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public EmailFormatCheckService(@NotNull UnsupportedUserHandler unsupportedUserHandler, @NotNull MigrationEventBus migrationEventBus, @NotNull JiraDirectoryService jiraDirectoryService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)unsupportedUserHandler, (String)"unsupportedUserHandler");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)jiraDirectoryService, (String)"jiraDirectoryService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super(migrationEventBus, null);
        this.unsupportedUserHandler = unsupportedUserHandler;
        this.jiraDirectoryService = jiraDirectoryService;
        this.migrationFeatures = migrationFeatures;
    }

    @Override
    @NotNull
    protected CheckResult performCheck(@NotNull CheckRequest checkRequest, @NotNull UsersGroupsExtractionResult extractionResult) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Intrinsics.checkNotNullParameter((Object)extractionResult, (String)"extractionResult");
        CheckResult checkResult = this.getCheckResultFromFixedData(checkRequest);
        checkResult = this.unsupportedUserHandler.checkInvalidEmailsResolutionStatus(PreflightCheckKt.getPreflightCheckExecutionId(checkRequest), checkResult, PreflightCheckKt.getLoggedUser(checkRequest), checkRequest);
        return this.migrationFeatures.getDisableEmailAliasesValidation() ? checkResult : new EmailAliasesHandler().checkEmailAliases(extractionResult, checkResult);
    }

    /*
     * WARNING - void declaration
     */
    private final CheckResult getCheckResultFromFixedData(CheckRequest checkRequest) {
        CheckResult checkResult;
        FixAllEmailsResult fixedResult = PreflightCheckKt.getUsersFixedData(checkRequest).getFixAllEmailsResult();
        boolean bl = false;
        List<JiraUser> invalidEmails = fixedResult.getInvalid();
        if (!((Collection)invalidEmails).isEmpty()) {
            Collection<EmailData> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = invalidEmails;
            String string = "violations";
            boolean bl2 = false;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JiraUser jiraUser = (JiraUser)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new EmailData(it.getUserName(), it.getEmail()));
            }
            collection = (List)destination$iv$iv;
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)collection));
            boolean bl4 = bl2;
            checkResult = new CheckResult(bl4, map);
        } else if (!((Collection)fixedResult.getInvalidEmailsBeforeFix()).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = fixedResult.getInvalidEmailsBeforeFix();
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JiraUser bl3 = (JiraUser)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(new EmailData(it.getUserName(), it.getEmail()));
            }
            List violations = (List)destination$iv$iv2;
            checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"violations", (Object)violations)));
        } else {
            checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"violations", (Object)CollectionsKt.emptyList())));
        }
        return checkResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PreflightCheckEvent buildEvent(@NotNull String preflightCheckExecutionId, @NotNull String uniqueId, @NotNull UsersGroupsExtractionResult extractionResult, @NotNull CheckResult checkResult, long timeToComplete) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)extractionResult, (String)"extractionResult");
        Intrinsics.checkNotNullParameter((Object)checkResult, (String)"checkResult");
        boolean bl = checkResult.success;
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        Map map2 = map;
        boolean bl2 = bl;
        long l = timeToComplete;
        String string = uniqueId;
        String string2 = preflightCheckExecutionId;
        boolean $i$f$filter = false;
        void var9_12 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            if (!EmailCheckService.Companion.getINCLUDED_DETAILS_KEYS().contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map3 = destination$iv$iv;
        ExportStatistics exportStatistics = extractionResult.getExportStatistics();
        int n = extractionResult.getUsers().size();
        Map map4 = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"details");
        InvalidUserLastUpdatedStatus invalidUserLastUpdatedStatus = this.getInvalidUserLastUpdatedStatus(checkResult, this.jiraDirectoryService);
        int n2 = EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map4).size();
        int n3 = n;
        ExportStatistics exportStatistics2 = exportStatistics;
        Map map5 = map3;
        boolean bl4 = bl2;
        long l2 = l;
        String string3 = string;
        String string4 = string2;
        return new InvalidEmailsCheckEvent(string4, string3, l2, bl4, map5, exportStatistics2, n3, n2, invalidUserLastUpdatedStatus);
    }

    /*
     * WARNING - void declaration
     */
    private final InvalidUserLastUpdatedStatus getInvalidUserLastUpdatedStatus(CheckResult checkResult, JiraDirectoryService jiraDirectoryService) {
        Pair[] $this$mapTo$iv$iv;
        List<JiraDirectoryService.JiraUserDetailsQueryResult> invalidUsers = CollectionsKt.emptyList();
        if (checkResult.details.containsKey("violations")) {
            void $this$map$iv;
            Object v = checkResult.details.get("violations");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<com.atlassian.cmpt.check.email.EmailData>");
            List invalidEmailDataList = (List)v;
            Iterable iterable = invalidEmailDataList;
            JiraDirectoryService jiraDirectoryService2 = jiraDirectoryService;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                EmailData emailData = (EmailData)t;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.email);
            }
            invalidUsers = jiraDirectoryService2.fetchJiraUserDetails(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        }
        int lastUpdatedDateNotPresentForInvalidUser = 0;
        LocalDateTime now = LocalDateTime.now();
        $this$mapTo$iv$iv = new Pair[]{TuplesKt.to((Object)7L, (Object)0), TuplesKt.to((Object)30L, (Object)0), TuplesKt.to((Object)90L, (Object)0), TuplesKt.to((Object)365L, (Object)0)};
        SortedMap daysToCountMap = MapsKt.sortedMapOf((Pair[])$this$mapTo$iv$iv);
        Iterable $this$forEach$iv = invalidUsers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Long l;
            Object v5;
            block5: {
                Timestamp updatedDate;
                JiraDirectoryService.JiraUserDetailsQueryResult jiraUserDetailsQueryResult = (JiraDirectoryService.JiraUserDetailsQueryResult)element$iv;
                boolean bl = false;
                JiraDirectoryService.JiraUserDetailsQueryResult jiraUserDetailsQueryResult2 = jiraUserDetailsQueryResult;
                Timestamp timestamp = updatedDate = jiraUserDetailsQueryResult2 != null ? jiraUserDetailsQueryResult2.getUpdatedDate() : null;
                if (updatedDate == null) {
                    ++lastUpdatedDateNotPresentForInvalidUser;
                    continue;
                }
                Set set = daysToCountMap.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Iterable iterable = set;
                for (Object t : iterable) {
                    Long it = (Long)t;
                    boolean bl2 = false;
                    long l2 = updatedDate.getTime();
                    Intrinsics.checkNotNull((Object)it);
                    if (!(l2 > now.minusDays(it).toInstant(ZoneOffset.UTC).toEpochMilli())) continue;
                    v5 = t;
                    break block5;
                }
                v5 = null;
            }
            if ((l = (Long)v5) == null) continue;
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long l3 = it;
            Map map = daysToCountMap;
            Object v = daysToCountMap.get(it);
            Intrinsics.checkNotNull(v);
            map.put(l3, ((Number)v).intValue() + 1);
        }
        Object v = daysToCountMap.get(7L);
        Intrinsics.checkNotNull(v);
        int n = ((Number)v).intValue();
        Object v2 = daysToCountMap.get(30L);
        Intrinsics.checkNotNull(v2);
        int n2 = ((Number)v2).intValue();
        Object v3 = daysToCountMap.get(90L);
        Intrinsics.checkNotNull(v3);
        int n3 = ((Number)v3).intValue();
        Object v4 = daysToCountMap.get(365L);
        Intrinsics.checkNotNull(v4);
        return new InvalidUserLastUpdatedStatus(n, n2, n3, ((Number)v4).intValue(), lastUpdatedDateNotPresentForInvalidUser);
    }
}

