/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.email.EmailTrustedDomainService;
import com.atlassian.jira.migration.email.model.EmailTrustedDomain;
import com.atlassian.jira.migration.email.model.UserEmailDomain;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.EmailBlockedDomainUmsService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\rH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailTrustedDomainsCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "emailTrustedDomainService", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;", "emailBlockedDomainUmsService", "Lcom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService;", "(Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;Lcom/atlassian/jira/migration/preflight/EmailBlockedDomainUmsService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getUserDomains", "", "Lcom/atlassian/jira/migration/email/model/UserEmailDomain;", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEmailTrustedDomainsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailTrustedDomainsCheck.kt\ncom/atlassian/jira/migration/preflight/EmailTrustedDomainsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n1549#2:118\n1620#2,3:119\n1549#2:122\n1620#2,3:123\n819#2:126\n847#2,2:127\n819#2:129\n847#2,2:130\n*S KotlinDebug\n*F\n+ 1 EmailTrustedDomainsCheck.kt\ncom/atlassian/jira/migration/preflight/EmailTrustedDomainsCheck\n*L\n46#1:114\n46#1:115,3\n49#1:118\n49#1:119,3\n53#1:122\n53#1:123,3\n54#1:126\n54#1:127,2\n55#1:129\n55#1:130,2\n*E\n"})
public final class EmailTrustedDomainsCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmailTrustedDomainService emailTrustedDomainService;
    @NotNull
    private final EmailBlockedDomainUmsService emailBlockedDomainUmsService;
    @NotNull
    private final CheckType checkType;
    @NotNull
    public static final String UNTRUSTED_DOMAINS = "UNTRUSTED_DOMAINS";
    @NotNull
    public static final String CHECK_FAILED_TO_RUN_MESSAGE = "We couldn't check if you've trusted all email domains";
    @NotNull
    public static final String CHECK_RUNNING_MESSAGE = "Checking if you've trusted all email domains";
    @NotNull
    public static final String ALL_DOMAINS_TRUSTED = "You trust all your email domains";
    @NotNull
    public static final String UNTRUSTED_DOMAINS_FOUND = "You haven't reviewed all your domains";
    private static final Logger log = LoggerFactory.getLogger(EmailTrustedDomainsCheck.class);

    @Inject
    public EmailTrustedDomainsCheck(@NotNull EmailTrustedDomainService emailTrustedDomainService, @NotNull EmailBlockedDomainUmsService emailBlockedDomainUmsService) {
        Intrinsics.checkNotNullParameter((Object)emailTrustedDomainService, (String)"emailTrustedDomainService");
        Intrinsics.checkNotNullParameter((Object)emailBlockedDomainUmsService, (String)"emailBlockedDomainUmsService");
        this.emailTrustedDomainService = emailTrustedDomainService;
        this.emailBlockedDomainUmsService = emailBlockedDomainUmsService;
        this.checkType = CheckType.TrustedDomains;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"loggedUser", (Object)ctx.getLoggedUser()), TuplesKt.to((Object)"usersGroupsMigrationOption", (Object)ctx.getUsersGroupsMigrationOption()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Iterable $this$map$iv3 = this.emailTrustedDomainService.getTrustedDomains();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            Iterator iterator2 = (EmailTrustedDomain)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getDomainName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        List trustedDomains = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.emailTrustedDomainService.getPersistedBlockedDomains();
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            EmailTrustedDomain bl = (EmailTrustedDomain)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.getDomainName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        List blockedDomains = (List)destination$iv$iv2;
        Iterable $i$f$map32 = this.getUserDomains(PreflightCheckKt.getLoggedUser(checkRequest));
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void domain;
            UserEmailDomain bl2 = (UserEmailDomain)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(domain.getDomainName());
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String emailDomain = (String)element$iv$iv;
            boolean bl = false;
            String string = emailDomain.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (trustedDomains.contains(string)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String emailDomain = (String)element$iv$iv;
            boolean bl = false;
            String string = emailDomain.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (blockedDomains.contains(string)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List untrustedDomains = (List)destination$iv$iv3;
        if (untrustedDomains.isEmpty()) {
            checkResult = new CheckResult(true);
        } else {
            log.info("Untrusted domains found: " + untrustedDomains);
            this.emailBlockedDomainUmsService.startDomainScanSafely(PreflightCheckKt.getCloudId(checkRequest), PreflightCheckKt.getLoggedUser(checkRequest));
            checkResult = new CheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)UNTRUSTED_DOMAINS, (Object)untrustedDomains)));
        }
        return checkResult;
    }

    private final List<UserEmailDomain> getUserDomains(ApplicationUser loggedInUser) {
        return this.emailBlockedDomainUmsService.getDomainsWithUserCount(loggedInUser, UsersGroupsMigrationOption.Companion.getALL_EXCEPT_MEMBERSHIPS(), CollectionsKt.emptyList());
    }

    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block6: {
            String string;
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    string = CHECK_RUNNING_MESSAGE;
                    break;
                }
                case 2: {
                    string = ALL_DOMAINS_TRUSTED;
                    break;
                }
                case 3: {
                    string = UNTRUSTED_DOMAINS_FOUND;
                    break;
                }
                default: {
                    string = CHECK_FAILED_TO_RUN_MESSAGE;
                }
            }
            dto.setDescription(string);
            CheckResult checkResult2 = checkResult;
            if (checkResult2 == null) break block6;
            CheckResult it = checkResult2;
            boolean bl = false;
            Map map = it.details;
            Object object = map != null ? map.get(UNTRUSTED_DOMAINS) : null;
            List list = object instanceof List ? (List)object : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List untrustedDomains = list;
            dto.setNumberOfOccurrences(Integer.valueOf(untrustedDomains.size()));
            dto.setDetails(new CheckDetailsDto());
            dto.getDetails().setListOfOccurrences(CollectionsKt.take((Iterable)untrustedDomains, (int)20));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/preflight/EmailTrustedDomainsCheck$Companion;", "", "()V", "ALL_DOMAINS_TRUSTED", "", "CHECK_FAILED_TO_RUN_MESSAGE", "CHECK_RUNNING_MESSAGE", "UNTRUSTED_DOMAINS", "UNTRUSTED_DOMAINS_FOUND", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

