/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.EpicLinksAboveStoryHierarchyLevelCheckKt;
import com.atlassian.jira.migration.preflight.EpicLinksAboveStoryHierarchyLevelResult;
import com.atlassian.jira.migration.preflight.EpicLinksAboveStoryHierarchyLevelService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.csv.EpicLinksAboveStoryHierarchyLevelCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "epicLinksAboveStoryHierarchyLevelService", "Lcom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelService;", "(Lcom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEpicLinksAboveStoryHierarchyLevelCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpicLinksAboveStoryHierarchyLevelCheck.kt\ncom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1549#2:127\n1620#2,3:128\n*S KotlinDebug\n*F\n+ 1 EpicLinksAboveStoryHierarchyLevelCheck.kt\ncom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelCheck\n*L\n85#1:127\n85#1:128,3\n*E\n"})
public final class EpicLinksAboveStoryHierarchyLevelCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final EpicLinksAboveStoryHierarchyLevelService epicLinksAboveStoryHierarchyLevelService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public EpicLinksAboveStoryHierarchyLevelCheck(@NotNull EpicLinksAboveStoryHierarchyLevelService epicLinksAboveStoryHierarchyLevelService) {
        Intrinsics.checkNotNullParameter((Object)epicLinksAboveStoryHierarchyLevelService, (String)"epicLinksAboveStoryHierarchyLevelService");
        this.epicLinksAboveStoryHierarchyLevelService = epicLinksAboveStoryHierarchyLevelService;
        this.checkType = CheckType.EpicLinksAboveStoryHierarchyLevel;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.epicLinksAboveStoryHierarchyLevelService.performCheck(checkRequest);
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        dto.setNumberOfOccurrences(Integer.valueOf(0));
        dto.setDetails(new CheckDetailsDto());
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                dto.setDescription("We are checking epic links found on issues at and above the epic hierarchy level");
                break;
            }
            case 2: {
                dto.setStatus(Status.EXECUTION_ERROR);
                dto.setDescription("We couldn't check for epic links on issues at and above the epic hierarchy");
                break;
            }
            default: {
                if (checkResult == null) {
                    dto.setStatus(Status.RUNNING);
                    dto.setDescription("We are checking epic links found on issues at and above the epic hierarchy level");
                    break;
                }
                if (checkResult.details.isEmpty()) {
                    dto.setStatus(Status.SUCCESS);
                    dto.setDescription("No epic links found on issues at and above the epic hierarchy level");
                    break;
                }
                dto.setStatus(Status.WARNING);
                dto.setDescription("Epic links found on issues at and above the epic hierarchy level");
            }
        }
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        String string = planName;
        if (string == null) {
            string = executionId;
        }
        String migrationName = string;
        return migrationName + "_Pre-migration_checks_Epic_Links_above_story_level_Jira_" + dateTime + "_result.csv";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        List list;
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        if (checkStatus.checkResult == null || checkStatus.checkResult.details.isEmpty()) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)EpicLinksAboveStoryHierarchyLevelCheckKt.getEPIC_LINKS_ABOVE_STORY_HIERARCHY_LEVEL_HEADERS()));
        }
        Object v = checkStatus.checkResult.details.get("epicLinksAboveStoryHierarchyLevel");
        List problemIssuesAndTheirEpic = v instanceof List ? (List)v : null;
        Pair[] pairArray = (Pair[])problemIssuesAndTheirEpic;
        if (pairArray == null || pairArray.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = problemIssuesAndTheirEpic;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EpicLinksAboveStoryHierarchyLevelResult epicLinksAboveStoryHierarchyLevelResult = (EpicLinksAboveStoryHierarchyLevelResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EpicLinksAboveStoryHierarchyLevelCSVData(it.getIssueKey(), String.valueOf(it.getIssueId()), it.getEpicKey(), String.valueOf(it.getEpicId())));
            }
            list = (List)destination$iv$iv;
        }
        List beans = list;
        pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"headers", (Object)EpicLinksAboveStoryHierarchyLevelCheckKt.getEPIC_LINKS_ABOVE_STORY_HIERARCHY_LEVEL_HEADERS());
        String[] stringArray = new String[]{"issueKey", "issueId", "epicKey", "epicId"};
        pairArray[1] = TuplesKt.to((Object)"mappings", (Object)stringArray);
        pairArray[2] = TuplesKt.to((Object)"beans", (Object)beans);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

