/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.export.advancedroadmaps.ArHierarchyConfigDataService;
import com.atlassian.jira.migration.export.core.issuelinktype.IssueLinkTypeExtensionFunctionsKt;
import com.atlassian.jira.migration.export.db.advancedroadmaps.HierarchyConfigData;
import com.atlassian.jira.migration.preflight.EpicLinksAboveStoryHierarchyLevelResult;
import com.atlassian.jira.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00160\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelService;", "", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "issueLinkManager", "Lcom/atlassian/jira/issue/link/IssueLinkManager;", "hierarchyConfigDataService", "Lcom/atlassian/jira/migration/export/advancedroadmaps/ArHierarchyConfigDataService;", "(Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/issue/link/IssueLinkManager;Lcom/atlassian/jira/migration/export/advancedroadmaps/ArHierarchyConfigDataService;)V", "getAllIssuesForProjects", "", "", "Lcom/atlassian/jira/issue/Issue;", "projectKeys", "", "", "getEpicIdIfPresent", "issue", "(Lcom/atlassian/jira/issue/Issue;)Ljava/lang/Long;", "getIssueTypesByHierarchyLevel", "", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEpicLinksAboveStoryHierarchyLevelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpicLinksAboveStoryHierarchyLevelService.kt\ncom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n800#2,11:89\n766#2:100\n857#2,2:101\n1603#2,9:103\n1855#2:112\n1856#2:115\n1612#2:116\n1549#2:117\n1620#2,3:118\n1549#2:121\n1620#2,3:122\n1549#2:125\n1620#2,3:126\n1360#2:129\n1446#2,5:130\n1194#2,2:135\n1222#2,4:137\n1#3:113\n1#3:114\n*S KotlinDebug\n*F\n+ 1 EpicLinksAboveStoryHierarchyLevelService.kt\ncom/atlassian/jira/migration/preflight/EpicLinksAboveStoryHierarchyLevelService\n*L\n27#1:89,11\n35#1:100\n35#1:101,2\n36#1:103,9\n36#1:112\n36#1:115\n36#1:116\n40#1:117\n40#1:118,3\n62#1:121\n62#1:122,3\n66#1:125\n66#1:126,3\n67#1:129\n67#1:130,5\n72#1:135,2\n72#1:137,4\n36#1:114\n*E\n"})
public final class EpicLinksAboveStoryHierarchyLevelService {
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final IssueLinkManager issueLinkManager;
    @NotNull
    private final ArHierarchyConfigDataService hierarchyConfigDataService;

    @Inject
    public EpicLinksAboveStoryHierarchyLevelService(@NotNull IssueManager issueManager, @NotNull ProjectManager projectManager, @NotNull IssueLinkManager issueLinkManager, @NotNull ArHierarchyConfigDataService hierarchyConfigDataService) {
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)issueLinkManager, (String)"issueLinkManager");
        Intrinsics.checkNotNullParameter((Object)hierarchyConfigDataService, (String)"hierarchyConfigDataService");
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.issueLinkManager = issueLinkManager;
        this.hierarchyConfigDataService = hierarchyConfigDataService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        void $this$mapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Collection destination$iv$iv;
        List projectKeys;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Map map = checkRequest.parameters;
        Object v = map != null ? map.get("projectKeys") : null;
        List list = projectKeys = v instanceof List ? (List)v : null;
        if (list != null) {
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return new CheckResult(true);
        }
        List projectKeysList = (List)destination$iv$iv;
        Set issueTypesAboveStoryHierarchyLevel = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.drop((Iterable)this.getIssueTypesByHierarchyLevel(), (int)2)));
        Map<Long, Issue> allIssuesById = this.getAllIssuesForProjects(projectKeysList);
        $this$filterIsInstanceTo$iv$iv = allIssuesById.values();
        boolean $i$f$filter = false;
        void $i$f$filterIsInstanceTo = $this$filter$iv;
        Iterable<Pair> destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Issue)element$iv$iv;
            boolean bl = false;
            if (!(StringExtensionsKt.isNotNullOrBlank(it.getIssueTypeId()) && CollectionsKt.contains((Iterable)issueTypesAboveStoryHierarchyLevel, (Object)it.getIssueTypeId()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Issue issue2 = (Issue)element$iv$iv;
            boolean bl2 = false;
            Long l = this.getEpicIdIfPresent(issue2);
            if (l != null) {
                long it2 = ((Number)l).longValue();
                boolean bl3 = false;
                pair = TuplesKt.to((Object)issue2, (Object)it2);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List issuesAboveStoryHierarchyLevelWithEpicId = (List)destination$iv$iv2;
        Iterable $this$map$iv = issuesAboveStoryHierarchyLevelWithEpicId;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Pair element$iv$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            Object object = allIssuesById.get(it3.getSecond());
            if (object == null || (object = object.getKey()) == null) {
                object = this.issueManager.getIssueObject((Long)it3.getSecond()).getKey();
            }
            Object epicKey = object;
            String string = ((Issue)it3.getFirst()).getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            Long l = ((Issue)it3.getFirst()).getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            long l2 = ((Number)l).longValue();
            Intrinsics.checkNotNull((Object)epicKey);
            collection.add(new EpicLinksAboveStoryHierarchyLevelResult(string, l2, (String)epicKey, ((Number)it3.getSecond()).longValue()));
        }
        List epicLinksAboveStoryHierarchyLevelResult = (List)destination$iv$iv3;
        return epicLinksAboveStoryHierarchyLevelResult.isEmpty() ? new CheckResult(true) : new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"epicLinksAboveStoryHierarchyLevel", (Object)epicLinksAboveStoryHierarchyLevelResult)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Set<String>> getIssueTypesByHierarchyLevel() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.hierarchyConfigDataService.getHierarchyConfig();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it;
            HierarchyConfigData hierarchyConfigData = (HierarchyConfigData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = it.getIssueTypeIds();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void id;
                long l = ((Number)item$iv$iv2).longValue();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(String.valueOf((long)id));
            }
            collection.add(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, Issue> getAllIssuesForProjects(List<String> projectKeys) {
        Map map;
        void $this$flatMapTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = projectKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.projectManager.getProjectObjByKeyIgnoreCase((String)key).getId());
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Long id = (Long)element$iv$iv;
            boolean bl = false;
            Collection collection = this.issueManager.getIssueIdsForProject(id);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getIssueIdsForProject(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List issueIds = (List)destination$iv$iv;
        if (issueIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            void $this$associateByTo$iv$iv;
            List list = this.issueManager.getIssueObjects((Collection)issueIds);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssueObjects(...)");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                Issue bl = (Issue)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                Long l = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                object.put(((Number)l).longValue(), element$iv$iv);
            }
            map = destination$iv$iv2;
        }
        return map;
    }

    private final Long getEpicIdIfPresent(Issue issue2) {
        Object v2;
        block1: {
            List list = this.issueLinkManager.getInwardLinks(issue2.getId());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInwardLinks(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                IssueLink it = (IssueLink)t;
                boolean bl = false;
                IssueLinkType issueLinkType = it.getIssueLinkType();
                Intrinsics.checkNotNullExpressionValue((Object)issueLinkType, (String)"getIssueLinkType(...)");
                if (!IssueLinkTypeExtensionFunctionsKt.isEpicLinkType(issueLinkType)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        IssueLink issueLink = v2;
        return issueLink != null ? issueLink.getSourceId() : null;
    }
}

