/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.events.GroupsExistInCloudCheckEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.preflight.GroupConflict;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissions;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.usersmigrationservice.GroupsConflictCheckResponse;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/GroupConflictService;", "", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "groupConflictTimeoutInMillis", "", "groupConflictStatusCheckInterval", "Lkotlin/Function1;", "", "(Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/events/MigrationEventBus;JLkotlin/jvm/functions/Function1;)V", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "pollTillCompletionOrTimeout", "Lcom/atlassian/jira/migration/usersmigrationservice/GroupsConflictCheckResponse;", "containerToken", "", "taskId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nGroupConflictService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupConflictService.kt\ncom/atlassian/jira/migration/preflight/GroupConflictService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1549#2:122\n1620#2,3:123\n1549#2:126\n1620#2,3:127\n*S KotlinDebug\n*F\n+ 1 GroupConflictService.kt\ncom/atlassian/jira/migration/preflight/GroupConflictService\n*L\n45#1:122\n45#1:123,3\n61#1:126\n61#1:127,3\n*E\n"})
public final class GroupConflictService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private final long groupConflictTimeoutInMillis;
    @NotNull
    private final Function1<Long, Unit> groupConflictStatusCheckInterval;
    @NotNull
    public static final String GROUP_CONFLICTS_KEY = "groupConflicts";
    public static final long GROUP_CONFLICT_TIMEOUT_IN_MILLIS = 600000L;
    public static final long GROUP_CONFLICT_STATUS_POLL_INTERVAL_IN_MILLIS = 2500L;

    @VisibleForTesting
    public GroupConflictService(@NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MigrationEventBus migrationEventBus, long groupConflictTimeoutInMillis, @NotNull Function1<? super Long, Unit> groupConflictStatusCheckInterval) {
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter(groupConflictStatusCheckInterval, (String)"groupConflictStatusCheckInterval");
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.migrationEventBus = migrationEventBus;
        this.groupConflictTimeoutInMillis = groupConflictTimeoutInMillis;
        this.groupConflictStatusCheckInterval = groupConflictStatusCheckInterval;
    }

    @Inject
    public GroupConflictService(@NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this(usersMigrationServiceClient, migrationEventBus, 600000L, (Function1<? super Long, Unit>)((Function1)1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        NotBlockingCheckResult notBlockingCheckResult;
        List list;
        Iterable it;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        UsersGroupsExtractionResult extractionResult = PreflightCheckKt.getUsersAndGroups(checkRequest);
        Map extractionErrorDetails = extractionResult.getHasErrors() ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"extractionHasErrors", (Object)true)) : MapsKt.emptyMap();
        Iterable iterable = extractionResult.getGroups();
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JiraGroupWithPermissions jiraGroupWithPermissions = (JiraGroupWithPermissions)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((JiraGroupWithPermissions)((Object)it)).getName());
        }
        List groupNames = (List)destination$iv$iv;
        if (groupNames.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            String taskId2;
            String containerToken = PreflightCheckKt.getContainerToken(checkRequest);
            GroupsConflictCheckResponse response2 = this.pollTillCompletionOrTimeout(containerToken, taskId2 = this.usersMigrationServiceClient.startGroupConflictsCheck(containerToken, groupNames));
            if (!((Collection)response2.getErrors()).isEmpty()) {
                throw new RuntimeException("Error in retrieving group conflicts");
            }
            if (response2.getCanceled()) {
                throw new RuntimeException("Group conflict check canceled in UMS. Error in retrieving group conflicts");
            }
            List<String> list3 = response2.getConflictingGroups();
            if (list3 != null) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = list3;
                boolean $i$f$map2 = false;
                it = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void p0;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(new GroupConflict((String)p0));
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
        }
        List conflictingGroups = list;
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new GroupsExistInCloudCheckEvent(string, string2, (endTime - startTime) / (long)1000000, conflictingGroups.isEmpty(), extractionResult.getExportStatistics(), extractionResult.getGroups().size(), conflictingGroups.size()));
        if (conflictingGroups.isEmpty()) {
            notBlockingCheckResult = new NotBlockingCheckResult(true, extractionErrorDetails);
        } else {
            Map groupConflictsErrorDetails = MapsKt.mapOf((Pair)TuplesKt.to((Object)GROUP_CONFLICTS_KEY, (Object)conflictingGroups));
            notBlockingCheckResult = new NotBlockingCheckResult(false, MapsKt.plus((Map)extractionErrorDetails, (Map)groupConflictsErrorDetails));
        }
        return notBlockingCheckResult;
    }

    private final GroupsConflictCheckResponse pollTillCompletionOrTimeout(String containerToken, String taskId2) {
        Instant timeout = Instant.now().plusMillis(this.groupConflictTimeoutInMillis);
        while (Instant.now().compareTo(timeout) < 0) {
            GroupsConflictCheckResponse response2 = this.usersMigrationServiceClient.getGroupsConflictResponse(containerToken, taskId2);
            if (response2.getComplete() || response2.getCanceled()) {
                return response2;
            }
            this.groupConflictStatusCheckInterval.invoke((Object)2500L);
        }
        throw new RuntimeException("Group conflict check status polling timed out after " + this.groupConflictTimeoutInMillis + " milli-seconds");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/preflight/GroupConflictService$Companion;", "", "()V", "GROUP_CONFLICTS_KEY", "", "GROUP_CONFLICT_STATUS_POLL_INTERVAL_IN_MILLIS", "", "getGROUP_CONFLICT_STATUS_POLL_INTERVAL_IN_MILLIS$annotations", "GROUP_CONFLICT_TIMEOUT_IN_MILLIS", "getGROUP_CONFLICT_TIMEOUT_IN_MILLIS$annotations", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getGROUP_CONFLICT_TIMEOUT_IN_MILLIS$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getGROUP_CONFLICT_STATUS_POLL_INTERVAL_IN_MILLIS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

