/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.GroupConflictService;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/preflight/GroupNamesConflictCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "groupConflictService", "Lcom/atlassian/jira/migration/preflight/GroupConflictService;", "(Lcom/atlassian/jira/migration/preflight/GroupConflictService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "jira-migration-plugin"})
public final class GroupNamesConflictCheck
extends NotBlockingCheck {
    @NotNull
    private final GroupConflictService groupConflictService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public GroupNamesConflictCheck(@NotNull GroupConflictService groupConflictService) {
        Intrinsics.checkNotNullParameter((Object)groupConflictService, (String)"groupConflictService");
        super("We couldn't check for group conflicts", "Checking for groups in your cloud site", "There are no conflicting group names", "Some groups already exist in your cloud site");
        this.groupConflictService = groupConflictService;
        this.checkType = CheckType.GroupNamesConflict;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"usersAndGroups", ctx.getUsersAndGroups()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.groupConflictService.performCheck(checkRequest);
    }

    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        super.inject(dto, checkResult);
        CheckResult checkResult2 = checkResult;
        if (checkResult2 != null) {
            List groupConflicts;
            CheckResult it = checkResult2;
            boolean bl = false;
            Object v = it.details.get("groupConflicts");
            List list = groupConflicts = v instanceof List ? (List)v : null;
            if (list != null) {
                List $this$inject_u24lambda_u241_u24lambda_u240 = list;
                boolean bl2 = false;
                CheckDetailsDto details2 = new CheckDetailsDto();
                details2.setListOfOccurrences($this$inject_u24lambda_u241_u24lambda_u240);
                dto.setNumberOfOccurrences(Integer.valueOf($this$inject_u24lambda_u241_u24lambda_u240.size()));
                dto.setDetails(details2);
            }
        }
        this.handleExtractionError(dto, checkResult, "Check for group name conflict could not be completed");
    }
}

