/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.serverdataextractors.JiraServerStatsReader;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0017J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/preflight/HeapSizeCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jiraServerStatsReader", "Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;", "(Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getSystemHeapSize", "", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "result", "isHeapSizeConfiguredCorrectly", "", "performCheck", "checkRequest", "ServerScale", "jira-migration-plugin"})
public final class HeapSizeCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final JiraServerStatsReader jiraServerStatsReader;
    @NotNull
    private final CheckType checkType;

    @Inject
    public HeapSizeCheck(@NotNull JiraServerStatsReader jiraServerStatsReader) {
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        this.jiraServerStatsReader = jiraServerStatsReader;
        this.checkType = CheckType.HeapSize;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @VisibleForTesting
    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult result2) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        dto.setCheckType("HeapSize");
        if (result2 != null) {
            Boolean isHeapConfiguredCorrectly;
            Object v = result2.details.get("heapCorrectlyConfigured");
            Boolean bl = isHeapConfiguredCorrectly = v instanceof Boolean ? (Boolean)v : null;
            if (isHeapConfiguredCorrectly != null) {
                if (isHeapConfiguredCorrectly.booleanValue()) {
                    dto.setStatus(Status.SUCCESS);
                } else {
                    dto.setDescription("Your heap size is lower than the recommended size");
                    dto.setStatus(Status.WARNING);
                }
            }
        }
    }

    public final long getSystemHeapSize() {
        return Runtime.getRuntime().maxMemory();
    }

    public final boolean isHeapSizeConfiguredCorrectly() {
        ServerScale serverScale = ServerScale.Companion.getScaleByIssuesCount(this.jiraServerStatsReader.calculateNumberOfIssues());
        return serverScale.getRecommendedHeapSize() <= this.getSystemHeapSize();
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"heapCorrectlyConfigured", (Object)this.isHeapSizeConfiguredCorrectly())));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/preflight/HeapSizeCheck$ServerScale;", "", "issuesCountRange", "Lkotlin/ranges/LongRange;", "recommendedHeapSize", "", "(Ljava/lang/String;ILkotlin/ranges/LongRange;J)V", "getIssuesCountRange", "()Lkotlin/ranges/LongRange;", "getRecommendedHeapSize", "()J", "SMALL", "MID", "LARGE", "ENTERPRISE", "Companion", "jira-migration-plugin"})
    public static final class ServerScale
    extends Enum<ServerScale> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final LongRange issuesCountRange;
        private final long recommendedHeapSize;
        public static final /* enum */ ServerScale SMALL;
        public static final /* enum */ ServerScale MID;
        public static final /* enum */ ServerScale LARGE;
        public static final /* enum */ ServerScale ENTERPRISE;
        private static final /* synthetic */ ServerScale[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ServerScale(LongRange issuesCountRange, long recommendedHeapSize) {
            this.issuesCountRange = issuesCountRange;
            this.recommendedHeapSize = recommendedHeapSize;
        }

        @NotNull
        public final LongRange getIssuesCountRange() {
            return this.issuesCountRange;
        }

        public final long getRecommendedHeapSize() {
            return this.recommendedHeapSize;
        }

        public static ServerScale[] values() {
            return (ServerScale[])$VALUES.clone();
        }

        public static ServerScale valueOf(String value) {
            return Enum.valueOf(ServerScale.class, value);
        }

        @NotNull
        public static EnumEntries<ServerScale> getEntries() {
            return $ENTRIES;
        }

        static {
            SMALL = new ServerScale(new LongRange(0L, 15000L), 1048576000L);
            MID = new ServerScale(new LongRange(15001L, 60000L), 0x7D000000L);
            LARGE = new ServerScale(new LongRange(60001L, 200000L), 0xFA000000L);
            ENTERPRISE = new ServerScale(new LongRange(200001L, Long.MAX_VALUE), 8388608000L);
            $VALUES = serverScaleArray = new ServerScale[]{ServerScale.SMALL, ServerScale.MID, ServerScale.LARGE, ServerScale.ENTERPRISE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/preflight/HeapSizeCheck$ServerScale$Companion;", "", "()V", "getScaleByIssuesCount", "Lcom/atlassian/jira/migration/preflight/HeapSizeCheck$ServerScale;", "issuesCount", "", "jira-migration-plugin"})
        @SourceDebugExtension(value={"SMAP\nHeapSizeCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapSizeCheck.kt\ncom/atlassian/jira/migration/preflight/HeapSizeCheck$ServerScale$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n1109#2,2:100\n*S KotlinDebug\n*F\n+ 1 HeapSizeCheck.kt\ncom/atlassian/jira/migration/preflight/HeapSizeCheck$ServerScale$Companion\n*L\n81#1:100,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ServerScale getScaleByIssuesCount(long issuesCount) {
                ServerScale element$iv;
                block2: {
                    ServerScale[] $this$first$iv = ServerScale.values();
                    boolean $i$f$first = false;
                    int n = $this$first$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ServerScale it = element$iv = $this$first$iv[i];
                        boolean bl = false;
                        if (!it.getIssuesCountRange().contains(issuesCount)) {
                            continue;
                        }
                        break block2;
                    }
                    throw new NoSuchElementException("Array contains no element matching the predicate.");
                }
                return element$iv;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

