/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.SiteDetailsResponse;
import com.atlassian.jira.migration.migrationservice.SiteDetailsWithCloudId;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.preflight.JiraProductInCloudRequestParams;
import com.atlassian.jira.migration.preflight.JiraProductInCloudResultParams;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupPermission;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissions;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ProductPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/preflight/JiraProductsInCloudService;", "", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "doesPlanContainGroupsWithPermissionsForJiraProduct", "", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "serverProductPermissionName", "", "doesPlanContainProjectsForJiraProduct", "serverProjectTypeKey", "isJiraProductInstalledInCloud", "siteDetails", "Lcom/atlassian/jira/migration/migrationservice/SiteDetailsResponse;", "cloudProductKey", "Lcom/atlassian/cmpt/domain/Product;", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jiraProductInCloudRequestParams", "Lcom/atlassian/jira/migration/preflight/JiraProductInCloudRequestParams;", "redirectLinkToAddJWMProduct", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "redirectLinkToAddJiraProduct", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJiraProductsInCloudService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraProductsInCloudService.kt\ncom/atlassian/jira/migration/preflight/JiraProductsInCloudService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1360#2:83\n1446#2,5:84\n1747#2,3:89\n1747#2,3:92\n1747#2,2:95\n1747#2,3:97\n1749#2:100\n*S KotlinDebug\n*F\n+ 1 JiraProductsInCloudService.kt\ncom/atlassian/jira/migration/preflight/JiraProductsInCloudService\n*L\n46#1:83\n46#1:84,5\n46#1:89,3\n50#1:92,3\n54#1:95,2\n55#1:97,3\n54#1:100\n*E\n"})
public final class JiraProductsInCloudService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    public static final String RESULT_PARAMS_KEY = "RESULT_PARAMS";

    @Inject
    public JiraProductsInCloudService(@NotNull ProjectsReader projectsReader, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.projectsReader = projectsReader;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest, @NotNull JiraProductInCloudRequestParams jiraProductInCloudRequestParams) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Intrinsics.checkNotNullParameter((Object)jiraProductInCloudRequestParams, (String)"jiraProductInCloudRequestParams");
        CloudSite savedCloudSiteDetails = jiraProductInCloudRequestParams.getJiraProductsCloudFreeUserLimitPreflightService().getSavedCloudDetails(checkRequest);
        SiteDetailsResponse currentSiteDetails = jiraProductInCloudRequestParams.getJiraProductsCloudFreeUserLimitPreflightService().getCurrentSiteDetails(checkRequest);
        boolean isJiraProductInstalled = this.isJiraProductInstalledInCloud(currentSiteDetails, jiraProductInCloudRequestParams.getCloudProductKey());
        boolean doesPlanContainProjects = this.doesPlanContainProjectsForJiraProduct(checkRequest, jiraProductInCloudRequestParams.getServerProjectTypeKey());
        boolean doesPlanContainGroups = this.doesPlanContainGroupsWithPermissionsForJiraProduct(checkRequest, jiraProductInCloudRequestParams.getServerProductPermissionName());
        boolean isJiraCoreProduct = jiraProductInCloudRequestParams.getCloudProductKey() == Product.JIRA_CORE;
        boolean isJsmProduct = jiraProductInCloudRequestParams.getCloudProductKey() == Product.JIRA_SERVICEDESK;
        jiraProductInCloudRequestParams.getJiraProductsCloudFreeUserLimitPreflightService().updateEdition(savedCloudSiteDetails, currentSiteDetails);
        return new CheckResult(isJiraProductInstalled || isJiraCoreProduct || !doesPlanContainGroups && (!isJsmProduct || !doesPlanContainProjects), MapsKt.mapOf((Pair)TuplesKt.to((Object)RESULT_PARAMS_KEY, (Object)new JiraProductInCloudResultParams(isJiraProductInstalled, isJsmProduct && doesPlanContainProjects || doesPlanContainGroups, isJiraCoreProduct && !this.migrationFeatures.getDisableRequestParameterInRequestUrlForSpork() ? this.redirectLinkToAddJWMProduct(savedCloudSiteDetails) : this.redirectLinkToAddJiraProduct(savedCloudSiteDetails)))));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isJiraProductInstalledInCloud(SiteDetailsResponse siteDetails, Product cloudProductKey) {
        boolean bl;
        block4: {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = siteDetails.getSites();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                SiteDetailsWithCloudId it = (SiteDetailsWithCloudId)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getProducts();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TcsProductInfo it = (TcsProductInfo)element$iv;
                    boolean bl3 = false;
                    if (!(it.getProductKey() == cloudProductKey)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean doesPlanContainProjectsForJiraProduct(CheckRequest checkRequest, String serverProjectTypeKey) {
        boolean bl;
        block3: {
            List<String> projectsInPlan = PreflightCheckKt.getProjectKeys(checkRequest);
            Iterable $this$any$iv = projectsInPlan;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)this.projectsReader.getProject(it).getProjectTypeKey().getKey(), (Object)serverProjectTypeKey)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean doesPlanContainGroupsWithPermissionsForJiraProduct(CheckRequest checkRequest, String serverProductPermissionName) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = PreflightCheckKt.getUsersAndGroups(checkRequest).getGroups();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        JiraGroupWithPermissions jiraGroupWithPermission = (JiraGroupWithPermissions)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = jiraGroupWithPermission.getProducts();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ProductPermission productPermission = (ProductPermission)element$iv2;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual((Object)productPermission.getName(), (Object)serverProductPermissionName) && productPermission.getPermissions().contains((Object)JiraGroupPermission.PRODUCT_ACCESS))) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String redirectLinkToAddJiraProduct(CloudSite cloudSite2) {
        return cloudSite2.getCloudUrl() + "/admin/billing/applications";
    }

    private final String redirectLinkToAddJWMProduct(CloudSite cloudSite2) {
        return cloudSite2.getCloudUrl() + "/admin/billing/addapplication?source=migration";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/preflight/JiraProductsInCloudService$Companion;", "", "()V", "RESULT_PARAMS_KEY", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

