/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.CloudEntityCreationLimitErrorData;
import com.atlassian.jira.migration.preflight.JsmCloudEntityCreationLimitCheckKt;
import com.atlassian.jira.migration.preflight.JsmCloudEntityCreationLimitService;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.csv.JsmCloudEntityCreationLimitCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "jsmCloudEntityCreationLimitService", "Lcom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitService;", "(Lcom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsmCloudEntityCreationLimitCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsmCloudEntityCreationLimitCheck.kt\ncom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1549#2:124\n1620#2,3:125\n*S KotlinDebug\n*F\n+ 1 JsmCloudEntityCreationLimitCheck.kt\ncom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitCheck\n*L\n79#1:124\n79#1:125,3\n*E\n"})
public final class JsmCloudEntityCreationLimitCheck
extends NotBlockingCheck {
    @NotNull
    private final JsmCloudEntityCreationLimitService jsmCloudEntityCreationLimitService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public JsmCloudEntityCreationLimitCheck(@NotNull JsmCloudEntityCreationLimitService jsmCloudEntityCreationLimitService) {
        Intrinsics.checkNotNullParameter((Object)jsmCloudEntityCreationLimitService, (String)"jsmCloudEntityCreationLimitService");
        super("We couldn\u2019t check Cloud limits for queues, legacy automation rules, and SLAs", "Checking Cloud limits for queues, legacy automation rules, and SLAs", "Queues, legacy automation rules, and SLAs are within the Cloud limits", "Some of the Jira Service Management entities have exceeded Cloud limits");
        this.jsmCloudEntityCreationLimitService = jsmCloudEntityCreationLimitService;
        this.checkType = CheckType.JsmCloudEntityCreationLimits;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.jsmCloudEntityCreationLimitService.performCheck(checkRequest);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        void $this$inject_u24lambda_u240;
        CheckDetailsDto checkDetailsDto;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        super.inject(dto, checkResult);
        CheckDetailsDto checkDetailsDto2 = checkDetailsDto = new CheckDetailsDto();
        CheckResultDto checkResultDto = dto;
        boolean bl = false;
        CheckResult checkResult2 = checkResult;
        $this$inject_u24lambda_u240.setInfo(checkResult2 != null ? checkResult2.details : null);
        checkResultDto.setDetails(checkDetailsDto);
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        String string = planName;
        if (string == null) {
            string = executionId;
        }
        String migrationName = string;
        return migrationName + "_Pre-migration checks_Projects_Jira Service Management entities_Jira_" + dateTime + ".csv";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        List list;
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        if (checkStatus.checkResult == null || checkStatus.checkResult.details.isEmpty()) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)JsmCloudEntityCreationLimitCheckKt.getCLOUD_ENTITY_CREATION_LIMIT_HEADERS()));
        }
        Object v = checkStatus.checkResult.details.get("CloudEntityCreationLimitErrorData");
        List cloudEntityCreationLimitErrorData = v instanceof List ? (List)v : null;
        Pair[] pairArray = (Pair[])cloudEntityCreationLimitErrorData;
        if (pairArray == null || pairArray.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = cloudEntityCreationLimitErrorData;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CloudEntityCreationLimitErrorData cloudEntityCreationLimitErrorData2 = (CloudEntityCreationLimitErrorData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JsmCloudEntityCreationLimitCSVData(it.getProjectKey(), it.getProjectName(), it.getEntity(), it.getCountInProject(), it.getMaxLimitInCloud()));
            }
            list = (List)destination$iv$iv;
        }
        List beans = list;
        pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"headers", (Object)JsmCloudEntityCreationLimitCheckKt.getCLOUD_ENTITY_CREATION_LIMIT_HEADERS());
        String[] stringArray = new String[]{"projectKey", "projectName", "entity", "countInProject", "maxLimitInCloud"};
        pairArray[1] = TuplesKt.to((Object)"mappings", (Object)stringArray);
        pairArray[2] = TuplesKt.to((Object)"beans", (Object)beans);
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

