/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.queue.QueueReader;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricReader;
import com.atlassian.jira.migration.export.servicedesk.automation.AutomationServiceFacade;
import com.atlassian.jira.migration.jiracloudservice.CloudEntityCreationLimitRequest;
import com.atlassian.jira.migration.jiracloudservice.JiraCloudClient;
import com.atlassian.jira.migration.preflight.CloudEntityCreationLimitData;
import com.atlassian.jira.migration.preflight.CloudEntityCreationLimitErrorData;
import com.atlassian.jira.migration.preflight.Entity;
import com.atlassian.jira.migration.preflight.JsmCloudEntityCreationLimitServiceKt;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.api.ContainerToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u000eH\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aJQ\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u000e2\u0006\u0010 \u001a\u00020\u000f2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00120\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitService;", "", "queueReader", "Lcom/atlassian/jira/migration/db/servicedesk/queue/QueueReader;", "timeMetricReader", "Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricReader;", "automationServiceFacade", "Lcom/atlassian/jira/migration/export/servicedesk/automation/AutomationServiceFacade;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "jiraCloudClient", "Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;", "(Lcom/atlassian/jira/migration/db/servicedesk/queue/QueueReader;Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricReader;Lcom/atlassian/jira/migration/export/servicedesk/automation/AutomationServiceFacade;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;)V", "entityToVerifyFunction", "", "Lcom/atlassian/jira/migration/preflight/Entity;", "Lkotlin/Function1;", "", "", "getCloudEntityCreationLimitData", "", "Lcom/atlassian/jira/migration/preflight/CloudEntityCreationLimitData;", "maxLimitsOnCloudMap", "", "getMaxLimitsOnCloud", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "verifyCloudEntityCreationLimit", "Lcom/atlassian/jira/migration/preflight/CloudEntityCreationLimitErrorData;", "projectKey", "entity", "verifyCountFunction", "Lkotlin/ParameterName;", "name", "pKey", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsmCloudEntityCreationLimitService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsmCloudEntityCreationLimitService.kt\ncom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1208#2,2:149\n1238#2,4:151\n1549#2:155\n1620#2,2:156\n1549#2:158\n1620#2,3:159\n1622#2:162\n1549#2:163\n1620#2,3:164\n*S KotlinDebug\n*F\n+ 1 JsmCloudEntityCreationLimitService.kt\ncom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitService\n*L\n37#1:149,2\n37#1:151,4\n52#1:155\n52#1:156,2\n54#1:158\n54#1:159,3\n52#1:162\n81#1:163\n81#1:164,3\n*E\n"})
public final class JsmCloudEntityCreationLimitService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QueueReader queueReader;
    @NotNull
    private final TimeMetricReader timeMetricReader;
    @NotNull
    private final AutomationServiceFacade automationServiceFacade;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final JiraCloudClient jiraCloudClient;
    @NotNull
    private final Map<Entity, Function1<String, Integer>> entityToVerifyFunction;
    @NotNull
    public static final String JSM_CLOUD_LIMIT_WARNING_KEY = "CloudEntityCreationLimitErrorData";
    @NotNull
    public static final String JSM_CLOUD_LIMITS_KEY = "cloudEntityCreationLimits";

    @Inject
    public JsmCloudEntityCreationLimitService(@NotNull QueueReader queueReader, @NotNull TimeMetricReader timeMetricReader, @NotNull AutomationServiceFacade automationServiceFacade, @NotNull ProjectManager projectManager, @NotNull JiraCloudClient jiraCloudClient) {
        Intrinsics.checkNotNullParameter((Object)queueReader, (String)"queueReader");
        Intrinsics.checkNotNullParameter((Object)timeMetricReader, (String)"timeMetricReader");
        Intrinsics.checkNotNullParameter((Object)automationServiceFacade, (String)"automationServiceFacade");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)jiraCloudClient, (String)"jiraCloudClient");
        this.queueReader = queueReader;
        this.timeMetricReader = timeMetricReader;
        this.automationServiceFacade = automationServiceFacade;
        this.projectManager = projectManager;
        this.jiraCloudClient = jiraCloudClient;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)Entity.QUEUE), (Object)new Function1<String, Integer>(this){
            final /* synthetic */ JsmCloudEntityCreationLimitService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return JsmCloudEntityCreationLimitService.access$getQueueReader$p(this.this$0).getQueuesCountByProjectKey(key);
            }
        }), TuplesKt.to((Object)((Object)Entity.SLA), (Object)new Function1<String, Integer>(this){
            final /* synthetic */ JsmCloudEntityCreationLimitService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return JsmCloudEntityCreationLimitService.access$getTimeMetricReader$p(this.this$0).getTimeMetricCountByProjectKey(key);
            }
        }), TuplesKt.to((Object)((Object)Entity.AUTOMATION), (Object)new Function1<String, Integer>(this){
            final /* synthetic */ JsmCloudEntityCreationLimitService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return JsmCloudEntityCreationLimitService.access$getAutomationServiceFacade$p(this.this$0).getRuleSetCountByProjectKey(key);
            }
        })};
        this.entityToVerifyFunction = MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Entity, Long> getMaxLimitsOnCloud(CheckRequest checkRequest) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = JsmCloudEntityCreationLimitServiceKt.access$getEntityToCloudLimitPropertyName$p().entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            Entity entity = (Entity)((Object)it.getKey());
            boolean bl2 = false;
            Long l = this.jiraCloudClient.getCloudEntityCreationLimitForSite(new CloudEntityCreationLimitRequest((String)it.getValue(), new ContainerToken(PreflightCheckKt.getContainerToken(checkRequest)), PreflightCheckKt.getCloudId(checkRequest)));
            map.put(entity, l);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        NotBlockingCheckResult notBlockingCheckResult;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Map<Entity, Long> maxLimitsOnCloudMap = this.getMaxLimitsOnCloud(checkRequest);
        Iterable $this$map$iv = PreflightCheckKt.getProjectKeys(checkRequest);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void projectKey = it;
            Iterable $this$map$iv2 = this.entityToVerifyFunction.entrySet();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void entry;
                Map.Entry entry2 = (Map.Entry)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(this.verifyCloudEntityCreationLimit((String)projectKey, maxLimitsOnCloudMap, (Entity)((Object)entry.getKey()), (Function1<? super String, Integer>)((Function1)entry.getValue())));
            }
            collection.add((List)destination$iv$iv2);
        }
        List cloudEntityCreationLimitErrorsData = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
        if (cloudEntityCreationLimitErrorsData.isEmpty()) {
            notBlockingCheckResult = new NotBlockingCheckResult(true);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JSM_CLOUD_LIMIT_WARNING_KEY, (Object)cloudEntityCreationLimitErrorsData), TuplesKt.to((Object)JSM_CLOUD_LIMITS_KEY, this.getCloudEntityCreationLimitData(maxLimitsOnCloudMap))};
            Map details2 = MapsKt.mapOf((Pair[])pairArray);
            notBlockingCheckResult = new NotBlockingCheckResult(false, details2);
        }
        return notBlockingCheckResult;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CloudEntityCreationLimitData> getCloudEntityCreationLimitData(Map<Entity, Long> maxLimitsOnCloudMap) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = maxLimitsOnCloudMap.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CloudEntityCreationLimitData(((Entity)((Object)it.getKey())).toString(), (int)((Number)it.getValue()).longValue()));
        }
        return (List)destination$iv$iv;
    }

    private final CloudEntityCreationLimitErrorData verifyCloudEntityCreationLimit(String projectKey, Map<Entity, Long> maxLimitsOnCloudMap, Entity entity, Function1<? super String, Integer> verifyCountFunction) {
        CloudEntityCreationLimitErrorData cloudEntityCreationLimitErrorData;
        int entityCountOnServer = ((Number)verifyCountFunction.invoke((Object)projectKey)).intValue();
        Long l = maxLimitsOnCloudMap.get((Object)entity);
        Intrinsics.checkNotNull((Object)l);
        long maxCloudEntityLimit = ((Number)l).longValue();
        if ((long)entityCountOnServer > maxCloudEntityLimit) {
            String string = this.projectManager.getProjectObjByKey(projectKey).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            cloudEntityCreationLimitErrorData = new CloudEntityCreationLimitErrorData(projectKey, string, entity.getValue(), entityCountOnServer, (int)maxCloudEntityLimit);
        } else {
            cloudEntityCreationLimitErrorData = null;
        }
        return cloudEntityCreationLimitErrorData;
    }

    public static final /* synthetic */ QueueReader access$getQueueReader$p(JsmCloudEntityCreationLimitService $this) {
        return $this.queueReader;
    }

    public static final /* synthetic */ TimeMetricReader access$getTimeMetricReader$p(JsmCloudEntityCreationLimitService $this) {
        return $this.timeMetricReader;
    }

    public static final /* synthetic */ AutomationServiceFacade access$getAutomationServiceFacade$p(JsmCloudEntityCreationLimitService $this) {
        return $this.automationServiceFacade;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/JsmCloudEntityCreationLimitService$Companion;", "", "()V", "JSM_CLOUD_LIMITS_KEY", "", "JSM_CLOUD_LIMIT_WARNING_KEY", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

