/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.LinkDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.JsmCloudFreeAgentLimitPreflightService;
import com.atlassian.jira.migration.preflight.JsmFreeEditionResult;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jsmCloudFreeAgentLimitPreflightService", "Lcom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitPreflightService;", "(Lcom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitPreflightService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "handleSuccess", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "result", "inject", "", "performCheck", "checkRequest", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsmCloudFreeAgentLimitCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsmCloudFreeAgentLimitCheck.kt\ncom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class JsmCloudFreeAgentLimitCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsmCloudFreeAgentLimitPreflightService jsmCloudFreeAgentLimitPreflightService;
    @NotNull
    private final CheckType checkType;
    @NotNull
    public static final String STATUS_SUCCESS_DESCRIPTION = "Cloud plan for Jira Service Management has been upgraded";
    @NotNull
    public static final String STATUS_RUNNING_DESCRIPTION = "Checking for plan limits";
    @NotNull
    public static final String STATUS_WARNING_DESCRIPTION = "You may exceed your limit for agents";
    @NotNull
    public static final String STATUS_ERROR_DESCRIPTION = "We couldn\u2019t check for agents count limit";
    @NotNull
    public static final String EMPTY_DESCRIPTION = "";

    @Inject
    public JsmCloudFreeAgentLimitCheck(@NotNull JsmCloudFreeAgentLimitPreflightService jsmCloudFreeAgentLimitPreflightService) {
        Intrinsics.checkNotNullParameter((Object)jsmCloudFreeAgentLimitPreflightService, (String)"jsmCloudFreeAgentLimitPreflightService");
        this.jsmCloudFreeAgentLimitPreflightService = jsmCloudFreeAgentLimitPreflightService;
        this.checkType = CheckType.JsmCloudFreeAgentLimit;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.jsmCloudFreeAgentLimitPreflightService.performCheck(checkRequest);
    }

    protected void inject(@Nullable CheckResultDto dto, @Nullable CheckResult result2) {
        CheckResultDto checkResultDto = dto;
        if (checkResultDto != null) {
            String string;
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    string = STATUS_RUNNING_DESCRIPTION;
                    break;
                }
                case 2: {
                    CheckResult checkResult = result2;
                    Intrinsics.checkNotNull((Object)checkResult);
                    string = this.handleSuccess(dto, checkResult);
                    break;
                }
                default: {
                    dto.setStatus(Status.EXECUTION_ERROR);
                    string = STATUS_ERROR_DESCRIPTION;
                }
            }
            checkResultDto.setDescription(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String handleSuccess(CheckResultDto dto, CheckResult result2) {
        String string;
        Object v = result2.details.get("RESULT_KEY");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.preflight.JsmFreeEditionResult");
        JsmFreeEditionResult $this$handleSuccess_u24lambda_u241 = (JsmFreeEditionResult)v;
        boolean bl = false;
        if ($this$handleSuccess_u24lambda_u241.getJsmEdition() == Edition.FREE) {
            dto.setStatus(Status.WARNING);
            dto.setLink(new LinkDto(EMPTY_DESCRIPTION, $this$handleSuccess_u24lambda_u241.getRedirectUrl()));
            string = STATUS_WARNING_DESCRIPTION;
        } else if ($this$handleSuccess_u24lambda_u241.isCloudJsmEditionUpgradedFromFree()) {
            string = STATUS_SUCCESS_DESCRIPTION;
        } else {
            void $this$handleSuccess_u24lambda_u241_u24lambda_u240;
            CheckDetailsDto checkDetailsDto;
            CheckDetailsDto checkDetailsDto2 = checkDetailsDto = new CheckDetailsDto();
            CheckResultDto checkResultDto = dto;
            boolean bl2 = false;
            $this$handleSuccess_u24lambda_u241_u24lambda_u240.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"REMOVABLE", (Object)true)));
            checkResultDto.setDetails(checkDetailsDto);
            string = EMPTY_DESCRIPTION;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitCheck$Companion;", "", "()V", "EMPTY_DESCRIPTION", "", "STATUS_ERROR_DESCRIPTION", "STATUS_RUNNING_DESCRIPTION", "STATUS_SUCCESS_DESCRIPTION", "STATUS_WARNING_DESCRIPTION", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

