/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.migrationservice.CloudSiteRequestEntry;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.SiteDetailsRequest;
import com.atlassian.jira.migration.migrationservice.SiteDetailsResponse;
import com.atlassian.jira.migration.migrationservice.SiteDetailsWithCloudId;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.preflight.JiraProductsCloudFreeUserLimitPreflightService;
import com.atlassian.jira.migration.preflight.JsmCloudFreeAgentLimitPreflightService;
import com.atlassian.jira.migration.preflight.JsmFreeEditionResult;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitPreflightService;", "Lcom/atlassian/jira/migration/preflight/JiraProductsCloudFreeUserLimitPreflightService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getCurrentSiteDetails", "Lcom/atlassian/jira/migration/migrationservice/SiteDetailsResponse;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "getSavedCloudDetails", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "isJsmUpgradedFromFree", "", "savedCloudSiteJsmDetails", "currentJsmEdition", "Lcom/atlassian/cmpt/domain/Edition;", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "redirectLinkToUserManagement", "", "cloudSite", "updateEdition", "", "savedCloudSite", "currentSiteDetails", "getJsmEdition", "", "Lcom/atlassian/jira/migration/migrationservice/TcsProductInfo;", "getProducts", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsmCloudFreeAgentLimitPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsmCloudFreeAgentLimitPreflightService.kt\ncom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitPreflightService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,123:1\n1#2:124\n58#3:125\n51#3:126\n*S KotlinDebug\n*F\n+ 1 JsmCloudFreeAgentLimitPreflightService.kt\ncom/atlassian/jira/migration/preflight/JsmCloudFreeAgentLimitPreflightService\n*L\n115#1:125\n115#1:126\n*E\n"})
public final class JsmCloudFreeAgentLimitPreflightService
extends JiraProductsCloudFreeUserLimitPreflightService {
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final ObjectMapper mapper;

    @Inject
    public JsmCloudFreeAgentLimitPreflightService(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationServiceClient migrationServiceClient, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationServiceClient = migrationServiceClient;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        if (checkRequest.parameters == null) {
            boolean $i$a$-requireNotNull-JsmCloudFreeAgentLimitPreflightService$performCheck$22 = false;
            String $i$a$-requireNotNull-JsmCloudFreeAgentLimitPreflightService$performCheck$22 = "JSM Free Edition preflight check request parameter not found.";
            throw new IllegalArgumentException($i$a$-requireNotNull-JsmCloudFreeAgentLimitPreflightService$performCheck$22.toString());
        }
        CloudSite savedCloudSiteJsmDetails = this.getSavedCloudDetails(checkRequest);
        SiteDetailsResponse currentSiteDetails = this.getCurrentSiteDetails(checkRequest);
        Edition currentJsmEdition = this.getJsmEdition(((SiteDetailsWithCloudId)CollectionsKt.first(currentSiteDetails.getSites())).getProducts());
        CheckResult checkResult = new CheckResult(true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"RESULT_KEY", (Object)new JsmFreeEditionResult(currentJsmEdition, this.isJsmUpgradedFromFree(savedCloudSiteJsmDetails, currentJsmEdition), this.redirectLinkToUserManagement(savedCloudSiteJsmDetails)))));
        this.updateEdition(savedCloudSiteJsmDetails, currentSiteDetails);
        return checkResult;
    }

    @Override
    @NotNull
    public CloudSite getSavedCloudDetails(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(PreflightCheckKt.getCloudId(checkRequest));
        Intrinsics.checkNotNull((Object)cloudSite2);
        return cloudSite2;
    }

    @Override
    @NotNull
    public SiteDetailsResponse getCurrentSiteDetails(@NotNull CheckRequest checkRequest) {
        SiteDetailsResponse siteDetailsResponse;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        try {
            siteDetailsResponse = this.migrationServiceClient.fetchSiteDetails(PreflightCheckKt.getContainerToken(checkRequest), new SiteDetailsRequest(SetsKt.setOf((Object)new CloudSiteRequestEntry(PreflightCheckKt.getCloudId(checkRequest), SetsKt.setOf((Object)Product.JIRA_SERVICEDESK)))));
        }
        catch (UnexpectedStatusCodeException ex) {
            if (ex.getStatusCode() != 400) {
                throw ex;
            }
            siteDetailsResponse = new SiteDetailsResponse(CollectionsKt.listOf((Object)new SiteDetailsWithCloudId(PreflightCheckKt.getCloudId(checkRequest), CollectionsKt.emptyList())));
        }
        return siteDetailsResponse;
    }

    private final boolean isJsmUpgradedFromFree(CloudSite savedCloudSiteJsmDetails, Edition currentJsmEdition) {
        boolean bl;
        boolean isSavedJsmEditionFree = this.getJsmEdition(this.getProducts(savedCloudSiteJsmDetails)) == Edition.FREE;
        Edition edition = currentJsmEdition;
        if (edition != null) {
            Edition it = edition;
            boolean bl2 = false;
            bl = it != Edition.FREE && isSavedJsmEditionFree;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void updateEdition(@NotNull CloudSite savedCloudSite, @NotNull SiteDetailsResponse currentSiteDetails) {
        Intrinsics.checkNotNullParameter((Object)savedCloudSite, (String)"savedCloudSite");
        Intrinsics.checkNotNullParameter((Object)currentSiteDetails, (String)"currentSiteDetails");
        Edition savedJsmEdition = this.getJsmEdition(this.getProducts(savedCloudSite));
        SiteDetailsWithCloudId currentSiteJsmDetails = (SiteDetailsWithCloudId)CollectionsKt.first(currentSiteDetails.getSites());
        Edition currentJsmEdition = this.getJsmEdition(currentSiteJsmDetails.getProducts());
        if (savedJsmEdition != currentJsmEdition) {
            Object v0;
            List listOfProducts;
            block3: {
                listOfProducts = CollectionsKt.toMutableList((Collection)this.getProducts(savedCloudSite));
                listOfProducts.removeIf(arg_0 -> JsmCloudFreeAgentLimitPreflightService.updateEdition$lambda$2(updateEdition.1.INSTANCE, arg_0));
                Iterable iterable = currentSiteJsmDetails.getProducts();
                for (Object t : iterable) {
                    TcsProductInfo it = (TcsProductInfo)t;
                    boolean bl = false;
                    if (!(it.getProductKey() == Product.JIRA_SERVICEDESK)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            TcsProductInfo tcsProductInfo = v0;
            if (tcsProductInfo != null) {
                TcsProductInfo it = tcsProductInfo;
                boolean bl = false;
                listOfProducts.add(it);
            }
            CloudSite $this$updateEdition_u24lambda_u245 = savedCloudSite;
            boolean bl = false;
            Edition edition = $this$updateEdition_u24lambda_u245.getCloudEdition();
            this.cloudSiteRepository.saveOrUpdate($this$updateEdition_u24lambda_u245.getCloudId(), $this$updateEdition_u24lambda_u245.getCloudUrl(), $this$updateEdition_u24lambda_u245.getContainerToken(), edition != null ? edition.getKey() : null, listOfProducts, $this$updateEdition_u24lambda_u245.getCloudType());
        }
    }

    private final String redirectLinkToUserManagement(CloudSite cloudSite2) {
        return cloudSite2.getCloudUrl() + "/admin/users";
    }

    private final Edition getJsmEdition(List<TcsProductInfo> $this$getJsmEdition) {
        Object v0;
        block1: {
            Iterable iterable = $this$getJsmEdition;
            for (Object t : iterable) {
                TcsProductInfo it = (TcsProductInfo)t;
                boolean bl = false;
                if (!(it.getProductKey() == Product.JIRA_SERVICEDESK)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        TcsProductInfo tcsProductInfo = v0;
        return tcsProductInfo != null ? tcsProductInfo.getEdition() : null;
    }

    private final List<TcsProductInfo> getProducts(CloudSite $this$getProducts) {
        Object object;
        block3: {
            block2: {
                object = $this$getProducts.getProductsJson();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                List list = (List)$this$readValue$iv.readValue(it, (TypeReference)new TypeReference<List<? extends TcsProductInfo>>(){});
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final boolean updateEdition$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

