/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.CloudFreeUserLimitPreflightService;
import com.atlassian.jira.migration.preflight.JiraProductInCloudRequestParams;
import com.atlassian.jira.migration.preflight.JiraProductsInCloudService;
import com.atlassian.jira.migration.preflight.JiraProductsInCloudSiteCheckService;
import com.atlassian.jira.migration.preflight.JswUmsProductMismatchService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0013H\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/preflight/JswInCloudSiteCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jiraProductsInCloudService", "Lcom/atlassian/jira/migration/preflight/JiraProductsInCloudService;", "jiraProductsInCloudSiteCheckService", "Lcom/atlassian/jira/migration/preflight/JiraProductsInCloudSiteCheckService;", "jiraProductsCloudFreeUserLimitPreflightService", "Lcom/atlassian/jira/migration/preflight/CloudFreeUserLimitPreflightService;", "umsProductMismatchService", "Lcom/atlassian/jira/migration/preflight/JswUmsProductMismatchService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/JiraProductsInCloudService;Lcom/atlassian/jira/migration/preflight/JiraProductsInCloudSiteCheckService;Lcom/atlassian/jira/migration/preflight/CloudFreeUserLimitPreflightService;Lcom/atlassian/jira/migration/preflight/JswUmsProductMismatchService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "Companion", "jira-migration-plugin"})
public final class JswInCloudSiteCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraProductsInCloudService jiraProductsInCloudService;
    @NotNull
    private final JiraProductsInCloudSiteCheckService jiraProductsInCloudSiteCheckService;
    @NotNull
    private final CloudFreeUserLimitPreflightService jiraProductsCloudFreeUserLimitPreflightService;
    @NotNull
    private final JswUmsProductMismatchService umsProductMismatchService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CheckType checkType;
    @NotNull
    public static final String JSW_STATUS_SUCCESS_DESCRIPTION = "Jira is available on your cloud site";
    @NotNull
    public static final String JSW_STATUS_RUNNING_DESCRIPTION = "Checking for Jira availability in cloud";
    @NotNull
    public static final String JSW_STATUS_FAILURE_DESCRIPTION = "Jira is not available on your cloud site";
    @NotNull
    public static final String JSW_STATUS_EXEC_ERROR_DESCRIPTION = "We couldn\u2019t check for Jira availability in cloud";

    @Inject
    public JswInCloudSiteCheck(@NotNull JiraProductsInCloudService jiraProductsInCloudService, @NotNull JiraProductsInCloudSiteCheckService jiraProductsInCloudSiteCheckService, @NotNull CloudFreeUserLimitPreflightService jiraProductsCloudFreeUserLimitPreflightService, @NotNull JswUmsProductMismatchService umsProductMismatchService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)jiraProductsInCloudService, (String)"jiraProductsInCloudService");
        Intrinsics.checkNotNullParameter((Object)jiraProductsInCloudSiteCheckService, (String)"jiraProductsInCloudSiteCheckService");
        Intrinsics.checkNotNullParameter((Object)jiraProductsCloudFreeUserLimitPreflightService, (String)"jiraProductsCloudFreeUserLimitPreflightService");
        Intrinsics.checkNotNullParameter((Object)umsProductMismatchService, (String)"umsProductMismatchService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.jiraProductsInCloudService = jiraProductsInCloudService;
        this.jiraProductsInCloudSiteCheckService = jiraProductsInCloudSiteCheckService;
        this.jiraProductsCloudFreeUserLimitPreflightService = jiraProductsCloudFreeUserLimitPreflightService;
        this.umsProductMismatchService = umsProductMismatchService;
        this.migrationFeatures = migrationFeatures;
        this.checkType = CheckType.JswInCloudSite;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.migrationFeatures.getSkipJswProductMismatchCheck() ? this.jiraProductsInCloudService.performCheck(checkRequest, new JiraProductInCloudRequestParams(this.jiraProductsCloudFreeUserLimitPreflightService, Product.JIRA_SOFTWARE, "software", "jira-software.ondemand")) : this.umsProductMismatchService.performCheck(checkRequest, new JiraProductInCloudRequestParams(this.jiraProductsCloudFreeUserLimitPreflightService, Product.JIRA_SOFTWARE, "software", "jira-software.ondemand"));
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"usersAndGroups", ctx.getUsersAndGroups()), TuplesKt.to((Object)"umsPreflightCheckDetails", (Object)ctx.getUmsPreflightCheckDetails()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    protected void inject(@Nullable CheckResultDto dto, @Nullable CheckResult checkResult) {
        CheckResultDto checkResultDto = dto;
        if (checkResultDto != null) {
            String string;
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    CheckResult checkResult2 = checkResult;
                    Intrinsics.checkNotNull((Object)checkResult2);
                    if (this.jiraProductsInCloudSiteCheckService.handleSuccess$jira_migration_plugin(dto, checkResult2)) {
                        string = JSW_STATUS_SUCCESS_DESCRIPTION;
                        break;
                    }
                    string = JSW_STATUS_FAILURE_DESCRIPTION;
                    break;
                }
                case 2: {
                    CheckResult checkResult3 = checkResult;
                    Intrinsics.checkNotNull((Object)checkResult3);
                    this.jiraProductsInCloudSiteCheckService.handleFailure$jira_migration_plugin(dto, checkResult3);
                    string = JSW_STATUS_FAILURE_DESCRIPTION;
                    break;
                }
                case 3: {
                    string = JSW_STATUS_RUNNING_DESCRIPTION;
                    break;
                }
                default: {
                    string = JSW_STATUS_EXEC_ERROR_DESCRIPTION;
                }
            }
            checkResultDto.setDescription(string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/JswInCloudSiteCheck$Companion;", "", "()V", "JSW_STATUS_EXEC_ERROR_DESCRIPTION", "", "JSW_STATUS_FAILURE_DESCRIPTION", "JSW_STATUS_RUNNING_DESCRIPTION", "JSW_STATUS_SUCCESS_DESCRIPTION", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

