/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ManualInterventionValidationResult;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ManualInterventionValidator;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ValidationStatus;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\rH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/preflight/ManualImportFileValidationCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "manualInterventionValidator", "Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getErrorMessage", "", "getFailedToRunMessage", "getRunningMessage", "getSuccessMessage", "getWarningMessage", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "Companion", "jira-migration-plugin"})
public final class ManualImportFileValidationCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ManualInterventionValidator manualInterventionValidator;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CheckType checkType;
    @NotNull
    public static final String CHECK_FILE_RUNNING_MESSAGE = "We're checking your import file";
    @NotNull
    public static final String CHECK_FILE_ERROR_MESSAGE = "Import file error";
    @NotNull
    public static final String CHECK_FILE_FAILED_TO_RUN_MESSAGE = "We couldn't check your import file";
    @NotNull
    public static final String CHECK_FILE_SUCCESSFUL_MESSAGE = "Import file is valid";
    @NotNull
    public static final String CHECK_FOLDER_RUNNING_MESSAGE = "We're checking your import folder";
    @NotNull
    public static final String CHECK_FOLDER_ERROR_MESSAGE = "Import folder error";
    @NotNull
    public static final String CHECK_FOLDER_WARNING_MESSAGE = "Files for import";
    @NotNull
    public static final String CHECK_FOLDER_FAILED_TO_RUN_MESSAGE = "We couldn't check your import folder";
    @NotNull
    public static final String CHECK_FOLDER_SUCCESSFUL_MESSAGE = "Import folder is valid";
    @NotNull
    public static final String VALIDATION_STATUS_KEY = "fileValidationStatus";
    @NotNull
    public static final String LOCATION_KEY = "location";

    @Inject
    public ManualImportFileValidationCheck(@NotNull ManualInterventionValidator manualInterventionValidator, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)manualInterventionValidator, (String)"manualInterventionValidator");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.manualInterventionValidator = manualInterventionValidator;
        this.migrationFeatures = migrationFeatures;
        this.checkType = CheckType.ManualImportFileValidation;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"manualImportFile", (Object)ctx.getManualImportFile()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        String string = PreflightCheckKt.getManualImportFile(checkRequest);
        if (string == null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)VALIDATION_STATUS_KEY, (Object)((Object)ValidationStatus.ERROR_NON_EXISTENT)), TuplesKt.to((Object)LOCATION_KEY, (Object)"")};
            return new CheckResult(false, MapsKt.mapOf((Pair[])pairArray));
        }
        String filePath = string;
        ManualInterventionValidationResult validationResult = this.manualInterventionValidator.validate(filePath);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)VALIDATION_STATUS_KEY, (Object)((Object)validationResult.getValidationStatus())), TuplesKt.to((Object)LOCATION_KEY, (Object)filePath)};
        Map details2 = MapsKt.mapOf((Pair[])pairArray);
        switch (WhenMappings.$EnumSwitchMapping$0[validationResult.getValidationStatus().ordinal()]) {
            case 1: 
            case 2: {
                checkResult = new CheckResult(true, details2);
                break;
            }
            default: {
                checkResult = new CheckResult(false, details2);
            }
        }
        return checkResult;
    }

    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block7: {
            String string;
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
                case 1: {
                    string = this.getRunningMessage();
                    break;
                }
                case 2: {
                    Object object = checkResult;
                    if ((object != null && (object = ((CheckResult)object).details) != null ? object.get(VALIDATION_STATUS_KEY) : null) == ValidationStatus.WARNING_MORE_THAN_ONE_FILE_TYPE) {
                        dto.setStatus(Status.WARNING);
                        string = this.getWarningMessage();
                        break;
                    }
                    string = this.getSuccessMessage();
                    break;
                }
                case 3: {
                    string = this.getWarningMessage();
                    break;
                }
                case 4: {
                    string = this.getErrorMessage();
                    break;
                }
                default: {
                    string = this.getFailedToRunMessage();
                }
            }
            dto.setDescription(string);
            CheckResult checkResult2 = checkResult;
            if (checkResult2 == null) break block7;
            CheckResult it = checkResult2;
            boolean bl = false;
            dto.setDetails(new CheckDetailsDto());
            dto.getDetails().setInfo(checkResult.details);
        }
    }

    private final String getRunningMessage() {
        return this.migrationFeatures.getEnableSinglePathLZ4MCS() ? CHECK_FOLDER_RUNNING_MESSAGE : CHECK_FILE_RUNNING_MESSAGE;
    }

    private final String getSuccessMessage() {
        return this.migrationFeatures.getEnableSinglePathLZ4MCS() ? CHECK_FOLDER_SUCCESSFUL_MESSAGE : CHECK_FILE_SUCCESSFUL_MESSAGE;
    }

    private final String getWarningMessage() {
        return this.migrationFeatures.getEnableSinglePathLZ4MCS() ? CHECK_FOLDER_WARNING_MESSAGE : CHECK_FILE_ERROR_MESSAGE;
    }

    private final String getErrorMessage() {
        return this.migrationFeatures.getEnableSinglePathLZ4MCS() ? CHECK_FOLDER_ERROR_MESSAGE : CHECK_FILE_ERROR_MESSAGE;
    }

    private final String getFailedToRunMessage() {
        return this.migrationFeatures.getEnableSinglePathLZ4MCS() ? CHECK_FOLDER_FAILED_TO_RUN_MESSAGE : CHECK_FILE_FAILED_TO_RUN_MESSAGE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/preflight/ManualImportFileValidationCheck$Companion;", "", "()V", "CHECK_FILE_ERROR_MESSAGE", "", "CHECK_FILE_FAILED_TO_RUN_MESSAGE", "CHECK_FILE_RUNNING_MESSAGE", "CHECK_FILE_SUCCESSFUL_MESSAGE", "CHECK_FOLDER_ERROR_MESSAGE", "CHECK_FOLDER_FAILED_TO_RUN_MESSAGE", "CHECK_FOLDER_RUNNING_MESSAGE", "CHECK_FOLDER_SUCCESSFUL_MESSAGE", "CHECK_FOLDER_WARNING_MESSAGE", "LOCATION_KEY", "VALIDATION_STATUS_KEY", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ValidationStatus.values().length];
            try {
                nArray[ValidationStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationStatus.WARNING_MORE_THAN_ONE_FILE_TYPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

