/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0014J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/MigrationHealthCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "result", "isAuthorizationCause", "", "exception", "", "performCheck", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
public final class MigrationHealthCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final CheckType checkType;
    private static final Logger log = LoggerFactory.getLogger(MigrationHealthCheck.class);

    @Inject
    public MigrationHealthCheck(@NotNull MigrationServiceClient migrationServiceClient) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        this.migrationServiceClient = migrationServiceClient;
        this.checkType = CheckType.MigrationOrchestratorMaintenance;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        try {
            boolean isInMaintenance = this.migrationServiceClient.isInMaintenance(PreflightCheckKt.getContainerToken(checkRequest));
            checkResult = new CheckResult(!isInMaintenance);
        }
        catch (RuntimeException e) {
            log.warn("HealthCheckEndpoint throws exception with message {} and cause {}", (Object)e.getMessage(), (Object)e.getCause());
            checkResult = this.isAuthorizationCause(e.getCause()) ? new CheckResult(true) : new CheckResult(false);
        }
        return checkResult;
    }

    private final boolean isAuthorizationCause(Throwable exception) {
        Throwable throwable = exception;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            if (it instanceof UnexpectedStatusCodeException) {
                return ((UnexpectedStatusCodeException)it).getStatusCode() == 401;
            }
        }
        return false;
    }

    protected void inject(@Nullable CheckResultDto dto, @Nullable CheckResult result2) {
        CheckResultDto checkResultDto = dto;
        if (checkResultDto != null) {
            String string;
            Status status = dto.getStatus();
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    dto.setStatus(Status.ERROR);
                    string = "We are currently updating the migration service";
                    break;
                }
                case 4: {
                    string = "Checking if the migration service is available";
                    break;
                }
                case 5: {
                    string = "The migration service is available";
                    break;
                }
                default: {
                    Status status2 = dto.getStatus();
                    string = "Check completed with status: " + (status2 != null ? status2.value() : null);
                }
            }
            checkResultDto.setDescription(string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/MigrationHealthCheck$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RUNNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

