/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.MissingAttachmentPreflightCheckKt;
import com.atlassian.jira.migration.preflight.MissingAttachmentPreflightService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.csv.MissingAttachmentCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.serverdataextractors.attachments.MissingAttachment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/preflight/MissingAttachmentPreflightCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "missingAttachmentPreflightService", "Lcom/atlassian/jira/migration/preflight/MissingAttachmentPreflightService;", "(Lcom/atlassian/jira/migration/preflight/MissingAttachmentPreflightService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMissingAttachmentPreflightCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingAttachmentPreflightCheck.kt\ncom/atlassian/jira/migration/preflight/MissingAttachmentPreflightCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1549#2:102\n1620#2,3:103\n*S KotlinDebug\n*F\n+ 1 MissingAttachmentPreflightCheck.kt\ncom/atlassian/jira/migration/preflight/MissingAttachmentPreflightCheck\n*L\n69#1:102\n69#1:103,3\n*E\n"})
public final class MissingAttachmentPreflightCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final MissingAttachmentPreflightService missingAttachmentPreflightService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public MissingAttachmentPreflightCheck(@NotNull MissingAttachmentPreflightService missingAttachmentPreflightService) {
        Intrinsics.checkNotNullParameter((Object)missingAttachmentPreflightService, (String)"missingAttachmentPreflightService");
        this.missingAttachmentPreflightService = missingAttachmentPreflightService;
        this.checkType = CheckType.MissingAttachments;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"dataFilterContext", (Object)ctx.getDataFilterContext())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.missingAttachmentPreflightService.performCheck(checkRequest);
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                string = "Checking all the attachments";
                break;
            }
            case 2: {
                string = "No missing attachments";
                break;
            }
            case 3: 
            case 4: {
                dto.setStatus(Status.ERROR);
                string = "Attachments missing from the selected projects";
                break;
            }
            case 5: {
                string = "We couldn\u2019t check for attachments";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        dto.setDescription(string);
        CheckResult checkResult2 = checkResult;
        if (checkResult2 != null) {
            List missingAttachments;
            CheckResult it = checkResult2;
            boolean bl = false;
            Object v = it.details.get("missingAttachments");
            List list = missingAttachments = v instanceof List ? (List)v : null;
            if (list != null) {
                List $this$inject_u24lambda_u241_u24lambda_u240 = list;
                boolean bl2 = false;
                CheckDetailsDto details2 = new CheckDetailsDto();
                dto.setNumberOfOccurrences(Integer.valueOf($this$inject_u24lambda_u241_u24lambda_u240.size()));
                dto.setDetails(details2);
            }
        }
        this.handleExtractionError(dto, checkResult, "Attachments missing from the selected projects");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        if (checkStatus.checkResult.success) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)MissingAttachmentPreflightCheckKt.getMISSING_ATTACHMENTS_HEADERS()));
        }
        var3_2 = checkStatus.checkResult.details.get("missingAttachments");
        v0 = missingAttachments = var3_2 instanceof List != false ? (List)var3_2 : null;
        if (missingAttachments == null) ** GOTO lbl-1000
        var5_4 /* !! */  = (String[])missingAttachments;
        $i$f$map = false;
        var7_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_11 = (MissingAttachment)item$iv$iv;
            var14_13 = destination$iv$iv;
            $i$a$-map-MissingAttachmentPreflightCheck$buildCSVMap$beanPermissions$1 = false;
            var14_13.add(new MissingAttachmentCSVData(it.getProjectKey(), it.getIssueId(), it.getAttachmentId(), it.getPath()));
        }
        var5_4 /* !! */  = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (var5_4 /* !! */  != null) {
            v1 /* !! */  = var5_4 /* !! */ ;
        } else lbl-1000:
        // 2 sources

        {
            v1 /* !! */  = CollectionsKt.emptyList();
        }
        beanPermissions = v1 /* !! */ ;
        var4_14 = new Pair[3];
        var4_14[0] = TuplesKt.to((Object)"headers", (Object)MissingAttachmentPreflightCheckKt.getMISSING_ATTACHMENTS_HEADERS());
        var5_4 /* !! */  = new String[]{"projectKey", "issueId", "attachmentId", "path"};
        var4_14[1] = TuplesKt.to((Object)"mappings", (Object)var5_4 /* !! */ );
        var4_14[2] = TuplesKt.to((Object)"beans", (Object)beanPermissions);
        return MapsKt.mapOf((Pair[])var4_14);
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return (planName != null && (string = planName + '-') != null ? string : "") + executionId + '-' + type.name() + "-result.csv";
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

