/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MissingAttachmentCheckEvent;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.serverdataextractors.attachments.JiraAttachmentsService;
import com.atlassian.jira.migration.serverdataextractors.attachments.MissingAttachment;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/preflight/MissingAttachmentPreflightService;", "", "attachmentsService", "Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
public final class MissingAttachmentPreflightService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraAttachmentsService attachmentsService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    public static final String MISSING_ATTACHMENTS_KEY = "missingAttachments";

    @Inject
    public MissingAttachmentPreflightService(@NotNull JiraAttachmentsService attachmentsService, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)attachmentsService, (String)"attachmentsService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.attachmentsService = attachmentsService;
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        List<String> projectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
        List results2 = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)projectKeys), (Function1)((Function1)new Function1<String, List<? extends MissingAttachment>>(this, checkRequest){
            final /* synthetic */ MissingAttachmentPreflightService this$0;
            final /* synthetic */ CheckRequest $checkRequest;
            {
                this.this$0 = $receiver;
                this.$checkRequest = $checkRequest;
                super(1);
            }

            @NotNull
            public final List<MissingAttachment> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MissingAttachmentPreflightService.access$getAttachmentsService$p(this.this$0).getMissingAttachmentsByProject(it, PreflightCheckKt.getDataFilterContext(this.$checkRequest), PreflightCheckKt.getProjectDataMigrationMode(this.$checkRequest));
            }
        })));
        CheckResult checkResult = new CheckResult(results2.isEmpty(), MapsKt.mapOf((Pair)TuplesKt.to((Object)MISSING_ATTACHMENTS_KEY, (Object)results2)));
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new MissingAttachmentCheckEvent(string, string2, (endTime - startTime) / (long)1000000, results2.isEmpty(), projectKeys.size(), ExportStatistics.Companion.getEMPTY(), results2.size()));
        return checkResult;
    }

    public static final /* synthetic */ JiraAttachmentsService access$getAttachmentsService$p(MissingAttachmentPreflightService $this) {
        return $this.attachmentsService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/preflight/MissingAttachmentPreflightService$Companion;", "", "()V", "MISSING_ATTACHMENTS_KEY", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

