/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.WhiteListCheckEvent;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.platform.EnterpriseGatewayClient;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.NotAccessibleResourceCheck;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.UrlAccessibilityCheckService;
import com.atlassian.jira.migration.preflight.WhiteListResourceService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.ConnectionStatusType;
import com.atlassian.jira.migration.preflight.model.MigrationAllowUrlName;
import com.atlassian.jira.migration.preflight.model.NetworkError;
import com.atlassian.jira.migration.preflight.model.ResourceDetail;
import com.atlassian.jira.migration.preflight.model.WhitelistUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0011H\u0016JF\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0014\u0010)\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/preflight/NotAccessibleResourceCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "urlAccessibilityCheckService", "Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService;", "whiteListResourceService", "Lcom/atlassian/jira/migration/preflight/WhiteListResourceService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "enterpriseGatewayClient", "Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;", "(Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService;Lcom/atlassian/jira/migration/preflight/WhiteListResourceService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "sendAnalyticEvent", "preflightCheckExecutionId", "", "uniqueId", "startTime", "", "endTime", "success", "", "numberOfUrls", "", "whitelistUrlList", "", "Lcom/atlassian/jira/migration/preflight/model/WhitelistUrl;", "handleFailedCheck", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nNotAccessibleResourceCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotAccessibleResourceCheck.kt\ncom/atlassian/jira/migration/preflight/NotAccessibleResourceCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1549#2:180\n1620#2,3:181\n1549#2:184\n1620#2,3:185\n1208#2,2:188\n1238#2,4:190\n*S KotlinDebug\n*F\n+ 1 NotAccessibleResourceCheck.kt\ncom/atlassian/jira/migration/preflight/NotAccessibleResourceCheck\n*L\n75#1:180\n75#1:181,3\n77#1:184\n77#1:185,3\n106#1:188,2\n106#1:190,4\n*E\n"})
public final class NotAccessibleResourceCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlAccessibilityCheckService urlAccessibilityCheckService;
    @NotNull
    private final WhiteListResourceService whiteListResourceService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final EnterpriseGatewayClient enterpriseGatewayClient;
    @NotNull
    private final CheckType checkType;
    private static final int ONE_MILLION = 1000000;
    private static final Logger log = LoggerFactory.getLogger(NotAccessibleResourceCheck.class);

    @Inject
    public NotAccessibleResourceCheck(@NotNull UrlAccessibilityCheckService urlAccessibilityCheckService, @NotNull WhiteListResourceService whiteListResourceService, @NotNull MigrationEventBus migrationEventBus, @NotNull EnterpriseGatewayClient enterpriseGatewayClient) {
        Intrinsics.checkNotNullParameter((Object)urlAccessibilityCheckService, (String)"urlAccessibilityCheckService");
        Intrinsics.checkNotNullParameter((Object)whiteListResourceService, (String)"whiteListResourceService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)enterpriseGatewayClient, (String)"enterpriseGatewayClient");
        this.urlAccessibilityCheckService = urlAccessibilityCheckService;
        this.whiteListResourceService = whiteListResourceService;
        this.migrationEventBus = migrationEventBus;
        this.enterpriseGatewayClient = enterpriseGatewayClient;
        this.checkType = CheckType.NotAccessibleResourcesType;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        if (dto.getStatus() == Status.EXECUTION_ERROR) {
            dto.setDescription("We couldn\u2019t check for authorization of URLs required for migration");
        } else {
            CheckResultDto checkResultDto;
            CheckResultDto $this$inject_u24lambda_u240 = checkResultDto = dto;
            boolean bl = false;
            $this$inject_u24lambda_u240.setCheckType("NotAccessibleResourcesType");
            CheckResult checkResult2 = checkResult;
            if ((checkResult2 != null ? Boolean.valueOf(checkResult2.success) : null) != null) {
                if (checkResult.details.isEmpty()) {
                    $this$inject_u24lambda_u240.setStatus(Status.SUCCESS);
                    $this$inject_u24lambda_u240.setDescription("All URLs required for migration are authorized");
                } else {
                    this.handleFailedCheck($this$inject_u24lambda_u240, checkResult);
                    $this$inject_u24lambda_u240.setDetails(new CheckDetailsDto());
                    $this$inject_u24lambda_u240.setNumberOfOccurrences(Integer.valueOf(checkResult.details.keySet().size()));
                    $this$inject_u24lambda_u240.getDetails().setListOfOccurrences(CollectionsKt.toList((Iterable)checkResult.details.values()));
                }
            } else {
                $this$inject_u24lambda_u240.setStatus(Status.RUNNING);
                $this$inject_u24lambda_u240.setDescription("Checking for authorization of URLs required for migration");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFailedCheck(CheckResultDto $this$handleFailedCheck, CheckResult checkResult) {
        try {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            ConnectionStatusType[] $this$map$iv = (ConnectionStatusType[])checkResult.details.values();
            boolean $i$f$map = false;
            ConnectionStatusType[] connectionStatusTypeArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Object t = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.preflight.model.ResourceDetail");
                collection.add((ResourceDetail)it);
            }
            List resourceDetails = (List)destination$iv$iv;
            boolean isBlocked = this.urlAccessibilityCheckService.checkForBlockingURL(resourceDetails);
            Iterable $this$map$iv2 = resourceDetails;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResourceDetail resourceDetail = (ResourceDetail)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getMessage());
            }
            List errors = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
            $this$handleFailedCheck.setStatus(isBlocked ? Status.ERROR : Status.WARNING);
            connectionStatusTypeArray = new ConnectionStatusType[]{ConnectionStatusType.PKIX, ConnectionStatusType.ERROR};
            $this$handleFailedCheck.setDescription(errors.containsAll(CollectionsKt.listOf((Object[])connectionStatusTypeArray)) ? NetworkError.DEFAULT.getMessage() : (errors.contains((Object)ConnectionStatusType.PKIX) ? NetworkError.PKIX.getMessage() : (errors.contains((Object)ConnectionStatusType.ERROR) ? NetworkError.GENERIC.getMessage() : "")));
        }
        catch (Throwable e) {
            $this$handleFailedCheck.setStatus(Status.WARNING);
            $this$handleFailedCheck.setDescription(NetworkError.DEFAULT.getMessage());
            log.error("Unexpected error while running NotAccessibleResourceCheck", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        try {
            CheckResult checkResult2;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            List<WhitelistUrl> whitelistUrls = this.whiteListResourceService.getWhitelistOfUrls(PreflightCheckKt.getContainerToken(checkRequest));
            Iterable<Object> iterable = whitelistUrls.parallelStream().map(arg_0 -> NotAccessibleResourceCheck.performCheck$lambda$3((Function1)new Function1<WhitelistUrl, UrlAccessibilityCheckService.ReachableResource>(this){
                final /* synthetic */ NotAccessibleResourceCheck this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final UrlAccessibilityCheckService.ReachableResource invoke(WhitelistUrl it) {
                    UrlAccessibilityCheckService urlAccessibilityCheckService = NotAccessibleResourceCheck.access$getUrlAccessibilityCheckService$p(this.this$0);
                    Intrinsics.checkNotNull((Object)it);
                    return urlAccessibilityCheckService.checkResource(it);
                }
            }, arg_0)).filter(arg_0 -> NotAccessibleResourceCheck.performCheck$lambda$4(performCheck.notReachableResources.2.INSTANCE, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"collect(...)");
            iterable = iterable;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var9_10 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                UrlAccessibilityCheckService.ReachableResource reachableResource = (UrlAccessibilityCheckService.ReachableResource)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                UrlAccessibilityCheckService.ReachableResource it = (UrlAccessibilityCheckService.ReachableResource)element$iv$iv;
                WhitelistUrl whitelistUrl = new WhitelistUrl(it.getMigrationAllowUrlName(), it.getUrl());
                boolean bl2 = false;
                ResourceDetail resourceDetail = new ResourceDetail(it.getUrl(), it.isBlocking(), it.isReachable().getType());
                map.put(whitelistUrl, resourceDetail);
            }
            Map notReachableResources2 = MapsKt.toMutableMap((Map)destination$iv$iv);
            boolean success = !this.urlAccessibilityCheckService.checkForBlockingURL(notReachableResources2.values());
            long endTime = System.nanoTime();
            String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
            String string2 = PreflightCheckKt.getUniqueId(checkRequest);
            if (string2 == null) {
                string2 = "";
            }
            this.sendAnalyticEvent(string, string2, startTime, endTime, success, notReachableResources2.size(), notReachableResources2.keySet());
            boolean bl = notReachableResources2.isEmpty();
            if (bl) {
                checkResult2 = new CheckResult(success, MapsKt.emptyMap());
            } else if (!bl) {
                checkResult2 = new CheckResult(success, this.urlAccessibilityCheckService.replaceUrlsWithWildcards(notReachableResources2));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            checkResult = checkResult2;
        }
        catch (UnexpectedStatusCodeException ex) {
            log.warn("Error happened during getting IP whitelist", (Throwable)ex);
            long endTime = System.nanoTime();
            String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
            String string3 = PreflightCheckKt.getUniqueId(checkRequest);
            if (string3 == null) {
                string3 = "";
            }
            this.sendAnalyticEvent(string, string3, startTime, endTime, false, 1, SetsKt.setOf((Object)new WhitelistUrl(MigrationAllowUrlName.MIGRATION_CATALOG_SERVICE, this.enterpriseGatewayClient.getEnterpriseGatewayBaseURI())));
            checkResult = new CheckResult(false, MapsKt.mapOf((Pair)new Pair((Object)this.enterpriseGatewayClient.getEnterpriseGatewayBaseURI(), (Object)false)));
        }
        return checkResult;
    }

    private final void sendAnalyticEvent(String preflightCheckExecutionId, String uniqueId, long startTime, long endTime, boolean success, int numberOfUrls, Set<WhitelistUrl> whitelistUrlList) {
        this.migrationEventBus.post(new WhiteListCheckEvent(preflightCheckExecutionId, uniqueId, (endTime - startTime) / (long)1000000, success, ExportStatistics.Companion.getEMPTY(), numberOfUrls, whitelistUrlList));
    }

    private static final UrlAccessibilityCheckService.ReachableResource performCheck$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UrlAccessibilityCheckService.ReachableResource)$tmp0.invoke(p0);
    }

    private static final boolean performCheck$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ UrlAccessibilityCheckService access$getUrlAccessibilityCheckService$p(NotAccessibleResourceCheck $this) {
        return $this.urlAccessibilityCheckService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/NotAccessibleResourceCheck$Companion;", "", "()V", "ONE_MILLION", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

