/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "executionErrorMessage", "", "runningMessage", "successMessage", "warningMessage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jira-migration-plugin"})
public abstract class NotBlockingCheck
extends PreflightCheck<NotBlockingCheckResult> {
    @NotNull
    private final String executionErrorMessage;
    @NotNull
    private final String runningMessage;
    @NotNull
    private final String successMessage;
    @NotNull
    private final String warningMessage;

    public NotBlockingCheck(@NotNull String executionErrorMessage, @NotNull String runningMessage, @NotNull String successMessage, @NotNull String warningMessage) {
        Intrinsics.checkNotNullParameter((Object)executionErrorMessage, (String)"executionErrorMessage");
        Intrinsics.checkNotNullParameter((Object)runningMessage, (String)"runningMessage");
        Intrinsics.checkNotNullParameter((Object)successMessage, (String)"successMessage");
        Intrinsics.checkNotNullParameter((Object)warningMessage, (String)"warningMessage");
        this.executionErrorMessage = executionErrorMessage;
        this.runningMessage = runningMessage;
        this.successMessage = successMessage;
        this.warningMessage = warningMessage;
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                string = this.runningMessage;
                break;
            }
            case 2: {
                string = this.executionErrorMessage;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (checkResult instanceof NotBlockingCheckResult && ((NotBlockingCheckResult)checkResult).getHasWarnings()) {
                    dto.setStatus(Status.WARNING);
                    string = this.warningMessage;
                    break;
                }
                dto.setStatus(Status.SUCCESS);
                string = this.successMessage;
                break;
            }
            default: {
                string = "Unknown status " + dto.getStatus();
            }
        }
        dto.setDescription(string);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

