/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.email.EmailConfigService;
import com.atlassian.jira.migration.email.EmailConfigServiceKt;
import com.atlassian.jira.migration.email.ExpelledUserService;
import com.atlassian.jira.migration.email.IncorrectEmailAtomicMutateService;
import com.atlassian.jira.migration.email.model.AtomicMutateResult;
import com.atlassian.jira.migration.email.model.ExpelledUser;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraUserKeyService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.utils.EmailValidityCheckerUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J4\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J&\u0010 \u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ<\u0010!\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J.\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J.\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020&0\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u001eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/preflight/PerMigrationUnsupportedUserHandler;", "", "expelledUserService", "Lcom/atlassian/jira/migration/email/ExpelledUserService;", "jiraUserKeyService", "Lcom/atlassian/jira/migration/jiraservice/JiraUserKeyService;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "directoryManager", "Lcom/atlassian/crowd/manager/directory/DirectoryManager;", "emailConfigService", "Lcom/atlassian/jira/migration/email/EmailConfigService;", "incorrectEmailAtomicMutateService", "Lcom/atlassian/jira/migration/email/IncorrectEmailAtomicMutateService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/email/ExpelledUserService;Lcom/atlassian/jira/migration/jiraservice/JiraUserKeyService;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/crowd/manager/directory/DirectoryManager;Lcom/atlassian/jira/migration/email/EmailConfigService;Lcom/atlassian/jira/migration/email/IncorrectEmailAtomicMutateService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "dropDuplicateEmailsForMergeUsingCutOffDate", "Lcom/atlassian/cmpt/check/base/CheckResult;", "users", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "executionId", "", "checkResult", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getLastLoginMillis", "", "applicationUser", "redirectInvalidEmailsForTombstoneUsingCutOffDate", "saveIncorrectEmailUsersForCorrection", "userForPreflightResult", "Lcom/atlassian/cmpt/check/email/EmailDuplicate;", "saveInvalidEmailUsersForCorrection", "invalidEmailsToBeCorrected", "Lcom/atlassian/cmpt/check/email/EmailData;", "saveUnsupportedEmails", "", "emails", "shouldDropIfDuplicateEmailUsersNeverLogAfterCutOffDate", "", "duplicateEmails", "cutOfMillis", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPerMigrationUnsupportedUserHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerMigrationUnsupportedUserHandler.kt\ncom/atlassian/jira/migration/preflight/PerMigrationUnsupportedUserHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n3190#2,10:169\n1179#2,2:179\n1253#2,4:181\n1603#2,9:185\n1855#2:194\n1856#2:196\n1612#2:197\n1549#2:198\n1620#2,3:199\n1603#2,9:203\n1855#2:212\n1856#2:214\n1612#2:215\n3190#2,10:216\n1549#2:226\n1620#2,3:227\n1549#2:230\n1620#2,3:231\n1549#2:234\n1620#2,3:235\n1603#2,9:238\n1855#2:247\n1856#2:250\n1612#2:251\n1549#2:252\n1620#2,3:253\n1655#2,8:256\n1#3:195\n1#3:202\n1#3:213\n1#3:248\n1#3:249\n*S KotlinDebug\n*F\n+ 1 PerMigrationUnsupportedUserHandler.kt\ncom/atlassian/jira/migration/preflight/PerMigrationUnsupportedUserHandler\n*L\n47#1:169,10\n77#1:179,2\n77#1:181,4\n91#1:185,9\n91#1:194\n91#1:196\n91#1:197\n92#1:198\n92#1:199,3\n110#1:203,9\n110#1:212\n110#1:214\n110#1:215\n111#1:216,10\n114#1:226\n114#1:227,3\n119#1:230\n119#1:231,3\n153#1:234\n153#1:235,3\n154#1:238,9\n154#1:247\n154#1:250\n154#1:251\n155#1:252\n155#1:253,3\n156#1:256,8\n91#1:195\n110#1:213\n154#1:249\n*E\n"})
public final class PerMigrationUnsupportedUserHandler {
    @NotNull
    private final ExpelledUserService expelledUserService;
    @NotNull
    private final JiraUserKeyService jiraUserKeyService;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final DirectoryManager directoryManager;
    @NotNull
    private final EmailConfigService emailConfigService;
    @NotNull
    private final IncorrectEmailAtomicMutateService incorrectEmailAtomicMutateService;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public PerMigrationUnsupportedUserHandler(@NotNull ExpelledUserService expelledUserService, @NotNull JiraUserKeyService jiraUserKeyService, @NotNull UserManager userManager, @NotNull DirectoryManager directoryManager, @NotNull EmailConfigService emailConfigService, @NotNull IncorrectEmailAtomicMutateService incorrectEmailAtomicMutateService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)expelledUserService, (String)"expelledUserService");
        Intrinsics.checkNotNullParameter((Object)jiraUserKeyService, (String)"jiraUserKeyService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)directoryManager, (String)"directoryManager");
        Intrinsics.checkNotNullParameter((Object)emailConfigService, (String)"emailConfigService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailAtomicMutateService, (String)"incorrectEmailAtomicMutateService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.expelledUserService = expelledUserService;
        this.jiraUserKeyService = jiraUserKeyService;
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.emailConfigService = emailConfigService;
        this.incorrectEmailAtomicMutateService = incorrectEmailAtomicMutateService;
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult dropDuplicateEmailsForMergeUsingCutOffDate(@NotNull List<JiraUser> users2, @NotNull String executionId, @NotNull CheckResult checkResult, @NotNull ApplicationUser user, @NotNull CheckType checkType) {
        CheckResult checkResult2;
        Intrinsics.checkNotNullParameter(users2, (String)"users");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)checkResult, (String)"checkResult");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        List emailsToDupUserNames = EmailDuplicateChecker.retrieveEmailDuplicates((Map)checkResult.details);
        Intrinsics.checkNotNull((Object)emailsToDupUserNames);
        if (!((Collection)emailsToDupUserNames).isEmpty() && this.migrationFeatures.getEnableSpecialEmailCorrectionFeature()) {
            void $this$partition$iv;
            Iterable iterable = emailsToDupUserNames;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                EmailDuplicate it = (EmailDuplicate)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (this.shouldDropIfDuplicateEmailUsersNeverLogAfterCutOffDate(it, this.emailConfigService.getCutOffMillisForMergeDuplicateEmails())) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List userForMerging = (List)pair.component1();
            List userForPreflightResult = (List)pair.component2();
            CheckResult it = this.saveIncorrectEmailUsersForCorrection(users2, executionId, userForPreflightResult, user, checkType);
            boolean bl = false;
            boolean bl2 = it.success;
            Map map = it.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"mergeDuplicatedUsers", (Object)true), TuplesKt.to((Object)"numberOfMergedUsers", (Object)userForMerging.size())};
            CheckResult checkResult3 = new CheckResult(bl2, MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair[])pairArray)));
            checkResult2 = checkResult3;
        } else {
            checkResult2 = checkResult;
        }
        return checkResult2;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckResult saveIncorrectEmailUsersForCorrection(List<JiraUser> users2, String executionId, List<? extends EmailDuplicate> userForPreflightResult, ApplicationUser user, CheckType checkType) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable iterable = users2;
        IncorrectEmailAtomicMutateService incorrectEmailAtomicMutateService = this.incorrectEmailAtomicMutateService;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var10_10 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            JiraUser it = (JiraUser)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getUserName(), (Object)it.getEmail());
            map.put(pair.getFirst(), pair.getSecond());
        }
        AtomicMutateResult res = incorrectEmailAtomicMutateService.deleteAndUpsertDuplicateEmails(destination$iv$iv, executionId, userForPreflightResult, user, checkType, MigrationScopeContext.Companion.getEMPTY());
        if (!(res instanceof AtomicMutateResult.Success)) {
            if (res instanceof AtomicMutateResult.Failed) {
                throw ((AtomicMutateResult.Failed)res).getError();
            }
            throw new NoWhenBranchMatchedException();
        }
        return new CheckResult(userForPreflightResult.isEmpty(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"violations", userForPreflightResult)));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldDropIfDuplicateEmailUsersNeverLogAfterCutOffDate(EmailDuplicate duplicateEmails, long cutOfMillis) {
        boolean bl;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        List list = duplicateEmails.ids;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ids");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ApplicationUser applicationUser = $this$forEach$iv$iv$iv.iterator();
        while (applicationUser.hasNext()) {
            ApplicationUser it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = applicationUser.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (this.userManager.getUserByName(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            applicationUser = (ApplicationUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(this.getLastLoginMillis((ApplicationUser)p0));
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        if (l != null) {
            long lastLoggedTime = ((Number)l).longValue();
            boolean bl6 = false;
            bl = lastLoggedTime < cutOfMillis;
        } else {
            bl = false;
        }
        return bl;
    }

    private final long getLastLoginMillis(ApplicationUser applicationUser) {
        String string = this.directoryManager.findUserWithAttributesByName(applicationUser.getDirectoryId(), applicationUser.getUsername()).getValue("login.lastLoginMillis");
        return string != null ? Long.parseLong(string) : EmailConfigServiceKt.neverLogInMillis();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult redirectInvalidEmailsForTombstoneUsingCutOffDate(@NotNull String executionId, @NotNull CheckResult checkResult, @NotNull ApplicationUser user, @NotNull CheckType checkType) {
        CheckResult checkResult2;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)checkResult, (String)"checkResult");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        List invalidEmails = EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map);
        if (!((Collection)invalidEmails).isEmpty() && this.migrationFeatures.getEnableSpecialEmailCorrectionFeature()) {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            void $this$partition$iv;
            Object element$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Iterable iterable = invalidEmails;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ApplicationUser it$iv$iv;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                EmailData emailData = (EmailData)element$iv$iv;
                boolean bl2 = false;
                if (this.userManager.getUserByName(emailData.id) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$partition = false;
            Iterable first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                ApplicationUser it = (ApplicationUser)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (this.getLastLoginMillis(it) < this.emailConfigService.getCutOffMillisForTombstoneInvalidEmails()) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List usersForTombstoning = (List)pair.component1();
            List userForPreflightResult = (List)pair.component2();
            first$iv = usersForTombstoning;
            Object object = this;
            boolean $i$f$map = false;
            Iterator $i$f$mapNotNullTo22 = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                element$iv$iv = (ApplicationUser)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(new EmailData(it.getUsername(), it.getEmailAddress()));
            }
            ((PerMigrationUnsupportedUserHandler)object).saveUnsupportedEmails((List)destination$iv$iv2, executionId, user, checkType);
            Iterable $this$map$iv2 = userForPreflightResult;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ApplicationUser bl = (ApplicationUser)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl4 = false;
                object.add(new EmailData(it.getUsername(), it.getEmailAddress()));
            }
            List invalidEmailsToBeCorrected = (List)destination$iv$iv3;
            CheckResult it = this.saveInvalidEmailUsersForCorrection(executionId, invalidEmailsToBeCorrected, user, checkType);
            boolean bl = false;
            boolean bl5 = it.success;
            Map map2 = it.details;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"details");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"tombstonedInvalidUsers", (Object)true), TuplesKt.to((Object)"numberOfTombstonedUsers", (Object)usersForTombstoning.size())};
            CheckResult checkResult3 = new CheckResult(bl5, MapsKt.plus((Map)map2, (Map)MapsKt.mapOf((Pair[])pairArray)));
            checkResult2 = checkResult3;
        } else {
            checkResult2 = checkResult;
        }
        return checkResult2;
    }

    private final CheckResult saveInvalidEmailUsersForCorrection(String executionId, List<? extends EmailData> invalidEmailsToBeCorrected, ApplicationUser user, CheckType checkType) {
        AtomicMutateResult res = this.incorrectEmailAtomicMutateService.deleteAndUpsertInvalidEmails(executionId, invalidEmailsToBeCorrected, user, checkType, MigrationScopeContext.Companion.getEMPTY());
        if (!(res instanceof AtomicMutateResult.Success)) {
            if (res instanceof AtomicMutateResult.Failed) {
                throw ((AtomicMutateResult.Failed)res).getError();
            }
            throw new NoWhenBranchMatchedException();
        }
        return new CheckResult(invalidEmailsToBeCorrected.isEmpty(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"violations", invalidEmailsToBeCorrected)));
    }

    /*
     * WARNING - void declaration
     */
    private final void saveUnsupportedEmails(List<? extends EmailData> emails, String executionId, ApplicationUser user, CheckType checkType) {
        void $this$distinctBy$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Pair it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = emails;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EmailData emailData = (EmailData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
            collection.add(TuplesKt.to((Object)this.jiraUserKeyService.getKeyForUsername(string), (Object)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Pair pair2 = (Pair)element$iv$iv;
            boolean bl2 = false;
            String userKey = (String)pair2.component1();
            EmailData emailData = (EmailData)pair2.component2();
            if (userKey != null) {
                String it2;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)it2, (Object)emailData);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String userKey = (String)it.component1();
            EmailData emailData = (EmailData)it.component2();
            collection.add(new ExpelledUser(userKey, emailData.email, executionId));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ExpelledUser it3 = (ExpelledUser)e$iv;
            boolean bl = false;
            String key$iv = it3.getUserKey();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List it4 = list$iv;
        boolean bl = false;
        this.expelledUserService.deleteAllByExecutionIdAndPreflightCheckTypeAndInsert(it4, executionId, user, checkType);
    }
}

