/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.PreMigrationCheckOutcomeEntity;
import com.atlassian.jira.migration.preflight.model.CheckType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\fJ0\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/preflight/PreMigrationCheckOutcomeRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "checkTypeValues", "", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "[Lcom/atlassian/jira/migration/preflight/model/CheckType;", "cleanUpStaleResultsAndUpsertNewPreflightCheckResult", "", "checkId", "", "lastExecutedTime", "", "phaseId", "preflightCheckExecutionId", "", "cloudId", "cleanupOldRecords", "createPreflightCheckRecord", "deletePreflightCheckByExecutionId", "deletePreflightCheckResults", "findPreflightCheck", "Lcom/atlassian/jira/migration/preflight/PreMigrationCheckOutcomeEntity;", "isTtlExpired", "", "Companion", "jira-migration-plugin"})
public final class PreMigrationCheckOutcomeRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CheckType[] checkTypeValues;
    private static final Logger log = LoggerFactory.getLogger(PreMigrationCheckOutcomeRepository.class);
    private static final long TTL_TWELVE_HOURS_MS = 43200000L;
    private static final long TTL_THREE_HOURS_MS = 10800000L;
    private static final long TTL_ONE_DAY_MS = 86400000L;
    private static final long TTL_FIVE_DAYS_MS = 432000000L;
    private static final long TTL_FIFTEEN_DAYS_MS = 1296000000L;
    private static final long OUTDATED_RESULTS_TIMESTAMP = 2592000000L;

    @Inject
    public PreMigrationCheckOutcomeRepository(@NotNull ActiveObjects ao, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.ao = ao;
        this.migrationFeatures = migrationFeatures;
        this.checkTypeValues = CheckType.values();
    }

    public final void cleanUpStaleResultsAndUpsertNewPreflightCheckResult(int checkId, long lastExecutedTime, int phaseId, @NotNull String preflightCheckExecutionId, @NotNull String cloudId2) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            this.cleanupOldRecords();
            PreMigrationCheckOutcomeEntity preMigrationCheckOutcomeEntity = this.findPreflightCheck(preflightCheckExecutionId, checkId);
            if (preMigrationCheckOutcomeEntity != null) {
                PreMigrationCheckOutcomeEntity it = preMigrationCheckOutcomeEntity;
                boolean bl = false;
                log.debug("Updating preflight check outcome: check =" + (Object)((Object)this.checkTypeValues[checkId]) + ", preflightCheckExecutionId=" + preflightCheckExecutionId);
                it.setLastExecutionTime(lastExecutedTime);
                it.setPhaseId(phaseId);
                it.setPreflightCheckExecutionId(preflightCheckExecutionId);
                it.setCloudId(cloudId2);
                it.save();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            PreMigrationCheckOutcomeRepository $this$cleanUpStaleResultsAndUpsertNewPreflightCheckResult_u24lambda_u241 = this;
            boolean bl = false;
            log.debug("Inserting new preflight check outcome: check=" + (Object)((Object)$this$cleanUpStaleResultsAndUpsertNewPreflightCheckResult_u24lambda_u241.checkTypeValues[checkId]) + ", preflightCheckExecutionId=" + preflightCheckExecutionId);
            $this$cleanUpStaleResultsAndUpsertNewPreflightCheckResult_u24lambda_u241.createPreflightCheckRecord(checkId, lastExecutedTime, phaseId, preflightCheckExecutionId, cloudId2);
        }
    }

    private final void createPreflightCheckRecord(int checkId, long lastExecutedTime, int phaseId, String preflightCheckExecutionId, String cloudId2) {
        log.info("Inserting preflight check entry: check=" + (Object)((Object)this.checkTypeValues[checkId]) + ", preflightCheckExecutionId=" + preflightCheckExecutionId);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CHECK_ID", (Object)checkId), TuplesKt.to((Object)"LAST_EXECUTION_TIME", (Object)lastExecutedTime), TuplesKt.to((Object)"PHASE_ID", (Object)phaseId), TuplesKt.to((Object)"PREFLIGHT_CHECK_EXECUTION_ID", (Object)preflightCheckExecutionId), TuplesKt.to((Object)"CLOUD_ID", (Object)cloudId2)};
        this.ao.create(PreMigrationCheckOutcomeEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    public final void cleanupOldRecords() {
        long timestamp = System.currentTimeMillis() - 2592000000L;
        Object[] objectArray = new Object[]{timestamp};
        this.ao.deleteWithSQL(PreMigrationCheckOutcomeEntity.class, "LAST_EXECUTION_TIME < ?", objectArray);
        long outdatedResultsTimestampInDays = 30L;
        log.info("Cleanup task run: Older than " + outdatedResultsTimestampInDays + " days records were deleted");
    }

    public final void deletePreflightCheckResults(@NotNull String preflightCheckExecutionId, int checkId) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Object[] objectArray = new Object[]{preflightCheckExecutionId, checkId};
        this.ao.deleteWithSQL(PreMigrationCheckOutcomeEntity.class, "PREFLIGHT_CHECK_EXECUTION_ID = ? AND CHECK_ID = ?", objectArray);
    }

    public final void deletePreflightCheckByExecutionId(@NotNull String preflightCheckExecutionId) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Object[] objectArray = new Object[]{preflightCheckExecutionId};
        this.ao.deleteWithSQL(PreMigrationCheckOutcomeEntity.class, "PREFLIGHT_CHECK_EXECUTION_ID = ?", objectArray);
    }

    @Nullable
    public final PreMigrationCheckOutcomeEntity findPreflightCheck(@NotNull String preflightCheckExecutionId, int checkId) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Object[] objectArray = new Object[]{preflightCheckExecutionId, checkId};
        RawEntity[] rawEntityArray = this.ao.find(PreMigrationCheckOutcomeEntity.class, Query.select().where("PREFLIGHT_CHECK_EXECUTION_ID = ? AND CHECK_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (PreMigrationCheckOutcomeEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    public final boolean isTtlExpired(@NotNull String preflightCheckExecutionId, int checkId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        long currentTimeMillis = System.currentTimeMillis();
        PreMigrationCheckOutcomeEntity preflightCheckResult = this.findPreflightCheck(preflightCheckExecutionId, checkId);
        long ttl = CheckType.Companion.isScopedUsersAndGroupsPreflightCheckType(CheckType.values()[checkId].toString()) ? 10800000L : (this.migrationFeatures.getEnableHighTTLForPreflightCheckResultCaching() ? 1296000000L : (this.migrationFeatures.getEnableMediumTTLForPreflightCheckResultCaching() ? 432000000L : 43200000L));
        PreMigrationCheckOutcomeEntity preMigrationCheckOutcomeEntity = preflightCheckResult;
        if (preMigrationCheckOutcomeEntity != null) {
            PreMigrationCheckOutcomeEntity it = preMigrationCheckOutcomeEntity;
            boolean bl2 = false;
            boolean isExpired = it.getLastExecutionTime() + ttl <= currentTimeMillis;
            log.info("TTL for check " + (Object)((Object)this.checkTypeValues[checkId]) + ": Expired=" + isExpired);
            bl = isExpired;
        } else {
            PreMigrationCheckOutcomeRepository $this$isTtlExpired_u24lambda_u243 = this;
            boolean bl3 = false;
            log.info("TTL for check " + (Object)((Object)$this$isTtlExpired_u24lambda_u243.checkTypeValues[checkId]) + ": No check result found, returning Expired=true");
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/preflight/PreMigrationCheckOutcomeRepository$Companion;", "", "()V", "OUTDATED_RESULTS_TIMESTAMP", "", "TTL_FIFTEEN_DAYS_MS", "TTL_FIVE_DAYS_MS", "TTL_ONE_DAY_MS", "TTL_THREE_HOURS_MS", "TTL_TWELVE_HOURS_MS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

