/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.jira.migration.preflight.CheckStatusConverter;
import com.atlassian.jira.migration.preflight.PreflightCheckStatus;
import com.atlassian.jira.migration.preflight.PreflightCheckTable;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightCheckRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "fromTupleToPreflightCheckStatus", "Lcom/atlassian/jira/migration/preflight/PreflightCheckStatus;", "tuple", "Lcom/querydsl/core/Tuple;", "get", "preflightId", "", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getByExecutionId", "executionId", "save", "", "check", "update", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightCheckRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightCheckRepository.kt\ncom/atlassian/jira/migration/preflight/PreflightCheckRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1#2:293\n*E\n"})
public final class PreflightCheckRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public PreflightCheckRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    public final void save(@NotNull PreflightCheckStatus check) {
        Intrinsics.checkNotNullParameter((Object)check, (String)"check");
        this.databaseAccessor.run(arg_0 -> PreflightCheckRepository.save$lambda$0(check, arg_0), PreflightCheckRepository::save$lambda$1);
    }

    public final void update(@NotNull PreflightCheckStatus check) {
        Intrinsics.checkNotNullParameter((Object)check, (String)"check");
        this.databaseAccessor.run(arg_0 -> PreflightCheckRepository.update$lambda$2(check, arg_0), OnRollback.NOOP);
    }

    @Nullable
    public final PreflightCheckStatus get(@NotNull String preflightId, @NotNull CheckType checkType) {
        Intrinsics.checkNotNullParameter((Object)preflightId, (String)"preflightId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        return (PreflightCheckStatus)this.databaseAccessor.run(arg_0 -> PreflightCheckRepository.get$lambda$4(preflightId, checkType, this, arg_0), PreflightCheckRepository::get$lambda$5);
    }

    @Nullable
    public final PreflightCheckStatus getByExecutionId(@NotNull String executionId, @NotNull CheckType checkType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        return (PreflightCheckStatus)this.databaseAccessor.run(arg_0 -> PreflightCheckRepository.getByExecutionId$lambda$7(executionId, checkType, this, arg_0), PreflightCheckRepository::getByExecutionId$lambda$8);
    }

    private final PreflightCheckStatus fromTupleToPreflightCheckStatus(Tuple tuple) {
        Object object = tuple.get((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCHECK_ID());
        Intrinsics.checkNotNull((Object)object);
        String string = (String)object;
        Object object2 = tuple.get((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getPREFLIGHT_ID());
        Intrinsics.checkNotNull((Object)object2);
        String string2 = (String)object2;
        Object object3 = tuple.get((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getEXECUTION_ID());
        Intrinsics.checkNotNull((Object)object3);
        String string3 = (String)object3;
        Object object4 = tuple.get((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCHECK_TYPE());
        Intrinsics.checkNotNull((Object)object4);
        CheckType checkType = CheckType.Companion.fromString((String)object4);
        Object object5 = tuple.get((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getSTATUS());
        Intrinsics.checkNotNull((Object)object5);
        CheckStatus checkStatus = CheckStatusConverter.INSTANCE.deserialize(((String)object5).toString());
        Object object6 = tuple.get((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCREATED_AT());
        Intrinsics.checkNotNull((Object)object6);
        long l = ((Number)object6).longValue();
        Object object7 = tuple.get((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getUPDATED_AT());
        Intrinsics.checkNotNull((Object)object7);
        return new PreflightCheckStatus(string, string2, string3, checkType, checkStatus, l, ((Number)object7).longValue());
    }

    private static final Long save$lambda$0(PreflightCheckStatus $check, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$check, (String)"$check");
        return db.insert((RelationalPath)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE()).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCHECK_ID(), (Object)$check.getCheckId()).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getPREFLIGHT_ID(), (Object)$check.getPreflightId()).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getEXECUTION_ID(), (Object)$check.getExecutionId()).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCHECK_TYPE(), (Object)$check.getCheckType().toString()).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getSTATUS(), (Object)CheckStatusConverter.INSTANCE.serialize($check.getStatus())).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCREATED_AT(), (Object)$check.getCreatedAt()).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getUPDATED_AT(), (Object)$check.getUpdatedAt()).execute();
    }

    private static final void save$lambda$1() {
    }

    private static final Long update$lambda$2(PreflightCheckStatus $check, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$check, (String)"$check");
        return db.update((RelationalPath)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE()).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getSTATUS(), (Object)CheckStatusConverter.INSTANCE.serialize($check.getStatus())).set((Path)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getUPDATED_AT(), (Object)Instant.now().toEpochMilli()).where((Predicate)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getPREFLIGHT_ID().eq((Object)$check.getPreflightId()).and((Predicate)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCHECK_TYPE().eq((Object)$check.getCheckType().toString()))).execute();
    }

    private static final PreflightCheckStatus get$lambda$4(String $preflightId, CheckType $checkType, PreflightCheckRepository this$0, DatabaseConnection db) {
        PreflightCheckStatus preflightCheckStatus;
        Intrinsics.checkNotNullParameter((Object)$preflightId, (String)"$preflightId");
        Intrinsics.checkNotNullParameter((Object)((Object)$checkType), (String)"$checkType");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().all();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE())).where((Predicate)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getPREFLIGHT_ID().eq((Object)$preflightId).and((Predicate)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCHECK_TYPE().eq((Object)$checkType.toString())))).fetchOne();
        if (tuple != null) {
            Tuple tuple2 = tuple;
            boolean bl = false;
            preflightCheckStatus = this$0.fromTupleToPreflightCheckStatus(tuple2);
        } else {
            preflightCheckStatus = null;
        }
        return preflightCheckStatus;
    }

    private static final void get$lambda$5() {
    }

    private static final PreflightCheckStatus getByExecutionId$lambda$7(String $executionId, CheckType $checkType, PreflightCheckRepository this$0, DatabaseConnection db) {
        PreflightCheckStatus preflightCheckStatus;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)$checkType), (String)"$checkType");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().all();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE())).where((Predicate)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getEXECUTION_ID().eq((Object)$executionId).and((Predicate)PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getCHECK_TYPE().eq((Object)$checkType.toString())))).orderBy(PreflightCheckTable.Companion.getMIG_PREFLIGHT_CHECK_TABLE().getUPDATED_AT().desc())).limit(1L)).fetchFirst();
        if (tuple != null) {
            Tuple tuple2 = tuple;
            boolean bl = false;
            preflightCheckStatus = this$0.fromTupleToPreflightCheckStatus(tuple2);
        } else {
            preflightCheckStatus = null;
        }
        return preflightCheckStatus;
    }

    private static final void getByExecutionId$lambda$8() {
    }
}

