/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreflightCheckCompletionEvent;
import com.atlassian.jira.migration.execution.MigrationExecutionService;
import com.atlassian.jira.migration.platform.ContainerStatus;
import com.atlassian.jira.migration.platform.PlatformMigrationStatus;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.SiteContainer;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.platform.TransferStatusResponse;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.api.CloudId;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001aH\u0007J\b\u0010\u001e\u001a\u00020\u001aH\u0007J\u0016\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!H\u0002J\b\u0010\"\u001a\u00020\u001aH\u0007J\u0016\u0010#\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightCompletionEventHandler;", "", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "eventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "migrationExecutionService", "Lcom/atlassian/jira/migration/execution/MigrationExecutionService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "(Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/execution/MigrationExecutionService;Lcom/atlassian/jira/migration/platform/PlatformService;)V", "getPreflightMigrationStatus", "Lcom/atlassian/jira/migration/platform/PlatformMigrationStatus;", "isSuccess", "", "allChecksPassed", "isCancelled", "hasRunningTransfer", "cloudId", "Lcom/atlassian/migration/api/CloudId;", "preflightId", "Lcom/atlassian/migration/api/MigrationId;", "(Lcom/atlassian/migration/api/CloudId;Lcom/atlassian/migration/api/MigrationId;)Ljava/lang/Boolean;", "onPreflightCompletionEvent", "", "event", "Lcom/atlassian/jira/migration/events/PreflightCheckCompletionEvent;", "postConstruct", "preDestroy", "runWithJiraThreadLocalUtil", "block", "Lkotlin/Function0;", "threadSleep", "tryLock", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightCompletionEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightCompletionEventHandler.kt\ncom/atlassian/jira/migration/preflight/PreflightCompletionEventHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1747#2,3:146\n*S KotlinDebug\n*F\n+ 1 PreflightCompletionEventHandler.kt\ncom/atlassian/jira/migration/preflight/PreflightCompletionEventHandler\n*L\n130#1:146,3\n*E\n"})
public final class PreflightCompletionEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationEventBus eventBus;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final MigrationExecutionService migrationExecutionService;
    @NotNull
    private final PlatformService platformService;
    private static final Logger log = LoggerFactory.getLogger(PreflightCompletionEventHandler.class);
    @NotNull
    public static final String PREFLIGHT_MIGRATION_STATUS_LOCK = "jcma.preflight.migration.status";
    public static final long THIRTY = 30L;
    public static final int MAX_NUMBER_OF_LOOP = 5;

    @Inject
    public PreflightCompletionEventHandler(@NotNull DiscoveryService discoveryService, @NotNull MigrationEventBus eventBus, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull MigrationExecutionService migrationExecutionService, @NotNull PlatformService platformService) {
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)migrationExecutionService, (String)"migrationExecutionService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        this.discoveryService = discoveryService;
        this.eventBus = eventBus;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.migrationExecutionService = migrationExecutionService;
        this.platformService = platformService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public final void onPreflightCompletionEvent(@NotNull PreflightCheckCompletionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getPreflightId() == null) {
            log.info("No preflight ID found.");
            return;
        }
        log.info("Handle preflight completion event...");
        this.runWithJiraThreadLocalUtil((Function0<Unit>)((Function0)new Function0<Unit>(this, event){
            final /* synthetic */ PreflightCompletionEventHandler this$0;
            final /* synthetic */ PreflightCheckCompletionEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(0);
            }

            public final void invoke() {
                PreflightCompletionEventHandler.access$tryLock(this.this$0, (Function0)new Function0<Unit>(this.this$0, this.$event){
                    final /* synthetic */ PreflightCompletionEventHandler this$0;
                    final /* synthetic */ PreflightCheckCompletionEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            Object object = PreflightCompletionEventHandler.access$getDiscoveryService$p(this.this$0).retrieveCloudSiteForCloudId(this.$event.getCloudId());
                            if (object != null && (object = object.getContainerToken()) != null) {
                                Object object2 = object;
                                PreflightCompletionEventHandler preflightCompletionEventHandler = this.this$0;
                                PreflightCheckCompletionEvent preflightCheckCompletionEvent = this.$event;
                                Object containerToken = object2;
                                boolean bl = false;
                                int loopCount = 1;
                                while (loopCount++ <= 5 && Intrinsics.areEqual((Object)preflightCompletionEventHandler.hasRunningTransfer(new CloudId(preflightCheckCompletionEvent.getCloudId()), preflightCheckCompletionEvent.getPreflightId()), (Object)true)) {
                                    PreflightCompletionEventHandler.access$getLog$cp().info("preflight migration " + preflightCheckCompletionEvent.getPreflightId() + " has transfer in running state, waiting...");
                                    preflightCompletionEventHandler.threadSleep();
                                }
                                PreflightCompletionEventHandler.access$getMigrationExecutionService$p(preflightCompletionEventHandler).queuePreflightStatusUpdate(new ContainerToken((String)containerToken), preflightCheckCompletionEvent.getPreflightId(), preflightCheckCompletionEvent.getPreflightContainerId(), PreflightCompletionEventHandler.access$getPreflightMigrationStatus(preflightCompletionEventHandler, preflightCheckCompletionEvent.getExecutionSuccess(), preflightCheckCompletionEvent.getAllChecksPassed(), preflightCheckCompletionEvent.isCancelled()), ContainerStatus.SUCCESS);
                            }
                        }
                        catch (Exception e) {
                            PreflightCompletionEventHandler.access$getLog$cp().error("Exception during updating preflight migration status.", (Throwable)e);
                        }
                    }
                });
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runWithJiraThreadLocalUtil(Function0<Unit> block) {
        this.jiraThreadLocalUtil.preCall();
        try {
            block.invoke();
        }
        finally {
            this.jiraThreadLocalUtil.postCall(org.apache.log4j.Logger.getLogger(PreflightCompletionEventHandler.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryLock(Function0<Unit> block) {
        ClusterLock lock = this.discoveryService.getLockForName(PREFLIGHT_MIGRATION_STATUS_LOCK);
        if (lock.tryLock()) {
            log.debug("Obtained a cluster lock for updating preflight migration status.");
            try {
                block.invoke();
            }
            finally {
                lock.unlock();
            }
        } else {
            log.debug("Failed to obtain a cluster lock for updating preflight migration status.");
        }
    }

    private final PlatformMigrationStatus getPreflightMigrationStatus(boolean isSuccess, boolean allChecksPassed, boolean isCancelled) {
        return isCancelled ? PlatformMigrationStatus.CANCELLED : (!isSuccess ? PlatformMigrationStatus.FAILED : (allChecksPassed ? PlatformMigrationStatus.SUCCESS : PlatformMigrationStatus.INCOMPLETE));
    }

    @VisibleForTesting
    @Nullable
    public final Boolean hasRunningTransfer(@NotNull CloudId cloudId2, @NotNull MigrationId preflightId) {
        Boolean bl;
        List<TransferStatusResponse> list;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)preflightId, (String)"preflightId");
        SiteContainer siteContainer = this.platformService.getPreflightContainer(cloudId2, preflightId);
        if (siteContainer != null && (list = siteContainer.getTransfers()) != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TransferStatusResponse transfer = (TransferStatusResponse)element$iv;
                        boolean bl3 = false;
                        TransferStatus transferStatus = transfer.getStatus();
                        boolean bl4 = transferStatus != null ? !transferStatus.isCompleted() : false;
                        if (!bl4) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = null;
        }
        return bl;
    }

    @VisibleForTesting
    public final void threadSleep() {
        Thread.sleep(Duration.ofSeconds(30L).toMillis());
    }

    public static final /* synthetic */ void access$tryLock(PreflightCompletionEventHandler $this, Function0 block) {
        $this.tryLock((Function0<Unit>)block);
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(PreflightCompletionEventHandler $this) {
        return $this.discoveryService;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ MigrationExecutionService access$getMigrationExecutionService$p(PreflightCompletionEventHandler $this) {
        return $this.migrationExecutionService;
    }

    public static final /* synthetic */ PlatformMigrationStatus access$getPreflightMigrationStatus(PreflightCompletionEventHandler $this, boolean isSuccess, boolean allChecksPassed, boolean isCancelled) {
        return $this.getPreflightMigrationStatus(isSuccess, allChecksPassed, isCancelled);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightCompletionEventHandler$Companion;", "", "()V", "MAX_NUMBER_OF_LOOP", "", "PREFLIGHT_MIGRATION_STATUS_LOCK", "", "getPREFLIGHT_MIGRATION_STATUS_LOCK$annotations", "THIRTY", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPREFLIGHT_MIGRATION_STATUS_LOCK$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

