/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.jira.migration.preflight.PreflightLockTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightLockRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "clearLocks", "", "getLocks", "", "", "lock", "", "planId", "unlock", "Companion", "jira-migration-plugin"})
public final class PreflightLockRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(PreflightLockRepository.class);

    @Inject
    public PreflightLockRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    public final boolean lock(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Object object = this.databaseAccessor.run(arg_0 -> PreflightLockRepository.lock$lambda$2(this, planId, arg_0), PreflightLockRepository::lock$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Boolean)object;
    }

    public final boolean unlock(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Object object = this.databaseAccessor.run(arg_0 -> PreflightLockRepository.unlock$lambda$4(planId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Boolean)object;
    }

    @NotNull
    public final List<String> getLocks() {
        Object object = this.databaseAccessor.run(PreflightLockRepository::getLocks$lambda$5, PreflightLockRepository::getLocks$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public final void clearLocks() {
        this.databaseAccessor.run(PreflightLockRepository::clearLocks$lambda$7, OnRollback.NOOP);
    }

    private static final Boolean lock$lambda$2(PreflightLockRepository this$0, String $planId, DatabaseConnection db) {
        Object object;
        Object $this$lock_u24lambda_u242_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        Object object2 = this$0;
        try {
            $this$lock_u24lambda_u242_u24lambda_u240 = object2;
            boolean bl = false;
            long rowsAffected = db.insert((RelationalPath)PreflightLockTable.Companion.getPREFLIGHT_LOCK_TABLE()).set((Path)PreflightLockTable.Companion.getPREFLIGHT_LOCK_TABLE().getPLAN_ID(), (Object)$planId).execute();
            boolean success = rowsAffected == 1L;
            log.info((success ? "Acquired" : "Failed to acquire") + " lock for planId: " + $planId);
            $this$lock_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)success);
        }
        catch (Throwable bl) {
            $this$lock_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$lock_u24lambda_u242_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            log.info("Failed to acquire lock for planId: " + $planId);
            object = false;
        }
        return (Boolean)object;
    }

    private static final void lock$lambda$3() {
    }

    private static final Boolean unlock$lambda$4(String $planId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        long rowsAffected = db.delete((RelationalPath)PreflightLockTable.Companion.getPREFLIGHT_LOCK_TABLE()).where((Predicate)PreflightLockTable.Companion.getPREFLIGHT_LOCK_TABLE().getPLAN_ID().eq((Object)$planId)).execute();
        log.info("Released lock for planId: " + $planId);
        return rowsAffected == 1L;
    }

    private static final List getLocks$lambda$5(DatabaseConnection db) {
        List list = ((SQLQuery)db.select((Expression)PreflightLockTable.Companion.getPREFLIGHT_LOCK_TABLE().getPLAN_ID()).from((Expression)PreflightLockTable.Companion.getPREFLIGHT_LOCK_TABLE())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return CollectionsKt.toList((Iterable)list);
    }

    private static final void getLocks$lambda$6() {
    }

    private static final Long clearLocks$lambda$7(DatabaseConnection db) {
        return db.delete((RelationalPath)PreflightLockTable.Companion.getPREFLIGHT_LOCK_TABLE()).execute();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightLockRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

