/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.jira.migration.preflight.PreflightMandatoryUrlsCheckResult;
import com.atlassian.jira.migration.preflight.PreflightMandatoryUrlsService;
import com.atlassian.jira.migration.preflight.UrlAccessibilityCheckService;
import com.atlassian.jira.migration.preflight.model.ResourceDetail;
import com.atlassian.jira.migration.preflight.model.WhitelistUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsCheck;", "", "urlAccessibilityCheckService", "Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService;", "preflightMandatoryUrlsService", "Lcom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsService;", "(Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService;Lcom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsService;)V", "performCheck", "Lcom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsCheckResult;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightMandatoryUrlsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightMandatoryUrlsCheck.kt\ncom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1549#2:38\n1620#2,3:39\n766#2:42\n857#2,2:43\n1179#2,2:45\n1253#2,4:47\n1549#2:51\n1620#2,3:52\n*S KotlinDebug\n*F\n+ 1 PreflightMandatoryUrlsCheck.kt\ncom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsCheck\n*L\n18#1:38\n18#1:39,3\n19#1:42\n19#1:43,2\n20#1:45,2\n20#1:47,4\n28#1:51\n28#1:52,3\n*E\n"})
public final class PreflightMandatoryUrlsCheck {
    @NotNull
    private final UrlAccessibilityCheckService urlAccessibilityCheckService;
    @NotNull
    private final PreflightMandatoryUrlsService preflightMandatoryUrlsService;

    @Inject
    public PreflightMandatoryUrlsCheck(@NotNull UrlAccessibilityCheckService urlAccessibilityCheckService, @NotNull PreflightMandatoryUrlsService preflightMandatoryUrlsService) {
        Intrinsics.checkNotNullParameter((Object)urlAccessibilityCheckService, (String)"urlAccessibilityCheckService");
        Intrinsics.checkNotNullParameter((Object)preflightMandatoryUrlsService, (String)"preflightMandatoryUrlsService");
        this.urlAccessibilityCheckService = urlAccessibilityCheckService;
        this.preflightMandatoryUrlsService = preflightMandatoryUrlsService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PreflightMandatoryUrlsCheckResult performCheck() {
        PreflightMandatoryUrlsCheckResult preflightMandatoryUrlsCheckResult;
        boolean success;
        Object it;
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        UrlAccessibilityCheckService.ReachableResource it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List<WhitelistUrl> urls = this.preflightMandatoryUrlsService.getUrls();
        Iterable $this$map$iv = urls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            WhitelistUrl whitelistUrl = (WhitelistUrl)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.urlAccessibilityCheckService.checkResource((WhitelistUrl)((Object)it2)));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (UrlAccessibilityCheckService.ReachableResource)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isReachable().isSuccessful())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            it = (UrlAccessibilityCheckService.ReachableResource)element$iv$iv;
            boolean bl2 = false;
            it = TuplesKt.to((Object)new WhitelistUrl(((UrlAccessibilityCheckService.ReachableResource)it).getMigrationAllowUrlName(), ((UrlAccessibilityCheckService.ReachableResource)it).getUrl()), (Object)new ResourceDetail(((UrlAccessibilityCheckService.ReachableResource)it).getUrl(), ((UrlAccessibilityCheckService.ReachableResource)it).isBlocking(), ((UrlAccessibilityCheckService.ReachableResource)it).isReachable().getType()));
            bl.put(it.getFirst(), it.getSecond());
        }
        Object notReachableResources2 = destination$iv$iv2;
        boolean bl = success = notReachableResources2.isEmpty() && !this.urlAccessibilityCheckService.checkForBlockingURL(notReachableResources2.values());
        if (success) {
            preflightMandatoryUrlsCheckResult = new PreflightMandatoryUrlsCheckResult(true, SetsKt.emptySet());
        } else {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = this.urlAccessibilityCheckService.replaceUrlsWithWildcards((Map<WhitelistUrl, ResourceDetail>)notReachableResources2).values();
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (ResourceDetail)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add(((ResourceDetail)it).getUrl());
            }
            Set errorUrls = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            preflightMandatoryUrlsCheckResult = new PreflightMandatoryUrlsCheckResult(false, errorUrls);
        }
        return preflightMandatoryUrlsCheckResult;
    }
}

