/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.events.CrowdEventDetectionService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreflightCheckGenericEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.PreflightCheckResult;
import com.atlassian.jira.migration.preflight.PreflightRepository;
import com.atlassian.jira.migration.preflight.model.CheckMode;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014J\u0016\u0010(\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u0014J\u0018\u0010+\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014J\u0018\u0010,\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0002J$\u0010-\u001a\u00020\u001d2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J \u00101\u001a\u00020&2\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J \u00107\u001a\u00020&2\u0006\u00102\u001a\u0002002\u0006\u00108\u001a\u0002092\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010:\u001a\u00020&2\u0006\u00102\u001a\u000200H\u0002J\u0016\u0010;\u001a\u00020<2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u0015J\u0018\u0010>\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\u0015H\u0002J\u0018\u0010@\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R4\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00150\u00128\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00150\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightPersistenceManager;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "preflightRepository", "Lcom/atlassian/jira/migration/preflight/PreflightRepository;", "features", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "configService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "crowdEventDetectionService", "Lcom/atlassian/jira/migration/events/CrowdEventDetectionService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/preflight/PreflightRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/events/CrowdEventDetectionService;Lcom/atlassian/cache/CacheManager;)V", "cacheLoader", "Lcom/atlassian/cache/CacheLoader;", "Lkotlin/Pair;", "", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "getCacheLoader$jira_migration_plugin$annotations", "()V", "getCacheLoader$jira_migration_plugin", "()Lcom/atlassian/cache/CacheLoader;", "statusCache", "Lcom/atlassian/cache/Cache;", "buildFinalPreflightChecksToRemoveSet", "", "executionId", "uniqueId", "checksToRemove", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "checkMode", "Lcom/atlassian/jira/migration/preflight/model/CheckMode;", "isUpdatedAllInOnPbpPlan", "", "deletePreflightCheckResultFromDB", "deleteResult", "checkType", "deleteResults", "fetchResult", "fetchResultFile", "handleUdcChecksExpiration", "preflightCheckResults", "", "Lcom/atlassian/jira/migration/preflight/PreflightCheckResult;", "hasDuplicatedConfigDrifted", "preflightCheckResult", "duplicatedEmailsConfig", "Lcom/atlassian/jira/migration/email/DuplicatedEmailsConfig;", "udcMode", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UDCMode;", "hasInvalidConfigDrifted", "invalidEmailsConfig", "Lcom/atlassian/jira/migration/email/InvalidEmailsConfig;", "isUdcCheckResultExpired", "persistResult", "Ljava/nio/file/Path;", "result", "persistResultInDB", "checkStatus", "shouldSkipPreflight2", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightPersistenceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightPersistenceManager.kt\ncom/atlassian/jira/migration/preflight/PreflightPersistenceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,313:1\n1#2:314\n1855#3,2:315\n11065#4:317\n11400#4,3:318\n*S KotlinDebug\n*F\n+ 1 PreflightPersistenceManager.kt\ncom/atlassian/jira/migration/preflight/PreflightPersistenceManager\n*L\n141#1:315,2\n297#1:317\n297#1:318,3\n*E\n"})
public final class PreflightPersistenceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final PreflightRepository preflightRepository;
    @NotNull
    private final MigrationFeatures features;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final GlobalEmailFixesConfigService configService;
    @NotNull
    private final CrowdEventDetectionService crowdEventDetectionService;
    @NotNull
    private final CacheLoader<Pair<String, String>, CheckStatus> cacheLoader;
    @NotNull
    private final Cache<Pair<String, String>, CheckStatus> statusCache;
    private static final Logger log = LoggerFactory.getLogger(PreflightPersistenceManager.class);
    @NotNull
    private static final String CACHE_NAME = "PREFLIGHT_STATUS_CACHE";
    @NotNull
    private static final String FILE_NOT_FOUND_ERROR_TYPE = "FILE_NOT_FOUND_ERROR_TYPE";
    private static final int THREE_HOURS_TO_MILLI = 10800000;

    @Inject
    public PreflightPersistenceManager(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull PreflightRepository preflightRepository, @NotNull MigrationFeatures features, @NotNull MigrationEventBus migrationEventBus, @NotNull GlobalEmailFixesConfigService configService, @NotNull CrowdEventDetectionService crowdEventDetectionService, @NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)preflightRepository, (String)"preflightRepository");
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)crowdEventDetectionService, (String)"crowdEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        this.localFileDataOutput = localFileDataOutput;
        this.preflightRepository = preflightRepository;
        this.features = features;
        this.migrationEventBus = migrationEventBus;
        this.configService = configService;
        this.crowdEventDetectionService = crowdEventDetectionService;
        this.cacheLoader = arg_0 -> PreflightPersistenceManager._init_$lambda$0(this, arg_0);
        Cache cache2 = cacheManager.getCache(CACHE_NAME, this.cacheLoader, new CacheSettingsBuilder().local().expireAfterAccess(1L, TimeUnit.HOURS).build());
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.statusCache = cache2;
    }

    @NotNull
    public final CacheLoader<Pair<String, String>, CheckStatus> getCacheLoader$jira_migration_plugin() {
        return this.cacheLoader;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCacheLoader$jira_migration_plugin$annotations() {
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public final Path persistResult(@NotNull String executionId, @NotNull CheckStatus result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void persistResultInDB(String executionId, CheckStatus checkStatus) {
        try {
            String string = checkStatus.checkType;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
            int n = CheckType.valueOf(string).ordinal();
            Long l = checkStatus.lastExecutionTime;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"lastExecutionTime");
            this.preflightRepository.upsertPreflightResult(executionId, n, ((Number)l).longValue());
        }
        catch (Throwable t) {
            log.error("Failed to persist pre-flight CheckResult for executionId " + executionId + " and type " + checkStatus.checkType, t);
        }
    }

    @Nullable
    public final CheckStatus fetchResult(@NotNull String executionId, @NotNull String checkType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)checkType, (String)"checkType");
        try {
            CheckStatus checkStatus;
            CheckStatus checkStatus2;
            log.debug("Fetching pre-flight CheckStatus for executionId=" + executionId + " and checkType=" + checkType);
            CheckStatus $this$fetchResult_u24lambda_u244 = checkStatus2 = (checkStatus = (CheckStatus)this.statusCache.get((Object)TuplesKt.to((Object)executionId, (Object)checkType)));
            boolean bl = false;
            log.debug("Found pre-flight CheckStatus for executionId=" + executionId + " and checkType=" + checkType);
            CheckStatus checkStatus3 = checkStatus;
            if (StringsKt.equals$default((String)(checkStatus3 != null ? checkStatus3.checkType : null), (String)FILE_NOT_FOUND_ERROR_TYPE, (boolean)false, (int)2, null)) {
                return null;
            }
            return checkStatus;
        }
        catch (Throwable t) {
            log.error("Failed to fetch pre-flight CheckStatus with executionId=" + executionId + " and checkType=" + checkType, t);
            return null;
        }
    }

    public final void buildFinalPreflightChecksToRemoveSet(@NotNull String executionId, @NotNull String uniqueId, @NotNull EnumSet<CheckType> checksToRemove, @NotNull CheckMode checkMode, boolean isUpdatedAllInOnPbpPlan) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter(checksToRemove, (String)"checksToRemove");
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        log.debug("Fetching pre-flight CheckStatus for executionId=" + executionId);
        Set checkResults = new LinkedHashSet();
        try {
            checkResults = CollectionsKt.toMutableSet((Iterable)this.preflightRepository.findPreflightCheckResults(executionId));
        }
        catch (Throwable t) {
            log.error("Failed to fetch pre-flight CheckResult for executionId " + executionId, t);
        }
        this.handleUdcChecksExpiration(checkResults, checksToRemove);
        if (this.shouldSkipPreflight2(checkMode, isUpdatedAllInOnPbpPlan)) {
            Iterable $this$forEach$iv = checkResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreflightCheckResult it = (PreflightCheckResult)element$iv;
                boolean bl = false;
                if (System.currentTimeMillis() - it.getLastExecutionTime() >= 10800000L) continue;
                log.info("Skipping preflight check with name=" + (Object)((Object)CheckType.values()[it.getCheckId()]) + " for executionID=" + executionId);
                checksToRemove.add(CheckType.values()[it.getCheckId()]);
                this.migrationEventBus.post(new PreflightCheckGenericEvent(executionId, uniqueId, 0L, true, false, CheckType.values()[it.getCheckId()], true, 0L, CheckMode.Preflight2, true));
            }
        }
    }

    public static /* synthetic */ void buildFinalPreflightChecksToRemoveSet$default(PreflightPersistenceManager preflightPersistenceManager, String string, String string2, EnumSet enumSet, CheckMode checkMode, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        preflightPersistenceManager.buildFinalPreflightChecksToRemoveSet(string, string2, enumSet, checkMode, bl);
    }

    private final boolean shouldSkipPreflight2(CheckMode checkMode, boolean isUpdatedAllInOnPbpPlan) {
        return !this.features.getDisableSkippingSecondPreflight() && checkMode == CheckMode.Preflight2 && !isUpdatedAllInOnPbpPlan;
    }

    private final void handleUdcChecksExpiration(Set<PreflightCheckResult> preflightCheckResults, EnumSet<CheckType> checksToRemove) {
        DuplicatedEmailsConfig duplicatedEmailsConfig;
        Object v1;
        UDCMode udcMode;
        block5: {
            InvalidEmailsConfig invalidEmailsConfig;
            Object object;
            Object object22;
            block4: {
                Iterable iterable = preflightCheckResults;
                for (Object object22 : iterable) {
                    PreflightCheckResult it = (PreflightCheckResult)object22;
                    boolean bl = false;
                    if (!(it.getCheckId() == CheckType.InvalidEmails.ordinal())) continue;
                    object = object22;
                    break block4;
                }
                object = null;
            }
            PreflightCheckResult invalidEmailsCheckResult = (PreflightCheckResult)object;
            udcMode = this.configService.getUdcModeConfig();
            if (invalidEmailsCheckResult != null && (this.hasInvalidConfigDrifted(invalidEmailsCheckResult, invalidEmailsConfig = this.configService.getInvalidEmailsConfig(), udcMode) || this.isUdcCheckResultExpired(invalidEmailsCheckResult))) {
                checksToRemove.remove((Object)CheckType.InvalidEmails);
                preflightCheckResults.remove(invalidEmailsCheckResult);
            }
            object22 = preflightCheckResults;
            Iterator iterator2 = object22.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                PreflightCheckResult it = (PreflightCheckResult)t;
                boolean bl = false;
                if (!(it.getCheckId() == CheckType.SharedEmails.ordinal())) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        PreflightCheckResult duplicatedEmailsCheckResult = v1;
        if (duplicatedEmailsCheckResult != null && (this.hasDuplicatedConfigDrifted(duplicatedEmailsCheckResult, duplicatedEmailsConfig = this.configService.getDuplicatedEmailsConfig(), udcMode) || this.isUdcCheckResultExpired(duplicatedEmailsCheckResult))) {
            checksToRemove.remove((Object)CheckType.SharedEmails);
            preflightCheckResults.remove(duplicatedEmailsCheckResult);
        }
    }

    private final boolean isUdcCheckResultExpired(PreflightCheckResult preflightCheckResult) {
        if (!this.features.getEnableCrowdEventsPreflightCacheOptimization()) {
            return false;
        }
        long lastUserBaseModificationTime = this.crowdEventDetectionService.getLastUserCreatedOrUpdatedTime();
        boolean isExpired = preflightCheckResult.getLastExecutionTime() < lastUserBaseModificationTime;
        log.info("Checking expiration due to user base modification for check " + (Object)((Object)CheckType.values()[preflightCheckResult.getCheckId()]) + ". Last preflight execution time: " + preflightCheckResult.getLastExecutionTime() + ", last user base modification time: " + lastUserBaseModificationTime + ". Expired = " + isExpired);
        return isExpired;
    }

    private final boolean hasInvalidConfigDrifted(PreflightCheckResult preflightCheckResult, InvalidEmailsConfig invalidEmailsConfig, UDCMode udcMode) {
        CheckStatus fetchResult = this.fetchResult(preflightCheckResult.getExecutionId(), CheckType.values()[preflightCheckResult.getCheckId()].name());
        Object object = fetchResult;
        Object checkResultInvalidConfigOption = object != null && (object = ((CheckStatus)object).checkResult) != null && (object = ((CheckResult)object).details) != null ? object.get("configOption") : null;
        Object object2 = fetchResult;
        Object checkResultUdcMode = object2 != null && (object2 = ((CheckStatus)object2).checkResult) != null && (object2 = ((CheckResult)object2).details) != null ? object2.get("udcMode") : null;
        return checkResultInvalidConfigOption != invalidEmailsConfig.getOnMigration() || checkResultUdcMode != udcMode;
    }

    private final boolean hasDuplicatedConfigDrifted(PreflightCheckResult preflightCheckResult, DuplicatedEmailsConfig duplicatedEmailsConfig, UDCMode udcMode) {
        CheckStatus fetchResult = this.fetchResult(preflightCheckResult.getExecutionId(), CheckType.values()[preflightCheckResult.getCheckId()].name());
        Object object = fetchResult;
        Object checkResultDuplicatedConfigOption = object != null && (object = ((CheckStatus)object).checkResult) != null && (object = ((CheckResult)object).details) != null ? object.get("configOption") : null;
        Object object2 = fetchResult;
        Object checkResultUdcMode = object2 != null && (object2 = ((CheckStatus)object2).checkResult) != null && (object2 = ((CheckResult)object2).details) != null ? object2.get("udcMode") : null;
        return checkResultDuplicatedConfigOption != duplicatedEmailsConfig.getOnMigration() || checkResultUdcMode != udcMode;
    }

    public final void deletePreflightCheckResultFromDB(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        try {
            this.preflightRepository.deletePreflightCheckResults(executionId);
        }
        catch (Throwable t) {
            log.error("Failed to delete pre-flight CheckResult for executionId " + executionId, t);
        }
    }

    /*
     * Exception decompiling
     */
    private final CheckStatus fetchResultFile(String executionId, String checkType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean deleteResult(@NotNull String executionId, @NotNull String checkType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)checkType, (String)"checkType");
        Path executionDirectory = this.localFileDataOutput.migrationCheckDirectory(executionId);
        Path filePath = Companion.createFilePath(executionDirectory, executionId, checkType);
        try {
            Files.deleteIfExists(filePath);
        }
        catch (Throwable t) {
            log.error("Failed to delete pre-flight checks file " + filePath.toAbsolutePath(), t);
        }
        this.statusCache.remove((Object)TuplesKt.to((Object)executionId, (Object)checkType));
        return Files.notExists(filePath, new LinkOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean deleteResults(@NotNull String executionId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Path executionDirectoryPath = this.localFileDataOutput.migrationCheckDirectory(executionId);
        try {
            this.localFileDataOutput.deleteDirectoryIfExists(executionDirectoryPath);
        }
        catch (Throwable t) {
            log.error("Failed to delete pre-flight checks directory " + executionDirectoryPath.toAbsolutePath(), t);
        }
        CheckType[] $this$map$iv = CheckType.values();
        boolean $i$f$map = false;
        CheckType[] checkTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.statusCache.remove((Object)TuplesKt.to((Object)executionId, (Object)it.toString()));
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return Files.notExists(executionDirectoryPath, new LinkOption[0]);
    }

    private static final CheckStatus _init_$lambda$0(PreflightPersistenceManager this$0, Pair key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this$0.fetchResultFile((String)key.getFirst(), (String)key.getSecond());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightPersistenceManager$Companion;", "", "()V", "CACHE_NAME", "", "FILE_NOT_FOUND_ERROR_TYPE", "THREE_HOURS_TO_MILLI", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createFilePath", "Ljava/nio/file/Path;", "directory", "executionId", "checkType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path createFilePath(@NotNull Path directory, @NotNull String executionId, @NotNull String checkType) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter((Object)checkType, (String)"checkType");
            Path path = directory.resolve(executionId + '-' + checkType + ".ser");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

